/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.action;

import oracle.dbtools.migration.parser.Db2TranslaterInvoke;
import oracle.dbtools.migration.parser.defaults.DefaultTranslationContext;
import oracle.dbtools.migration.parser.defaults.OracleSQLConstants;
import oracle.dbtools.migration.parser.ext.ExtStringTemplate;
import oracle.dbtools.migration.parser.helper.TemplateManager;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;

public class Db2WalkerAction {
    public ExtStringTemplate createViewTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("createView");
        return extStringTemplate;
    }

    public ExtStringTemplate createSelectTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("selectStatement");
        return extStringTemplate;
    }

    public ExtStringTemplate createFromTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("fromStatement");
        return extStringTemplate;
    }

    public ExtStringTemplate createEncloseInParenthesis() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("encloseInParenthesis");
        return extStringTemplate;
    }

    public ExtStringTemplate createDbObjectTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("dbObject");
        return extStringTemplate;
    }

    public ExtStringTemplate createLeftOutJoinTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("leftOutJoin");
        return extStringTemplate;
    }

    public ExtStringTemplate createRightOutJoinTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("rightOutJoin");
        return extStringTemplate;
    }

    public void setOutputTemplate(ExtStringTemplate extStringTemplate) {
        Db2TranslaterInvoke.getInstance().getTemplateManager().setOutputTemplate(extStringTemplate);
    }

    public ExtStringTemplate createDummyTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("dummyTemplate");
        return extStringTemplate;
    }

    public ExtStringTemplate createSubStrFuncTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("subStrFunc");
        return extStringTemplate;
    }

    public ExtStringTemplate createCountFuncTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("countFunc");
        return extStringTemplate;
    }

    public ExtStringTemplate createValueFuncTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("valueFunc");
        return extStringTemplate;
    }

    public ExtStringTemplate createMinFuncTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("minFunc");
        return extStringTemplate;
    }

    public ExtStringTemplate createMaxFuncTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("maxFunc");
        return extStringTemplate;
    }

    public ExtStringTemplate createSumFuncTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("sumFunc");
        return extStringTemplate;
    }

    public ExtStringTemplate createUcaseFuncTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("ucaseFunc");
        return extStringTemplate;
    }

    public ExtStringTemplate createCheckOptionTemplate() {
        ExtStringTemplate extStringTemplate = Db2TranslaterInvoke.getInstance().getTemplateManager().getExtTemplate("withCheckOption");
        return extStringTemplate;
    }

    public static TemplateManager getTemplateManager() {
        return Db2TranslaterInvoke.getInstance().getTemplateManager();
    }

    public boolean getTranslationContextFlag() {
        return Db2TranslaterInvoke.getInstance().getTranslationContextFlag();
    }

    public void determineGenerationOrder(ExtStringTemplate extStringTemplate) {
        Db2TranslaterInvoke db2TranslaterInvoke = Db2TranslaterInvoke.getInstance();
        TranslationDBObject translationDBObject = db2TranslaterInvoke.getSourceDbObject();
        if (translationDBObject == null) {
            return;
        }
        if (!translationDBObject.getType().equals(TranslationObjectType.VIEW_TYPE)) {
            return;
        }
        ITranslationContext iTranslationContext = db2TranslaterInvoke.getTranslationContext();
        if (!iTranslationContext.getUseViewList()) {
            return;
        }
        iTranslationContext.determineViewGenerationOrder(translationDBObject, extStringTemplate);
    }

    public String getTheNewName(ExtStringTemplate extStringTemplate) {
        Db2TranslaterInvoke db2TranslaterInvoke = Db2TranslaterInvoke.getInstance();
        ITranslationContext iTranslationContext = db2TranslaterInvoke.getTranslationContext();
        if (extStringTemplate.toString().trim() == null) {
            return extStringTemplate.toString();
        }
        if (iTranslationContext == null) {
            String string = DefaultTranslationContext.createValidIdentifier((String)extStringTemplate.toString(), (String)"object");
            return string;
        }
        String string = iTranslationContext.getChangedIdentifierName(extStringTemplate.toString().trim());
        if (string == null) {
            string = extStringTemplate.toString();
        }
        return string;
    }

    private String getNonReservedOracleName(String string) {
        if (OracleSQLConstants.isRservedWord((String)string) || OracleSQLConstants.isSignificantWord((String)string)) {
            string = string.trim() + "_";
        }
        return string;
    }

    public String charLengthFunctionName(ExtStringTemplate extStringTemplate) {
        String string = extStringTemplate.toString();
        if (string == null) {
            return "LENGTH";
        }
        if (string.equalsIgnoreCase("OCTETS")) {
            return "LENGTHB";
        }
        if (string.equalsIgnoreCase("CODEUNITS16")) {
            return "LENGTH2";
        }
        if (string.equalsIgnoreCase("CODEUNITS32")) {
            return "LENGTH4";
        }
        return "LENGTH";
    }

    public String locateStringFunctionName(ExtStringTemplate extStringTemplate) {
        String string = extStringTemplate.toString();
        if (string == null) {
            return "INSTR";
        }
        if (string.equalsIgnoreCase("OCTETS")) {
            return "INSTRB";
        }
        if (string.equalsIgnoreCase("CODEUNITS16")) {
            return "INSTR2";
        }
        if (string.equalsIgnoreCase("CODEUNITS32")) {
            return "INSTR4";
        }
        return "INSTR";
    }

    public String locateSubstringFunctionName(ExtStringTemplate extStringTemplate) {
        String string = extStringTemplate.toString();
        if (string == null) {
            return "SUBSTR";
        }
        if (string.equalsIgnoreCase("OCTETS")) {
            return "SUBSTRB";
        }
        if (string.equalsIgnoreCase("CODEUNITS16")) {
            return "SUBSTR2";
        }
        if (string.equalsIgnoreCase("CODEUNITS32")) {
            return "SUBSTR4";
        }
        return "SUBSTR";
    }

    public String getEmulationPackageName() {
        Db2TranslaterInvoke db2TranslaterInvoke = Db2TranslaterInvoke.getInstance();
        ITranslationContext iTranslationContext = db2TranslaterInvoke.getTranslationContext();
        if (iTranslationContext == null) {
            return db2TranslaterInvoke.getEmulationPackageName();
        }
        return iTranslationContext.getEmulationPackageName();
    }

    public String getFullFuncNameWithPackage(String string) {
        return this.getEmulationPackageName() + "." + string;
    }

    public ExtStringTemplate setIsolationClause(ExtStringTemplate extStringTemplate, ExtStringTemplate extStringTemplate2) {
        String string = extStringTemplate.getValue(1).toString();
        ExtStringTemplate extStringTemplate3 = extStringTemplate2;
        if (string.equalsIgnoreCase("RR")) {
            extStringTemplate3 = Db2WalkerAction.getTemplateManager().getExtTemplate("SROrRCRead");
            extStringTemplate3.setValue(1, (Object)extStringTemplate2);
            extStringTemplate3.setValue(2, (Object)"SERIALIZABLE");
        } else if (string.equalsIgnoreCase("RS")) {
            extStringTemplate3 = Db2WalkerAction.getTemplateManager().getExtTemplate("isolationCommented");
            extStringTemplate3.setValue(1, (Object)extStringTemplate2);
            extStringTemplate3.setValue(2, (Object)extStringTemplate);
        } else if (string.equalsIgnoreCase("CS")) {
            extStringTemplate3 = Db2WalkerAction.getTemplateManager().getExtTemplate("SROrRCRead");
            extStringTemplate3.setValue(1, (Object)extStringTemplate2);
            extStringTemplate3.setValue(2, (Object)"READ COMMITTED");
        } else if (string.equalsIgnoreCase("UR")) {
            extStringTemplate3 = Db2WalkerAction.getTemplateManager().getExtTemplate("isolationCommented");
            extStringTemplate3.setValue(1, (Object)extStringTemplate2);
            extStringTemplate3.setValue(2, (Object)extStringTemplate);
        }
        return extStringTemplate3;
    }

    public String getCommonTableExpName(ExtStringTemplate extStringTemplate) {
        String string = extStringTemplate.toString();
        String[] stringArray = string.split("\\.");
        return stringArray[stringArray.length - 1];
    }

    public void checkForLimitation(ExtStringTemplate extStringTemplate) {
        if (extStringTemplate.toString().trim().equalsIgnoreCase("")) {
            Db2TranslaterInvoke.getInstance().setLimitation();
        }
    }

    public void checkForLimitation() {
        Db2TranslaterInvoke.getInstance().setLimitation();
    }
}

