/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.dbtools.migration.parser.ASTFrame;
import oracle.dbtools.migration.parser.Db2TokenStream;
import oracle.dbtools.migration.parser.antlr3ext.ANTLRCaseInSensitiveStringStream;
import oracle.dbtools.migration.parser.grammar.Db2Lexer;
import oracle.dbtools.migration.parser.grammar.Db2Parser;
import oracle.dbtools.migration.parser.grammar.Db2Walker;
import oracle.dbtools.migration.parser.helper.TemplateManager;
import oracle.dbtools.migration.parser.internalapi.TranslateResultWithASTs;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.ITranslationLogging;
import oracle.dbtools.migration.translation.api.ITranslationManager;
import oracle.dbtools.migration.translation.api.TranslationSession;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public class Db2TranslaterInvoke {
    private static StringTemplateGroup m_templatesGroup;
    private static TemplateManager m_templateManager;
    private static Db2TranslaterInvoke m_Instance;
    private TranslationDBObject m_sourceDBObject = null;
    private ITranslationContext m_context = null;
    private boolean m_nonContextTranslationFlag = false;
    private String m_emulationPackageName = null;
    private boolean m_limitation = false;

    public static void main(String[] stringArray) {
        String string = "create view v_europe as SelecT abc1,abc2,abc3 from table1,table2,table3;";
        Db2TranslaterInvoke db2TranslaterInvoke = Db2TranslaterInvoke.getInstance();
        try {
            db2TranslaterInvoke.invokeTranslator(string, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Db2TranslaterInvoke() {
        this.setTemplateManager();
    }

    public static Db2TranslaterInvoke getInstance() {
        if (m_Instance == null) {
            m_Instance = new Db2TranslaterInvoke();
        }
        return m_Instance;
    }

    public TranslateResultWithASTs invokeTranslatorWithContext(TranslationDBObject translationDBObject, ITranslationContext iTranslationContext, ITranslationLogging iTranslationLogging, ITranslationManager iTranslationManager, TranslationSession translationSession) throws RecognitionException {
        this.m_context = iTranslationContext;
        this.m_sourceDBObject = translationDBObject;
        TranslateResultWithASTs translateResultWithASTs = this.invokeTranslator(translationDBObject.getDdl(), false);
        return translateResultWithASTs;
    }

    public TranslateResultWithASTs invokeTranslator(String string, boolean bl) throws RecognitionException {
        this.m_nonContextTranslationFlag = bl;
        this.loadStringTemplates();
        ANTLRCaseInSensitiveStringStream aNTLRCaseInSensitiveStringStream = new ANTLRCaseInSensitiveStringStream(string);
        Db2Lexer db2Lexer = new Db2Lexer((CharStream)aNTLRCaseInSensitiveStringStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)db2Lexer);
        Db2Parser db2Parser = new Db2Parser((TokenStream)commonTokenStream);
        Db2Parser.start_return start_return2 = null;
        start_return2 = db2Parser.start();
        if (this.m_nonContextTranslationFlag) {
            Db2TranslaterInvoke.displayASTTree(db2Parser.getClass().getSimpleName(), (CommonTree)start_return2.getTree());
        }
        Object object = start_return2.getTree();
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(object);
        ASTFrame aSTFrame = new ASTFrame(db2Parser.getClass().getSimpleName(), (CommonTree)start_return2.getTree());
        if (this.m_limitation) {
            this.m_limitation = false;
            TranslateResultWithASTs translateResultWithASTs = new TranslateResultWithASTs(aSTFrame.getJPanel(), "/*\nTRANSLATION LIMITATION REACHED\n" + string + "\n*/");
            return translateResultWithASTs;
        }
        Db2Walker db2Walker = new Db2Walker((TreeNodeStream)commonTreeNodeStream);
        StringTemplate stringTemplate = null;
        db2Walker.start();
        stringTemplate = this.getTemplateManager().getOutputStringTemplate();
        ANTLRCaseInSensitiveStringStream aNTLRCaseInSensitiveStringStream2 = new ANTLRCaseInSensitiveStringStream(string);
        Db2Lexer db2Lexer2 = new Db2Lexer((CharStream)aNTLRCaseInSensitiveStringStream2);
        String string2 = this.getComments(db2Lexer2);
        TranslateResultWithASTs translateResultWithASTs = new TranslateResultWithASTs(string2 + stringTemplate.toString(), (CommonTree)object);
        return translateResultWithASTs;
    }

    private String getComments(Db2Lexer db2Lexer) {
        Db2TokenStream db2TokenStream = new Db2TokenStream(db2Lexer);
        String string = db2TokenStream.getComments();
        return string;
    }

    private void loadStringTemplates() {
        InputStreamReader inputStreamReader = null;
        InputStream inputStream = this.getClass().getResourceAsStream("templates/db2BaseTemplate.stg");
        inputStreamReader = new InputStreamReader(inputStream);
        m_templatesGroup = new StringTemplateGroup((Reader)inputStreamReader);
        try {
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        m_templateManager.setTemplateGroup(m_templatesGroup);
    }

    private void setTemplateManager() {
        if (m_templateManager == null) {
            m_templateManager = new TemplateManager(null);
        }
    }

    public TemplateManager getTemplateManager() {
        return m_templateManager;
    }

    public boolean getTranslationContextFlag() {
        return this.m_nonContextTranslationFlag;
    }

    private static void displayASTTree(String string, CommonTree commonTree) {
        ASTFrame aSTFrame = new ASTFrame(string, commonTree);
        aSTFrame.setVisible(true);
    }

    public TranslationDBObject getSourceDbObject() {
        return this.m_sourceDBObject;
    }

    public ITranslationContext getTranslationContext() {
        return this.m_context;
    }

    public void setEmulationPackageName(String string) {
        this.m_emulationPackageName = string;
    }

    public String getEmulationPackageName() {
        return this.m_emulationPackageName;
    }

    public void setLimitation() {
        this.m_limitation = true;
    }

    static {
        m_Instance = null;
    }
}

