/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.profile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.TreePath;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.CategoryDefinition;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.HasCategory;
import oracle.jdeveloper.audit.extension.MetricDefinition;
import oracle.jdeveloper.audit.extension.RuleDefinition;
import oracle.jdeveloper.audit.extension.SuppressionSchemeDefinition;
import oracle.jdevimpl.audit.profile.ProfileBundle;
import oracle.jdevimpl.audit.profile.ProfileModel;
import oracle.jdevimpl.audit.swing.AbstractCheckBoxTreeModel;

public class ProfileTreeModel
extends AbstractCheckBoxTreeModel
implements ListDataListener,
PropertyChangeListener {
    private final ProfileModel model;
    private final BeanKind kind;
    private final BranchNode root;
    private final Collator collator = Collator.getInstance();
    private Matcher filter;
    private String filterText;
    private EnumSet<FilterCategory> filterCategories = EnumSet.of(FilterCategory.LABEL, FilterCategory.DESCRIPTION, FilterCategory.MESSAGE);
    private static final Log LOG = new Log("profile", "profile-detail");
    private static final Log LOG_DETAIL = new Log("profile-detail");
    private boolean ignorePropertyChange;

    public ProfileTreeModel(ProfileModel model, BeanKind kind) {
        this.model = model;
        this.kind = kind;
        this.root = new RootNode();
        HashMap<String, BranchNode> categories = new HashMap<String, BranchNode>();
        Collection<BeanDefinition> beans = model.getDefinitions();
        for (BeanDefinition bean : beans) {
            if (!kind.accept(bean)) continue;
            BranchNode parentNode = this.getParentNode(kind.category(bean), categories);
            parentNode.add(new LeafNode(bean));
        }
        model.addListDataListener(this);
        model.addPropertyChangeListener(this);
    }

    private BranchNode getParentNode(CategoryDefinition category, Map<String, BranchNode> categories) {
        if (category == null) {
            return this.root;
        }
        String id = category.getId();
        BranchNode node = categories.get(id);
        if (node == null) {
            BranchNode parentNode = this.getParentNode(category.getCategory(), categories);
            node = new BranchNode(category);
            parentNode.add(node);
            categories.put(id, node);
        }
        return node;
    }

    public BeanKind getKind() {
        return this.kind;
    }

    public String getFilterText() {
        return this.filterText;
    }

    public EnumSet<FilterCategory> getFilterCategories() {
        return this.filterCategories;
    }

    public boolean getFilterCategory(FilterCategory category) {
        return this.filterCategories.contains((Object)category);
    }

    public boolean setFilterText(String text) {
        assert (this.filter == null == (this.filterText == null));
        if (text != null && text.trim().isEmpty()) {
            text = null;
        }
        if (text == null && this.filterText != null) {
            this.filterText = null;
            this.filter = null;
            this.treeChanged();
            return false;
        }
        if (text != null && !text.equals(this.filterText)) {
            this.filterText = text;
            this.filter = Pattern.compile("\\b" + Pattern.quote(text), 2).matcher("");
            this.treeChanged();
            return true;
        }
        return false;
    }

    public boolean setFilterCategory(FilterCategory category, boolean state) {
        boolean changed;
        boolean bl = changed = state ? this.filterCategories.add(category) : this.filterCategories.remove((Object)category);
        if (this.filter == null) {
            return false;
        }
        this.treeChanged();
        return true;
    }

    @Override
    public BeanNode getRoot() {
        return this.root;
    }

    public ExtensionBean getBean(Object node) {
        return ((BeanNode)node).getBean();
    }

    public String getDescription(Object node) {
        return ((BeanNode)node).getDescription();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        assert (LOG.trace("handling property '{0}:{1}' in {2} changed", event.getSource(), (Object)event.getPropertyName(), (Object)this));
        if (this.ignorePropertyChange) {
            return;
        }
        Object source = event.getSource();
        if (!(source instanceof BeanDefinition) || !this.kind.accept((BeanDefinition)source)) {
            return;
        }
        ArrayList<BeanDefinition> categories = new ArrayList<BeanDefinition>();
        for (HasCategory c = (HasCategory)source; c != null; c = c.getCategory()) {
            categories.add((BeanDefinition)((Object)c));
        }
        BeanNode node = this.root;
        TreePath path = new TreePath(node);
        int i = categories.size();
        while (--i >= 0) {
            BeanDefinition category = (BeanDefinition)categories.get(i);
            if ((node = node.getChild(category.getId())) == null) {
                ((BeanDefinition)categories.get(0)).log(Level.SEVERE, new IllegalStateException(), "{0} not child of {1} in {2} (property {3}: {4} -> {5})", category, path, categories, event.getPropertyName(), event.getOldValue(), event.getNewValue());
                break;
            }
            path = path.pathByAddingChild(node);
        }
        this.nodeChanged(path);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (e.getIndex0() < 0 && e.getIndex1() < 0 && this.model.getSelectedItem() != null) {
            this.treeChanged();
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    private class LeafNode
    extends BeanNode {
        public LeafNode(BeanDefinition definition) {
            super(definition);
        }

        @Override
        protected boolean isLeaf() {
            return true;
        }

        @Override
        protected Boolean getState() {
            BeanDefinition definition = this.getDefinition();
            Boolean state = ProfileTreeModel.this.model.isEnabled(definition.getId());
            LOG_DETAIL.trace("getting state of node {0} as {1}", (Object)this, (Object)state);
            return state;
        }

        @Override
        protected void setState(boolean state) {
            LOG.trace("setting state of node {1} to {0}", state, (Object)this);
            BeanDefinition definition = this.getDefinition();
            String id = definition.getId();
            if (state != ProfileTreeModel.this.model.isEnabled(id)) {
                ProfileTreeModel.this.ignorePropertyChange = true;
                ProfileTreeModel.this.model.setEnabled(id, state);
                ProfileTreeModel.this.ignorePropertyChange = false;
            }
        }
    }

    private class BranchNode
    extends BeanNode {
        private final List<BeanNode> list;

        BranchNode(BeanDefinition definition) {
            super(definition);
            this.list = new ArrayList<BeanNode>();
        }

        void add(BeanNode child) {
            int index = Collections.binarySearch(this.list, child);
            this.list.add(index < 0 ? -index - 1 : index + 1, child);
        }

        @Override
        protected List<BeanNode> getChildren() {
            return this.list;
        }
    }

    private class RootNode
    extends BranchNode {
        protected RootNode() {
            super(null);
        }

        @Override
        public String toString() {
            return "<root>";
        }
    }

    private abstract class BeanNode
    extends AbstractCheckBoxTreeModel.CheckBoxNode<BeanNode>
    implements Comparable<BeanNode> {
        private BeanDefinition definition;
        private CollationKey key;

        BeanNode(BeanDefinition definition) {
            super(ProfileTreeModel.this);
            this.definition = definition;
        }

        @Override
        protected boolean isVisible() {
            if (ProfileTreeModel.this.filter == null) {
                return true;
            }
            BeanDefinition bean = this.getDefinition();
            if (bean == null) {
                return true;
            }
            for (FilterCategory category : ProfileTreeModel.this.filterCategories) {
                for (String string : category.strings(bean)) {
                    if (string == null || !ProfileTreeModel.this.filter.reset(string).find()) continue;
                    return true;
                }
            }
            return false;
        }

        String getId() {
            if (this.definition == null) {
                return null;
            }
            return this.definition.getId();
        }

        BeanDefinition getDefinition() {
            return this.definition;
        }

        CollationKey getCollationKey() {
            if (this.key == null) {
                this.key = ProfileTreeModel.this.collator.getCollationKey(this.getLabel());
                assert (this.key != null);
            }
            return this.key;
        }

        @Override
        protected boolean isModified() {
            return ProfileTreeModel.this.model.isModified(this.getId());
        }

        ExtensionBean getBean() {
            return ProfileTreeModel.this.model.getBean(this.getId());
        }

        BeanNode getChild(String id) {
            for (BeanNode child : this.getChildren()) {
                if (!id.equals(child.getId())) continue;
                return child;
            }
            return null;
        }

        @Override
        protected String getLabel() {
            if (this.definition == null) {
                return "?";
            }
            String text = this.definition.label();
            if (text == null) {
                text = "?";
            }
            return text;
        }

        protected String getDescription() {
            if (this.definition == null) {
                return "?";
            }
            return this.definition.description();
        }

        @Override
        public int compareTo(BeanNode that) {
            boolean thatLeaf;
            boolean thisLeaf = this.isLeaf();
            if (thisLeaf == (thatLeaf = that.isLeaf())) {
                return this.getCollationKey().compareTo(that.getCollationKey());
            }
            if (thatLeaf) {
                return -1;
            }
            return 1;
        }

        public String toString() {
            return this.getId();
        }
    }

    public static enum FilterCategory {
        LABEL{

            @Override
            String label() {
                return ProfileBundle.get("filter-category.label.label");
            }

            @Override
            String[] strings(BeanDefinition bean) {
                if (bean instanceof MetricDefinition) {
                    return new String[]{bean.label(), ((MetricDefinition)bean).shortLabel()};
                }
                return new String[]{bean.label()};
            }
        }
        ,
        DESCRIPTION{

            @Override
            String label() {
                return ProfileBundle.get("filter-category.description.label");
            }

            @Override
            String[] strings(BeanDefinition bean) {
                return new String[]{bean.description()};
            }
        }
        ,
        MESSAGE{

            @Override
            String label() {
                return ProfileBundle.get("filter-category.message.label");
            }

            @Override
            String[] strings(BeanDefinition bean) {
                return !(bean instanceof RuleDefinition) ? new String[]{} : ((RuleDefinition)bean).messages();
            }
        }
        ,
        ID{

            @Override
            String label() {
                return ProfileBundle.get("filter-category.id.label");
            }

            @Override
            String[] strings(BeanDefinition bean) {
                return new String[]{bean.getId()};
            }
        };


        abstract String label();

        abstract String[] strings(BeanDefinition var1);
    }

    static enum BeanKind {
        RULE{

            @Override
            boolean accept(BeanDefinition bean) {
                return bean instanceof RuleDefinition && !((RuleDefinition)bean).isAssist();
            }

            @Override
            CategoryDefinition category(BeanDefinition bean) {
                return ((RuleDefinition)bean).getCategory();
            }
        }
        ,
        ASSIST{

            @Override
            boolean accept(BeanDefinition bean) {
                return bean instanceof RuleDefinition && ((RuleDefinition)bean).isAssist();
            }

            @Override
            CategoryDefinition category(BeanDefinition bean) {
                return ((RuleDefinition)bean).getCategory();
            }
        }
        ,
        METRIC{

            @Override
            boolean accept(BeanDefinition bean) {
                return bean instanceof MetricDefinition;
            }

            @Override
            CategoryDefinition category(BeanDefinition bean) {
                return ((MetricDefinition)bean).getCategory();
            }
        }
        ,
        SUPPRESSION_SCHEME{

            @Override
            boolean accept(BeanDefinition bean) {
                return bean instanceof SuppressionSchemeDefinition;
            }

            @Override
            CategoryDefinition category(BeanDefinition bean) {
                return ((SuppressionSchemeDefinition)bean).getCategory();
            }
        };


        abstract boolean accept(BeanDefinition var1);

        abstract CategoryDefinition category(BeanDefinition var1);
    }
}

