/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.service.AuditModelFilter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdevimpl.audit.util.Cache;

public class SeverityFilter
extends AuditModelFilter {
    private String key;
    private boolean[] visible;

    public SeverityFilter() {
        this(false, false, false, false, null);
    }

    public SeverityFilter(boolean showErrors, boolean showWarnings, boolean showIncompletes, boolean showAdvisories) {
        this(showErrors, showWarnings, showIncompletes, showAdvisories, null);
    }

    public SeverityFilter(String persistenceKey) {
        this(true, true, true, true, persistenceKey);
    }

    public SeverityFilter(boolean showErrors, boolean showWarnings, boolean showIncompletes, boolean showAdvisories, String persistenceKey) {
        this.key = persistenceKey;
        this.visible = new boolean[1 + Math.max(Math.max(Severity.ERROR.hashCode(), Severity.WARNING.hashCode()), Math.max(Severity.INCOMPLETE.hashCode(), Severity.ADVISORY.hashCode()))];
        this.visible[Severity.ERROR.hashCode()] = this.read(Severity.ERROR, showErrors);
        this.visible[Severity.WARNING.hashCode()] = this.read(Severity.WARNING, showWarnings);
        this.visible[Severity.INCOMPLETE.hashCode()] = this.read(Severity.INCOMPLETE, showIncompletes);
        this.visible[Severity.ADVISORY.hashCode()] = this.read(Severity.ADVISORY, showAdvisories);
    }

    private boolean read(Severity severity, boolean defaultValue) {
        if (this.key == null) {
            return defaultValue;
        }
        return Cache.get(this.key + "." + severity.toString(), defaultValue);
    }

    private void write(Severity severity, boolean value) {
        if (this.key != null) {
            Cache.put(this.key + "." + severity.toString(), value);
        }
    }

    public void setVisible(Severity severity, boolean visible) {
        int index = severity.hashCode();
        if (this.visible[index] == visible) {
            return;
        }
        this.visible[index] = visible;
        this.write(severity, visible);
        this.fireStateChanged();
    }

    public boolean isVisible(Severity severity) {
        return this.visible[severity.hashCode()];
    }

    public void setShowErrors(boolean visible) {
        this.setVisible(Severity.ERROR, visible);
    }

    public void setShowWarnings(boolean visible) {
        this.setVisible(Severity.WARNING, visible);
    }

    public void setShowIncompletes(boolean visible) {
        this.setVisible(Severity.INCOMPLETE, visible);
    }

    public void setShowAdvisories(boolean visible) {
        this.setVisible(Severity.ADVISORY, visible);
    }

    public boolean isShowErrors() {
        return this.isVisible(Severity.ERROR);
    }

    public boolean isShowWarnings() {
        return this.isVisible(Severity.WARNING);
    }

    public boolean isShowIncompletes() {
        return this.isVisible(Severity.INCOMPLETE);
    }

    public boolean isShowAdvisories() {
        return this.isVisible(Severity.ADVISORY);
    }

    @Override
    public boolean isVisible(Object construct) {
        Violation violation = this.getModel().getViolation(construct);
        return violation == null || this.isVisible(violation.getRule().getSeverity());
    }
}

