/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdevimpl.audit.log.HierarchyFilter;
import oracle.jdevimpl.audit.log.LogBundle;
import oracle.jdevimpl.audit.model.DirectoryModelType;
import oracle.jdevimpl.audit.model.ProjectModelType;
import oracle.jdevimpl.audit.model.RootModelType;
import oracle.jdevimpl.audit.model.UnauditableFileModelType;
import oracle.jdevimpl.audit.model.WorkspaceModelType;
import oracle.jdevimpl.audit.swing.AbstractCheckBoxTreeModel;
import oracle.jdevimpl.audit.swing.CheckBoxTree;
import oracle.jdevimpl.audit.swing.Resources;

public class ConfigureHierarchyPane
implements PopupMenuListener {
    private static final String HELP_TOPIC = "f1_aud_constraints_dlg_html";
    private final HierarchyFilter filter;
    private TypeFilterCheckBoxModel model;
    private JPopupMenu popup;
    private JPanel component;
    private JCheckBox emptyHierarchyCheckBox;
    private CheckBoxTree tree;
    private static final Log LOG = new Log("hierarchy-pane");

    public ConfigureHierarchyPane(HierarchyFilter filter) {
        this.filter = filter;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        LOG.trace("popup will become visible");
        this.createOrResetComponents();
        this.popup = (JPopupMenu)e.getSource();
        this.popup.add(this.component);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        LOG.trace("popup will become invisible");
        assert (this.popup == e.getSource());
        this.popup.remove(this.component);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        LOG.trace("popup will become invisible");
    }

    private void createOrResetComponents() {
        if (this.component == null) {
            this.component = new JPanel(new GridBagLayout());
            this.model = new TypeFilterCheckBoxModel(this.filter);
            this.tree = new CheckBoxTree(this.model);
            this.tree.setVisibleRowCount(8);
            this.tree.setBorder(BorderFactory.createEmptyBorder());
            JLabel treeLabel = Resources.labelFor(this.tree, LogBundle.get("configure-hierarchy.tree.label"));
            RolloverButton closeButton = new RolloverButton(OracleIcons.getIcon((String)"extras/small_close.gif"), LogBundle.get("configure-hierarchy.close.tip"));
            closeButton.addActionListener(new CloseAction());
            JScrollPane scrollPane = new JScrollPane(this.tree, 20, 31);
            scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            this.emptyHierarchyCheckBox = Resources.checkBox(LogBundle.get("configure-hierarchy.empty-hierarchy.label"), this.filter.isEmptyHierarchy());
            this.component.setBackground(this.tree.getBackground());
            this.emptyHierarchyCheckBox.setBackground(this.tree.getBackground());
            scrollPane.setBackground(this.tree.getBackground());
            this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent event) {
                    TreePath pathToExpand = event.getPath();
                    Object nodeToExpand = pathToExpand.getLastPathComponent();
                    LOG.trace("tree will expand {0}", nodeToExpand);
                    TreePath rootPath = new TreePath(ConfigureHierarchyPane.this.model.getRoot());
                    for (TypeFilterCheckBoxModel.TypeFilterCheckBoxNode node : ConfigureHierarchyPane.this.model.getRoot().getChildren()) {
                        TreePath path = rootPath.pathByAddingChild(node);
                        if (node == nodeToExpand || !ConfigureHierarchyPane.this.tree.isExpanded(path)) continue;
                        LOG.trace("collapsing {0}", (Object)node);
                        ConfigureHierarchyPane.this.tree.collapsePath(path);
                    }
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) {
                    LOG.trace("tree will collapse {0}", event.getPath().getLastPathComponent());
                }
            });
            this.component.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
            constraints.gridwidth = 1;
            constraints.insets.bottom = 6;
            this.component.add((Component)treeLabel, constraints);
            constraints.insets.left = 6;
            constraints.weightx = 0.0;
            constraints.gridx = 1;
            this.component.add((Component)closeButton, constraints);
            constraints.gridx = 0;
            constraints.gridwidth = 2;
            constraints.insets.left = 0;
            constraints.weightx = 1.0;
            ++constraints.gridy;
            constraints.fill = 1;
            constraints.weighty = 1.0;
            constraints.insets.bottom = 6;
            this.component.add((Component)scrollPane, constraints);
            constraints.weighty = 0.0;
            ++constraints.gridy;
            constraints.insets.bottom = 0;
            this.component.add((Component)this.emptyHierarchyCheckBox, constraints);
            ++constraints.gridy;
        } else {
            this.tree.setModel(this.model);
            this.emptyHierarchyCheckBox.setSelected(this.filter.isEmptyHierarchy());
        }
    }

    private static class TypeFilterCheckBoxModel
    extends AbstractCheckBoxTreeModel {
        private final HierarchyFilter filter;
        private final TypeFilterCheckBoxNode root;
        private final Map<Class<?>, Boolean> changes = new HashMap();

        private TypeFilterCheckBoxModel(HierarchyFilter filter) {
            this.filter = filter;
            this.root = new TypeFilterCheckBoxNode();
        }

        @Override
        public TypeFilterCheckBoxNode getRoot() {
            return this.root;
        }

        public Map<Class<?>, Boolean> getChanges() {
            return this.changes;
        }

        private class TypeFilterCheckBoxNode
        extends AbstractCheckBoxTreeModel.CheckBoxNode {
            private NodeKind kind;
            private final Class<?> type;
            private final ModelType modelType;
            private List<TypeFilterCheckBoxNode> children;

            private TypeFilterCheckBoxNode() {
                super(TypeFilterCheckBoxModel.this);
                this.kind = NodeKind.ROOT;
                this.modelType = null;
                this.type = null;
                this.children = new ArrayList<TypeFilterCheckBoxNode>();
                LinkedHashSet<Class<? extends ModelType>> coreTypes = new LinkedHashSet<Class<? extends ModelType>>(5);
                coreTypes.add(WorkspaceModelType.class);
                coreTypes.add(ProjectModelType.class);
                coreTypes.add(DirectoryModelType.class);
                coreTypes.add(UnauditableFileModelType.class);
                this.children.add(new TypeFilterCheckBoxNode(coreTypes));
                for (ModelType modelType : TypeFilterCheckBoxModel.this.filter.getModelTypes()) {
                    Class<?> type = modelType.getClass();
                    if (type == RootModelType.class || coreTypes.contains(type)) continue;
                    this.children.add(new TypeFilterCheckBoxNode(modelType));
                }
                Collections.sort(this.children, new Comparator<TypeFilterCheckBoxNode>(){

                    @Override
                    public int compare(TypeFilterCheckBoxNode left, TypeFilterCheckBoxNode right) {
                        return left.getLabel().compareTo(right.getLabel());
                    }
                });
            }

            private TypeFilterCheckBoxNode(Set<Class<? extends ModelType>> coreTypes) {
                super(TypeFilterCheckBoxModel.this);
                this.kind = NodeKind.MODEL_TYPE_CORE;
                this.modelType = null;
                this.type = null;
                this.children = new ArrayList<TypeFilterCheckBoxNode>();
                for (ModelType modelType : TypeFilterCheckBoxModel.this.filter.getModelTypes()) {
                    if (!coreTypes.contains(modelType.getClass())) continue;
                    for (Class<?> type : modelType.getPresentationTypes()) {
                        if (type == null) continue;
                        this.children.add(new TypeFilterCheckBoxNode(modelType, type));
                    }
                }
            }

            private TypeFilterCheckBoxNode(ModelType modelType) {
                super(TypeFilterCheckBoxModel.this);
                this.kind = NodeKind.MODEL_TYPE_FILE;
                this.modelType = modelType;
                this.type = null;
                this.children = new ArrayList<TypeFilterCheckBoxNode>();
                for (Class<?> type : modelType.getPresentationTypes()) {
                    if (type == null) continue;
                    this.children.add(new TypeFilterCheckBoxNode(modelType, type));
                }
            }

            private TypeFilterCheckBoxNode(ModelType modelType, Class<?> type) {
                super(TypeFilterCheckBoxModel.this);
                this.kind = NodeKind.PRESENTATION_TYPE;
                this.modelType = modelType;
                this.type = type;
                this.children = Collections.emptyList();
            }

            Class<?> getType() {
                return this.type;
            }

            @Override
            protected boolean isModified() {
                return TypeFilterCheckBoxModel.this.changes.containsKey(this.type);
            }

            @Override
            protected Boolean getState() {
                switch (this.kind) {
                    case PRESENTATION_TYPE: {
                        boolean visible = TypeFilterCheckBoxModel.this.filter.isVisible(this.type);
                        return this.isModified() ? !visible : visible;
                    }
                }
                return super.getState();
            }

            @Override
            protected void setState(boolean state) {
                switch (this.kind) {
                    case PRESENTATION_TYPE: {
                        if (state == TypeFilterCheckBoxModel.this.filter.isVisible(this.type)) {
                            TypeFilterCheckBoxModel.this.changes.remove(this.type);
                            break;
                        }
                        TypeFilterCheckBoxModel.this.changes.put(this.type, state);
                        break;
                    }
                    default: {
                        super.setState(state);
                    }
                }
            }

            protected List<TypeFilterCheckBoxNode> getChildren() {
                return this.children;
            }

            @Override
            protected boolean isLeaf() {
                return this.kind == NodeKind.PRESENTATION_TYPE;
            }

            @Override
            protected String getLabel() {
                switch (this.kind) {
                    case MODEL_TYPE_CORE: {
                        return LogBundle.get("configure-hierarchy.containers.label");
                    }
                    case MODEL_TYPE_FILE: {
                        return this.modelType.getDefinition().label();
                    }
                    case PRESENTATION_TYPE: {
                        return this.modelType.label(this.type);
                    }
                }
                return "?";
            }

            protected String getTip() {
                switch (this.kind) {
                    case MODEL_TYPE_CORE: {
                        return LogBundle.get("configure-hierarchy.containers.tip");
                    }
                    case MODEL_TYPE_FILE: {
                        return this.modelType.getDefinition().description();
                    }
                    case PRESENTATION_TYPE: {
                        return this.modelType.summary(this.type);
                    }
                }
                return null;
            }

            public String toString() {
                return (Object)((Object)this.kind) + ": " + this.getLabel();
            }
        }

        static enum NodeKind {
            ROOT,
            MODEL_TYPE_CORE,
            MODEL_TYPE_FILE,
            PRESENTATION_TYPE;

        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigureHierarchyPane.this.filter.setAll(ConfigureHierarchyPane.this.filter.isHierarchy(), ConfigureHierarchyPane.this.emptyHierarchyCheckBox.isSelected(), ConfigureHierarchyPane.this.model.getChanges());
            ConfigureHierarchyPane.this.popup.setVisible(false);
        }
    }

    private class RolloverButton
    extends JButton {
        public RolloverButton(Icon icon, String tip) {
            super(icon);
            this.setOpaque(false);
            this.setRolloverEnabled(true);
            this.setBorder(null);
            this.setMargin(new Insets(0, 0, 0, 0));
        }
    }
}

