/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import oracle.javatools.util.FormatBundle;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.bean.BeanCustomizer;
import oracle.jdeveloper.audit.bean.PropertyField;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdevimpl.audit.core.AuditELContext;
import oracle.jdevimpl.audit.core.CoreBundle;
import oracle.jdevimpl.audit.core.DefaultTransformField;
import oracle.jdevimpl.audit.swing.FocusBorder;
import oracle.jdevimpl.audit.util.PropertyDescriptor;

public class RuleCustomizer
extends BeanCustomizer {
    private PropertyDescriptor messageDescriptor;
    private static final FormatBundle BUNDLE = new FormatBundle(CoreBundle.class);

    public Class getType() {
        return Rule.class;
    }

    @Override
    public String[] items(Object bean, String groupName) {
        if (null == groupName) {
            return new String[]{"*", "messages"};
        }
        return null;
    }

    @Override
    public Boolean visible(Object bean, String itemName) {
        if (((Rule)bean).assist()) {
            if ("severity".equals(itemName)) {
                return Boolean.FALSE;
            }
            if ("style".equals(itemName)) {
                return Boolean.FALSE;
            }
            if ("defaultTransformName".equals(itemName)) {
                return Boolean.FALSE;
            }
        } else if ("defaultTransformName".equals(itemName)) {
            return ((Rule)bean).getTransforms().length > 0;
        }
        return null;
    }

    @Override
    public PropertyDescriptor descriptor(Object bean, String propertyName) {
        try {
            if ("messages".equals(propertyName)) {
                if (this.messageDescriptor == null) {
                    this.messageDescriptor = new PropertyDescriptor("messages", String[].class, Rule.class.getMethod("messages", new Class[0]), null, null);
                }
                return this.messageDescriptor;
            }
        }
        catch (NoSuchMethodException e) {
            AuditLogger.error("ExtensionBean introspection failed: {0}", e);
        }
        return null;
    }

    @Override
    public PropertyField field(Object bean, String propertyName) {
        if ("defaultTransformName".equals(propertyName)) {
            Rule rule = (Rule)bean;
            return new DefaultTransformField(new AuditELContext(), rule, rule.getTransforms());
        }
        if ("messages".equals(propertyName)) {
            return new ArrayLabelField(true);
        }
        return null;
    }

    @Override
    public String label(Object bean, String itemName) {
        if ("severity".equals(itemName)) {
            return BUNDLE.get("rule.severity.label");
        }
        if ("style".equals(itemName)) {
            return BUNDLE.get("rule.style.label");
        }
        if ("defaultTransformName".equals(itemName)) {
            return BUNDLE.get("rule.default-transform-name.label");
        }
        if ("messages".equals(itemName)) {
            return BUNDLE.get("rule.messages.label");
        }
        return null;
    }

    public class ArrayLabelField
    extends PropertyField {
        private Box component = Box.createVerticalBox();
        private boolean wrap;

        public ArrayLabelField() {
            this(false);
        }

        public ArrayLabelField(boolean wrap) {
            this.wrap = wrap;
        }

        @Override
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        public boolean getComponentTracksContainerWidth() {
            return this.wrap;
        }

        @Override
        public int getComponentBaseline() {
            if (this.component.getComponentCount() == 0) {
                return -1;
            }
            return this.component.getInsets().top + ArrayLabelField.baseline((JTextArea)this.component.getComponent(0));
        }

        @Override
        public Object getValue() throws Exception {
            String[] value = new String[this.component.getComponentCount()];
            for (int i = 0; i < value.length; ++i) {
                JTextArea textArea = (JTextArea)this.component.getComponent(i);
                value[i] = textArea.getText();
            }
            return value;
        }

        @Override
        public void setValue(Object value) {
            int i;
            String[] strings = (String[])value;
            int length = strings.length;
            Font font = UIManager.getFont("Label.font");
            Color foreground = UIManager.getColor("Label.foreground");
            Color background = UIManager.getColor("Label.background");
            Insets innerMargin = new Insets(0, 0, 0, 0);
            Insets outerMargin = new Insets(2, 0, 0, 0);
            for (i = this.component.getComponentCount(); i < length; ++i) {
                JTextArea textArea = new JTextArea();
                textArea.setLineWrap(this.wrap);
                textArea.setWrapStyleWord(this.wrap);
                textArea.setEditable(false);
                textArea.setFocusable(true);
                textArea.setOpaque(false);
                textArea.setFont(font);
                textArea.setForeground(foreground);
                textArea.setDisabledTextColor(foreground);
                textArea.setBackground(background);
                textArea.setBorder(new FocusBorder(innerMargin, i == 0 ? innerMargin : outerMargin, (Component)textArea));
                this.component.add(textArea);
            }
            while (this.component.getComponentCount() > length) {
                this.component.remove(this.component.getComponentCount() - 1);
            }
            for (i = 0; i < length; ++i) {
                ((JTextArea)this.component.getComponent(i)).setText(strings[i]);
            }
            this.component.revalidate();
        }

        @Override
        public String toString() {
            return this.getClass().getName();
        }
    }
}

