/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import oracle.jdeveloper.audit.analyzer.Parameter;
import oracle.jdeveloper.audit.analyzer.SuppressionScheme;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.Suppression;
import oracle.jdeveloper.audit.service.Violation;

class DefaultSuppression
implements Suppression {
    private final SuppressionScheme scheme;
    private final String name;
    private final Location scope;
    private final Violation issue;
    private Object[] parameters = NO_PARAMETERS;
    private static final Object[] NO_PARAMETERS = new Object[0];

    DefaultSuppression(SuppressionScheme scheme, String name, Location scope) {
        this.scheme = scheme;
        this.scope = scope;
        this.name = name;
        this.issue = null;
    }

    DefaultSuppression(SuppressionScheme scheme, Violation issue) {
        this.scheme = scheme;
        this.name = null;
        this.scope = null;
        this.issue = issue;
    }

    @Override
    public Suppression.Type getType() {
        return this.name != null ? Suppression.Type.NAME : Suppression.Type.REVIEW;
    }

    @Override
    public SuppressionScheme getScheme() {
        return this.scheme;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Location getScope() {
        return this.scope;
    }

    Violation getIssue() {
        return this.issue;
    }

    @Override
    public int getParameterCount() {
        return this.parameters.length;
    }

    @Override
    public String getParameterName(int index) {
        return (String)this.parameters[index * 2];
    }

    @Override
    public Object getParameterValue(int index) {
        return this.parameters[index * 2 + 1];
    }

    void addParameter(String name, Object value) {
        if (this.parameters.length == 0) {
            this.parameters = new Object[]{name, value};
        } else {
            int count = this.parameters.length;
            this.parameters = new Object[count + 2];
            System.arraycopy(this.parameters, 0, this.parameters, 0, count);
            this.parameters[count] = name;
            this.parameters[count + 1] = value;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Suppression@");
        builder.append(Integer.toHexString(System.identityHashCode(this))).append("{");
        builder.append(this.scheme.id());
        switch (this.getType()) {
            case NAME: {
                builder.append(" \"").append(this.name).append("\"@").append(this.scope);
                break;
            }
            case REVIEW: {
                builder.append(' ').append(Integer.toHexString(System.identityHashCode(this.issue)));
            }
        }
        for (int i = 0; i < this.getParameterCount(); ++i) {
            String name;
            if (i > 0) {
                builder.append(", ");
            }
            if ((name = this.getParameterName(i)) == null || name.isEmpty()) {
                name = String.valueOf(i);
            }
            builder.append(name);
            builder.append("=");
            builder.append(this.getParameterValue(i));
        }
        builder.append("]}");
        return builder.toString();
    }

    void close() {
        Parameter[] parameters = this.getScheme().parameters();
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                boolean found = false;
                String requiredName = parameter.getName();
                for (int i = 0; i < this.getParameterCount(); ++i) {
                    if (!requiredName.equals(this.getParameterName(i))) continue;
                    found = true;
                    Object value = this.getParameterValue(i);
                    if (value == null) {
                        this.getScheme().logWarning("Parameter ''{0}'' null", requiredName);
                        break;
                    }
                    if (parameter.getType().isInstance(value)) break;
                    this.getScheme().logError("Parameter ''{0}'' type ''{1}'' not convertible to expected type ''{2}''", requiredName, value.getClass().getName(), parameter.getType().getName());
                    break;
                }
                if (found || !parameter.isRequired()) continue;
                this.getScheme().logError("Required parameter ''{0}'' not added", requiredName);
            }
        }
    }
}

