/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ChangeSupport;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.ExtensionBeanFactory;
import oracle.jdeveloper.audit.extension.ProfileDefinition;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.ProfileTransaction;
import oracle.jdeveloper.audit.service.ValueHandle;
import oracle.jdevimpl.audit.core.DefaultExtensionBeanFactory;
import oracle.jdevimpl.audit.core.DefaultProfileTransaction;
import oracle.jdevimpl.audit.core.ProfileReaderWriter;
import oracle.jdevimpl.audit.util.Beans;
import oracle.jdevimpl.audit.util.PropertyDescriptor;

public class DefaultProfile
extends Profile {
    static final ValueHandle ENABLED_TRUE = new ValueHandle("enabled", "true", true);
    static final ValueHandle ENABLED_FALSE = new ValueHandle("enabled", "false", false);
    private final ExtensionBeanFactory factory;
    private final String id;
    private final ProfileDefinition definition;
    private final String name;
    private URL url;
    private boolean sealed;
    private final MultiMap<String, ValueHandle> delta;
    private final ChangeSupport support = new ChangeSupport((Object)this);
    private static Set<String> badBeans = new HashSet<String>();
    private static Log LOG = new Log("audit-profile");
    public static final String[] NONE_ENABLED = new String[0];
    public static final String[] ALL_ENABLED = new String[0];

    public DefaultProfile(URL url) throws IOException {
        this((ExtensionBeanFactory)DefaultExtensionBeanFactory.getDefaultFactory(), url, false);
    }

    public DefaultProfile(ExtensionBeanFactory factory, URL url, boolean seal) throws IOException {
        LOG.trace("creating profile from url: {0}", (Object)url);
        if (url == null) {
            throw new NullPointerException("url == null");
        }
        if (!URLFileSystem.exists((URL)url)) {
            throw new IllegalArgumentException("File " + URLFileSystem.getPlatformPathName((URL)url) + " not found");
        }
        this.factory = factory;
        ProfileReaderWriter reader = new ProfileReaderWriter();
        reader.read(url, factory, seal, false);
        String readId = reader.getId();
        if (readId != null) {
            this.definition = AuditHook.getAuditHook().getProfile(readId);
            this.id = this.definition != null ? this.definition.getId() : readId;
        } else {
            this.definition = null;
            this.id = null;
        }
        this.name = reader.getName();
        this.url = url;
        this.sealed = reader.isSealed();
        this.delta = reader.getDelta();
    }

    public DefaultProfile(String name, URL url) throws IOException {
        LOG.trace("creating profile from name and url: {0}, {1}", (Object)name, (Object)url);
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (url == null) {
            throw new NullPointerException("url == null");
        }
        if (!URLFileSystem.exists((URL)url)) {
            throw new IllegalArgumentException("File " + URLFileSystem.getPlatformPathName((URL)url) + " not found");
        }
        this.factory = DefaultExtensionBeanFactory.getDefaultFactory();
        this.id = null;
        this.definition = null;
        this.name = name;
        this.url = url;
        ProfileReaderWriter reader = new ProfileReaderWriter();
        reader.read(this.url, this.factory, false, false);
        this.sealed = reader.isSealed();
        this.delta = reader.getDelta();
    }

    public DefaultProfile(ExtensionBeanFactory factory, ProfileDefinition definition, String name, URL url) throws IOException {
        LOG.trace("creating profile from definition, name, and url: {0}, {1}, {2}", (Object)definition, (Object)name, (Object)url);
        if (definition == null) {
            throw new NullPointerException("definition == null");
        }
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (url == null) {
            throw new NullPointerException("url == null");
        }
        if (!URLFileSystem.exists((URL)url)) {
            throw new IllegalArgumentException("File " + URLFileSystem.getPlatformPathName((URL)url) + " not found");
        }
        this.factory = factory;
        this.id = definition.getId();
        this.definition = definition;
        this.name = name;
        this.url = url;
        this.sealed = false;
        ProfileReaderWriter reader = new ProfileReaderWriter();
        reader.read(this.url, this.factory, false, false);
        this.delta = reader.getDelta();
    }

    public static String readName(URL url) throws IOException {
        ProfileReaderWriter reader = new ProfileReaderWriter();
        reader.read(url, DefaultExtensionBeanFactory.getDefaultFactory(), false, true);
        return reader.getName();
    }

    public DefaultProfile(String name, String ... ids) {
        this((ExtensionBeanFactory)DefaultExtensionBeanFactory.getDefaultFactory(), name, ids);
    }

    public DefaultProfile(ExtensionBeanFactory factory, String name, String ... enabledIds) {
        this(factory, name, false, enabledIds);
    }

    public DefaultProfile(ExtensionBeanFactory factory, String name, boolean seal, String ... enabledIds) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.factory = factory;
        this.id = null;
        this.definition = null;
        this.name = name;
        this.url = null;
        this.sealed = seal;
        this.delta = new MultiMap();
        Map<String, BeanDefinition> definitions = factory.getDefinitions();
        HashSet<Object> enabled = new HashSet<Object>();
        if (enabledIds.length == 0) {
            if (enabledIds == ALL_ENABLED) {
                enabled.addAll(definitions.keySet());
            } else if (enabledIds != NONE_ENABLED) {
                throw new IllegalArgumentException("enabledIds empty");
            }
        } else {
            for (String id : enabledIds) {
                if (!definitions.containsKey(id)) {
                    throw new IllegalArgumentException("Bean \"" + (String)id + "\" not found");
                }
                enabled.add(id);
            }
        }
        for (BeanDefinition bean : definitions.values()) {
            String id;
            boolean isEnabled;
            if (!bean.hasEnabledProperty() || (isEnabled = enabled.contains(id = bean.getId())) == bean.isEnabledByDefault()) continue;
            this.delta.add((Object)id, (Object)(isEnabled ? ENABLED_TRUE : ENABLED_FALSE));
        }
    }

    DefaultProfile(ExtensionBeanFactory factory, String name, boolean sealed, MultiMap<String, ValueHandle> changes1, MultiMap<String, ValueHandle> changes2) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.factory = factory;
        this.id = null;
        this.definition = null;
        this.name = name;
        this.url = null;
        this.sealed = sealed;
        this.delta = new MultiMap();
        this.applyChanges(changes1);
        this.applyChanges(changes2);
    }

    public DefaultProfile(Profile profile, URL url) {
        LOG.trace("creating profile from profile: {0}", (Object)profile);
        DefaultProfile p = (DefaultProfile)profile;
        this.factory = p.factory;
        this.id = p.id;
        this.definition = p.definition;
        this.name = p.name;
        this.url = url;
        this.sealed = p.sealed;
        this.delta = new MultiMap(p.delta);
    }

    public DefaultProfile(Profile profile, ProfileDefinition definition) {
        LOG.trace("creating profile from definition and profile: {0}, {1}", (Object)definition, (Object)profile);
        DefaultProfile p = (DefaultProfile)profile;
        this.factory = p.factory;
        this.id = p.id;
        this.definition = definition;
        this.name = p.name;
        this.url = p.getURL();
        this.sealed = p.sealed;
        this.delta = new MultiMap(p.delta);
    }

    @Override
    public ProfileDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public ExtensionBeanFactory getFactory() {
        return this.factory;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized URL getURL() {
        return this.url;
    }

    @Override
    public Collection<BeanDefinition> getDefinitions() {
        return this.factory.getDefinitions().values();
    }

    @Override
    public BeanDefinition getDefinition(String id) {
        return this.factory.getDefinitions().get(id);
    }

    @Override
    public synchronized boolean isSealed() {
        return this.sealed;
    }

    @Override
    public synchronized Map<String, ExtensionBean> createBeans(boolean force) {
        if (this.delta == null) {
            throw new IllegalStateException("profile not loaded");
        }
        LinkedHashMap<String, ExtensionBean> beans = new LinkedHashMap<String, ExtensionBean>();
        Map<String, ExtensionBean> defaultBeans = this.factory.getBeans(force);
        for (ExtensionBean bean : defaultBeans.values()) {
            this.copyAndConfigure(bean, beans);
        }
        return beans;
    }

    @Override
    public synchronized ExtensionBean createBean(BeanDefinition definition, boolean force, Map<String, ExtensionBean> context) {
        if (this.delta == null) {
            throw new IllegalStateException("profile not loaded");
        }
        ExtensionBean defaultBean = this.factory.getBean(definition, force);
        return this.copyAndConfigure(defaultBean, context);
    }

    private ExtensionBean copyAndConfigure(ExtensionBean bean, Map<String, ExtensionBean> context) {
        ExtensionBean copy;
        block15: {
            block14: {
                if (bean == null) {
                    return bean;
                }
                String id = bean.id();
                try {
                    copy = bean.createCopy(context);
                }
                catch (InvocationTargetException e) {
                    if (badBeans.add(id)) {
                        bean.logError(e, "exception copying bean '{0}' of class '{1}' from extension '{2}': {3}", id, bean.getClass(), bean.extensionId(), e);
                    }
                    return null;
                }
                Collection handles = this.delta.get((Object)id);
                if (handles == null) break block14;
                for (ValueHandle handle : handles) {
                    String name = handle.getName();
                    try {
                        PropertyDescriptor property = Beans.getPropertyDescriptor(copy, name);
                        Object value = handle.getValue(property.getPropertyType());
                        property.getWriteMethod().invoke((Object)copy, value);
                    }
                    catch (IntrospectionException e) {
                        copy.logError(e, "introspecting property \"{0}\" of class {1} ({2}) failed: {3}", name, copy.getClass(), copy, e);
                    }
                    catch (InvocationTargetException e) {
                        copy.logError(e, "setting property \"{0}\" of class {1} ({2}) failed: {3}", name, copy.getClass(), copy, e);
                    }
                    catch (IllegalAccessException e) {
                        copy.logError(e, "setting property \"{0}\" of class {1} ({2}) failed: {3}", name, copy.getClass(), copy, e);
                    }
                    catch (Exception e) {
                        copy.logError(e, "unmarshaling property \"{0}\" of class {1} ({2}) failed: {3}", name, copy.getClass(), copy, e);
                    }
                }
                break block15;
            }
            if (!this.sealed || !bean.definition().hasEnabledProperty()) break block15;
            try {
                PropertyDescriptor property = Beans.getPropertyDescriptor(copy, "enabled");
                Method writeMethod = property.getWriteMethod();
                writeMethod.invoke((Object)copy, false);
            }
            catch (InvocationTargetException e) {
                copy.logError(e, "setting property \"enabled\" of class {0} ({1}) failed: {2}", copy.getClass(), copy, e);
            }
            catch (IllegalAccessException e) {
                copy.logError(e, "setting property \"enabled\" of class {0} ({1}) failed: {2}", copy.getClass(), copy, e);
            }
            catch (Exception e) {
                copy.logError(e, "unmarshaling property \"enabled\" of class {0} ({1}) failed: {2}", copy.getClass(), copy, e);
            }
        }
        return copy;
    }

    @Override
    public Object getDefaultValue(BeanDefinition definition, String propertyName) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        ExtensionBean defaultBean = this.factory.getBean(definition, false);
        if (defaultBean == null) {
            throw new IllegalStateException("getting default value of property " + definition.getId() + "#" + propertyName + " failed");
        }
        return Beans.getPropertyValue(defaultBean, propertyName);
    }

    @Override
    public boolean isEnabled(String id) {
        if (this.delta == null) {
            throw new IllegalStateException("profile not loaded");
        }
        BeanDefinition definition = this.getDefinition(id);
        if (definition == null) {
            throw new IllegalArgumentException("bean " + id + " not found");
        }
        if (!definition.hasEnabledProperty()) {
            throw new IllegalArgumentException("bean " + id + " enabled property not found");
        }
        Collection handles = this.delta.get((Object)id);
        if (handles != null) {
            for (ValueHandle handle : handles) {
                if (!"enabled".equals(handle.getName())) continue;
                return handle.isTrue();
            }
        }
        return definition.isEnabledByDefault();
    }

    @Override
    public MultiMap<String, ValueHandle> getChangedValues() {
        if (this.delta == null) {
            throw new IllegalStateException("profile not loaded");
        }
        return this.delta;
    }

    @Override
    public Collection<ValueHandle> getChangedValues(String id) {
        if (this.delta == null) {
            throw new IllegalStateException("profile not loaded");
        }
        return this.delta.get((Object)id);
    }

    @Override
    public ValueHandle getChangedValue(String id, String propertyName) {
        if (this.delta == null) {
            throw new IllegalStateException("profile not loaded");
        }
        Collection handles = this.delta.get((Object)id);
        if (handles != null) {
            for (ValueHandle handle : handles) {
                if (!propertyName.equals(handle.getName())) continue;
                return handle;
            }
        }
        return null;
    }

    @Override
    public ProfileTransaction createTransaction() {
        if (this.delta == null) {
            throw new IllegalStateException("profile not loaded");
        }
        return new DefaultProfileTransaction(this);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    @Override
    public synchronized void applyChanges(ProfileTransaction transaction) {
        if (this != transaction.getProfile()) {
            throw new IllegalArgumentException("transaction not created from this profile");
        }
        this.applyChanges(transaction.getPendingChangedValues());
        this.sealed = transaction.isSealed();
    }

    private synchronized void applyChanges(MultiMap<String, ValueHandle> changedValues) {
        for (Map.Entry entry : changedValues.entrySet()) {
            String id = (String)entry.getKey();
            Collection oldChanges = this.delta.get((Object)id);
            if (oldChanges != null) {
                block5: for (ValueHandle newHandle : (Collection)entry.getValue()) {
                    String name = newHandle.getName();
                    for (ValueHandle oldChange : oldChanges) {
                        if (!name.equals(oldChange.getName())) continue;
                        this.delta.removeValue((Object)id, (Object)oldChange);
                        continue block5;
                    }
                }
            }
            for (ValueHandle newHandle : (Collection)entry.getValue()) {
                if (newHandle.getRepresentation() == ProfileTransaction.DEFAULT_VALUE) continue;
                BeanDefinition definition = this.getDefinition(id);
                if (definition != null) {
                    String propertyName = newHandle.getName();
                    ExtensionBean defaultBean = this.factory.getBean(definition, false);
                    if (defaultBean != null) {
                        try {
                            PropertyDescriptor descriptor = Beans.getPropertyDescriptor(defaultBean, propertyName);
                            if (descriptor != null && descriptor.getReadMethod() != null && descriptor.getWriteMethod() != null) {
                                Object defaultValue = descriptor.getReadMethod().invoke((Object)defaultBean, new Object[0]);
                                Class<?> type = descriptor.getPropertyType();
                                try {
                                    Object newValue = newHandle.getValue(type);
                                    if (!(defaultValue == null ? newValue != null : !defaultValue.equals(newValue))) continue;
                                    this.delta.add((Object)id, (Object)newHandle);
                                }
                                catch (Exception e) {
                                    AuditLogger.error(e, "Getting type of bean {0} property {1} failed: {2}", id, propertyName, e);
                                }
                                continue;
                            }
                            AuditLogger.error("Property {0} of bean {1} not found", propertyName, defaultBean);
                        }
                        catch (Exception e) {
                            AuditLogger.error(e, "Getting value of bean {0} property {1} failed: {2}", id, propertyName, e);
                        }
                        continue;
                    }
                    if ("enabled".equals(propertyName)) {
                        if (definition.hasEnabledProperty()) {
                            if (definition.isEnabledByDefault() == newHandle.isTrue()) continue;
                            this.delta.add((Object)id, (Object)newHandle);
                            continue;
                        }
                        AuditLogger.error("property {0} of bean {1} not found", propertyName, id);
                        continue;
                    }
                    this.delta.add((Object)id, (Object)newHandle);
                    continue;
                }
                this.delta.add((Object)id, (Object)newHandle);
            }
        }
        this.support.fireStateChanged();
    }

    public boolean equals(Object object) {
        return object instanceof Profile && this.getName().equalsIgnoreCase(((Profile)object).getName());
    }

    public int hashCode() {
        return this.getName().toLowerCase().hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("profile ");
        buffer.append(this.name);
        String id = this.getId();
        if (id != null) {
            buffer.append("(id ");
            buffer.append(id);
            buffer.append(')');
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(URL url) throws IOException {
        DefaultProfile defaultProfile = this;
        synchronized (defaultProfile) {
            ProfileReaderWriter.write(this.factory, this.id, this.name, url, this.sealed, this.delta);
            this.url = url;
        }
        try {
            new DefaultProfile(this.factory, url, this.sealed);
        }
        catch (Throwable e) {
            AuditLogger.error("profile {0} saved, but reload failed: {1}", url, e);
        }
    }
}

