/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.net.URI;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.web.HasSessionAttributes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;

public class RedirectException
extends WebException
implements HasSessionAttributes {
    private final String redirectLocation;
    private AssociativeArray<String, Object> servletSession;
    private static final long serialVersionUID = 5380255417066004479L;

    @Override
    public Entity response(RequestEntity request) throws IOException {
        Entity response = super.response(request);
        EntityHeadersBuilder headers = Entities.headers();
        headers.header((CharSequence)HttpHeader.LOCATION, this.resolveLocation(request.base()));
        return Entities.merge(response, headers.build());
    }

    protected RedirectException(HttpStatusCode statusCode, String location) {
        super(statusCode);
        this.redirectLocation = location;
    }

    public String redirectLocation() {
        return this.redirectLocation;
    }

    private String resolveLocation(String base) {
        URI baseUri = URIs.create((String)base);
        URI absUri = URIs.resolve((URI)baseUri, (String)this.redirectLocation);
        String location = absUri.toString();
        return location;
    }

    @Override
    public AssociativeArray<String, Object> session() {
        return this.servletSession;
    }

    public RedirectException session(AssociativeArray<String, Object> session) {
        this.servletSession = session;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RedirectException [statusCode=");
        builder.append(this.statusCode());
        builder.append(", location=");
        builder.append(this.redirectLocation);
        if (!NullOrEmpty.nullOrEmpty(this.servletSession)) {
            builder.append(", session=");
            builder.append(this.servletSession);
        }
        builder.append("]");
        return builder.toString();
    }

    public static RedirectException notAuthorized(String logonRedirect) {
        return new RedirectException(HttpStatusCode.UNAUTHORIZED, logonRedirect);
    }

    public static RedirectException permanentRedirect(String path) {
        return new RedirectException(HttpStatusCode.MOVED_PERMANENTLY, path);
    }

    public static RedirectException rebase(String base, RedirectException e) {
        String redirect = e.redirectLocation();
        String rebased = URIs.resolve((URI)URIs.create((String)base), (String)redirect).toString();
        RedirectException rewritten = new RedirectException(e.statusCode(), rebased);
        rewritten.session(e.session());
        return rewritten;
    }

    public static RedirectException temporaryRedirect(String path) {
        return new RedirectException(HttpStatusCode.FOUND, path);
    }
}

