/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpHeaderValue;

public abstract class ContentDisposition {
    private static final String FILENAME = "filename";
    private static final String ATTACHMENT = "attachment";

    private ContentDisposition() {
    }

    public static EntityHeader contentDispositionAttachmentHeader(CharSequence filename) {
        return Entities.header(HttpHeader.CONTENT_DISPOSITION, ContentDisposition.contentDispositionAttachment(filename));
    }

    public static String contentDispositionAttachment(CharSequence filename) {
        HttpHeaderValue.Builder normalized = HttpHeaderValue.builder();
        normalized.noValueParameter(ATTACHMENT);
        normalized.extendedParameter(FILENAME, filename);
        return normalized.build().toString();
    }

    public static CharSequence normalize(CharSequence text) {
        CharSequence filename = null;
        HttpHeaderValue.Builder normalized = HttpHeaderValue.builder();
        HttpHeaderValue value = HttpHeaderValue.parse(text);
        for (HttpHeaderValue.HeaderParameter parameter : value.parameters()) {
            normalized.add(parameter);
            if (!parameter.name().equals(FILENAME) || HttpHeaderValue.ParameterType.EXTENDED == parameter.type()) continue;
            filename = parameter.value();
            normalized.extendedParameter(FILENAME, filename);
        }
        if (filename == null) {
            return text;
        }
        return normalized.build().toString();
    }
}

