/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.Collections;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityBase;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.paging.Pagination;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;
import oracle.dbtools.rt.uri.HasURITemplate;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.uri.URITemplates;
import oracle.dbtools.rt.uri.ValidURITemplate;
import oracle.dbtools.rt.validation.NotNull;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public class ResourceTemplate
extends TenantEntityBase
implements HasURITemplate,
TenantEntity {
    private String etagQuery;
    private ETagType etagType = ETagType.NONE;
    private TenantIdentifier moduleId;
    @ValidURITemplate
    @NotNull
    private String pattern;
    private int priority;
    private static final String CURRENT_USER = "current_user";
    private static final String ETAG_METHOD = "__ETAG__";

    public ResourceHandler etag() {
        String content = "";
        switch (this.etagType) {
            case NONE: {
                return null;
            }
            case QUERY: {
                content = this.etagQuery;
            }
        }
        ResourceHandler.ResourceHandlerBuilder b = ResourceHandler.builder();
        b.method(ETAG_METHOD);
        b.content(content);
        return b.build();
    }

    public String etagQuery() {
        return this.etagQuery;
    }

    public void etagQuery(String etagQuery) {
        this.etagQuery = etagQuery;
        this.etagType = null == etagQuery ? ETagType.NONE : (etagQuery.trim().isEmpty() ? ETagType.HASH : ETagType.QUERY);
    }

    public ETagType etagType() {
        return this.etagType;
    }

    public Map<String, Object> inboundValues(ResourceHandler handler, int itemsPerPage, String uri, EntityHeaders headers) {
        EntityHeader pageHeader;
        URITemplate template = this.uriTemplate();
        Map<String, String> params = template.decode(uri);
        LinkedHashMap<String, Object> bindings = new LinkedHashMap<String, Object>();
        Set<String> implicit = this.implicitParameterNames(handler);
        for (String name : implicit) {
            bindings.put(name, params.get(name));
        }
        for (ResourceParameter binding : handler.inbound()) {
            String value = null;
            if (ResourceParameter.Kind.HEADER.equals((Object)binding.kind())) {
                EntityHeader header = headers.header(binding.originalName());
                if (header == null) continue;
                value = header.value();
                Object primitive = PrimitiveTypes.valueOf((CharSequence)value, binding.primitiveType());
                bindings.put(binding.bindName(), primitive);
                continue;
            }
            value = params.get(binding.originalName());
            Object primitive = PrimitiveTypes.valueOf((CharSequence)value, binding.primitiveType());
            bindings.put(binding.bindName(), primitive);
        }
        EntityHeader currentUser = headers.header("X-APEX-USER");
        if (currentUser != null) {
            bindings.put(CURRENT_USER, currentUser.value());
        }
        bindings.put("page_size", itemsPerPage);
        long pageOffset = 0L;
        String text = params.get("page_offset");
        if (NullOrEmpty.nullOrEmpty((CharSequence)text) && (pageHeader = headers.header("X-APEX-PAGE-OFFSET")) != null) {
            text = pageHeader.value();
        }
        if (!NullOrEmpty.nullOrEmpty((CharSequence)text)) {
            try {
                pageOffset = (Long)PrimitiveTypes.valueOf((CharSequence)text, Long.class);
            }
            catch (NumberFormatException e) {
                throw WebException.badRequest(Reason.reason("page.offset", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "ReTargetingDispatcher.1", "page offset must be a number", new Object[0])));
            }
        }
        long rowOffset = Pagination.rowOffset(pageOffset, itemsPerPage);
        long rowCount = Pagination.rowCount(pageOffset, itemsPerPage);
        bindings.put("row_offset", rowOffset);
        bindings.put("row_count", rowCount);
        bindings.put("page_offset", pageOffset);
        return bindings;
    }

    @Override
    public TenantIdentifier parentId() {
        return this.moduleId;
    }

    @Override
    public void parentId(TenantIdentifier moduleId) {
        this.moduleId = moduleId;
    }

    public void pattern(String pattern) {
        this.pattern = pattern;
    }

    public void priority(int priority) {
        this.priority = priority;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceTemplate [pattern=").append(this.pattern).append(", priority=").append(this.priority).append(", etagQuery=").append(this.etagQuery).append("]");
        return builder.toString();
    }

    @Override
    public URITemplate uriTemplate() {
        if (this.pattern == null) {
            return null;
        }
        return URITemplates.uriTemplate(this.pattern, this.priority);
    }

    Set<String> implicitParameterNames(ResourceHandler handler) {
        URITemplate template = this.uriTemplate();
        LinkedHashSet<String> implicit = new LinkedHashSet<String>();
        implicit.addAll(template.parameters());
        Iterator<String> explicit = this.explicitParameters(handler);
        Collections.removeAll(implicit, explicit);
        return implicit;
    }

    private Iterator<String> explicitParameters(ResourceHandler handler) {
        return Iterators.transform((Iterator)Iterators.iterator((Object[])handler.parameters()), (Transform)new Transform<ResourceParameter, String>(){

            public String apply(ResourceParameter x) {
                return x.originalName();
            }
        });
    }

    public static enum ETagType {
        HASH,
        NONE,
        QUERY;

    }
}

