/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.collection;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.authentication.SecurityConfigs;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.json.query.JSONRepresentation;
import oracle.dbtools.rt.resource.collection.CollectionUriTemplates;
import oracle.dbtools.rt.resource.collection.FeedItem;
import oracle.dbtools.rt.resource.collection.FeedItemTransform;
import oracle.dbtools.rt.validation.Validator;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.Requests;

public abstract class CollectionRequestHandler<PK>
extends RequestHandler {
    @Reference
    protected Validator validator;
    private final ContentType[] acceptable;
    private final CollectionUriTemplates uriTemplates;

    protected CollectionRequestHandler(CollectionUriTemplates uriTemplates, ContentType ... acceptable) {
        super(CollectionRequestHandler.metadata(uriTemplates));
        this.uriTemplates = uriTemplates;
        this.acceptable = acceptable;
    }

    protected String create(CompoundPrincipal principal, ContentType contentType, InputStream content) throws IOException {
        Requests.acceptable(contentType, this.acceptable);
        PK id = this.create(principal, content);
        String location = null;
        if (id != null) {
            location = this.location(principal, this.uriTemplates, id);
        }
        return location;
    }

    protected abstract PK create(CompoundPrincipal var1, InputStream var2);

    protected abstract Transaction transaction(CompoundPrincipal var1);

    @Override
    protected Entity get(RequestEntity request) throws IOException {
        Transaction txn = this.transaction(request.principal());
        if (txn == null) {
            throw new IllegalStateException();
        }
        JSONRepresentation rep = new JSONRepresentation(false);
        Iterator<FeedItem> items = this.items(txn, request);
        return CollectionRequestHandler.alsoClose(rep.toRepresentation(request, -1L, Iterators.transform(items, (Transform)FeedItemTransform.INSTANCE)), txn);
    }

    protected abstract Iterator<FeedItem> items(Transaction var1, RequestEntity var2);

    @Override
    protected Entity post(RequestEntity request) throws IOException {
        String location = this.create(request.principal(), request.contentType(), request.body());
        return this.created(location);
    }

    protected String string(CompoundPrincipal principal, PK id) {
        return id.toString();
    }

    private Entity created(String location) {
        return Entities.entity(StreamCopy.emptyStream(), Entities.headers("X-APEX-FORWARD", location, "X-APEX-STATUS-CODE", Integer.toString(HttpStatusCode.CREATED.statusCode())));
    }

    private String location(CompoundPrincipal principal, CollectionUriTemplates uriTemplates, PK id) {
        return uriTemplates.relativeItem().encode("id", this.string(principal, id));
    }

    private static RequestHandlerMetaData metadata(CollectionUriTemplates uriTemplates) {
        return RequestHandlerMetaData.builder(uriTemplates.collection(), HttpMethod.GET, HttpMethod.POST).securityConfig(SecurityConfigs.SECURE_REST_SERVICE).build();
    }
}

