/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.jdbc.entity;

import java.security.Principal;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.UsesQuery;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.rt.home.TenantsProvider;
import oracle.dbtools.rt.jdbc.entity.JDBCTenantPrincipal;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;

@Service(priority=1)
public class JDBCTenantsProvider
extends UsesQuery
implements TenantsProvider {
    @Reference
    private JDBCCallProvider jdbc;
    private static final Statement TENANT = StatementBuilder.query((String)"select c.provisioning_company_id from wwv_flow_companies c where c.short_name = :name", (String[])new String[]{"name"});

    /*
     * Loose catch block
     */
    @Override
    public TenantPrincipal tenant(CompoundPrincipal principal, String tenantName) {
        Iterator matches;
        JDBCTransaction txn;
        block6: {
            JDBCTenantPrincipal jDBCTenantPrincipal;
            CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
            Map parameters = Maps.toMap((String[])new String[]{"name", tenantName.toUpperCase()});
            txn = null;
            matches = null;
            try {
                txn = this.jdbc.transaction((Principal)apexListener);
                matches = this.query.query((Transaction)txn, TENANT, parameters, false);
                if (!matches.hasNext()) break block6;
                ResultRow row = (ResultRow)matches.next();
                Number id = (Number)row.get(1, Number.class);
                jDBCTenantPrincipal = new JDBCTenantPrincipal(tenantName, id);
            }
            catch (ConnectionPoolException e) {
                TenantPrincipal tenantPrincipal = null;
                Closeables.close((Object[])new Object[]{matches, txn});
                return tenantPrincipal;
            }
            catch (SQLException e2) {
                throw JDBCException.wrap((SQLException)e2);
                {
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new Object[]{matches, txn});
                        throw throwable;
                    }
                }
            }
            Closeables.close((Object[])new Object[]{matches, txn});
            return jDBCTenantPrincipal;
        }
        Closeables.close((Object[])new Object[]{matches, txn});
        return null;
    }
}

