/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.Console;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.config.MutableConfigurations;
import oracle.dbtools.common.di.Factory;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.plugin.api.cmdline.CommandProvider;
import oracle.dbtools.plugin.api.cmdline.annotations.Command;
import oracle.dbtools.plugin.api.conf.Configuration;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.i18n.annotations.TranslatableText;
import oracle.dbtools.rt.config.setup.InstallParams;
import oracle.dbtools.rt.config.setup.SchemaSetup;
import oracle.dbtools.rt.config.setup.SetupMessages;

@Provides
@Command(name="verify-schema", description=@TranslatableText(type=SetupMessages.class, id=""), documented=false)
public class VerifySchema
implements CommandProvider {
    private final MutableConfigurations confs;
    private final Factory factory;
    private final File war;
    private static final Log LOG = Log.get(VerifySchema.class);

    @Inject
    VerifySchema(MutableConfigurations confs, @Named(value="war") File war, Factory factory) {
        this.confs = confs;
        this.war = war;
        this.factory = factory;
    }

    public void execute(Map<String, Object> values) throws Exception {
        MutableConfigurations existing = this.confs;
        Console console = System.console();
        Map<String, String> installParams = InstallParams.getInstallParameters(this.war, (String)values.get("installtype"), (String)values.get("paramfile"));
        if (installParams == null) {
            throw new Exception(SetupMessages.getString("ERR_INSTALL_PARAMS"));
        }
        List<String> dbConfigNames = this.getDBConfigNames((Configurations)existing);
        for (String confName : dbConfigNames) {
            LOG.console("\n" + SetupMessages.format("INFO_VERIFY_CONFIG", confName) + "\n");
            VerifySchema.setInstallParamValues((Configurations)existing, confName, installParams);
            SchemaSetup.schemaParams(console, this.war, installParams);
            InstallParams.writeInstallProperties(installParams);
            SchemaSetup.install(installParams, (Class)values.get("installer"), this.factory);
        }
    }

    private List<String> getDBConfigNames(Configurations existing) {
        ArrayList<String> nameList = new ArrayList<String>();
        for (String name : existing) {
            if (!name.endsWith("_pu")) continue;
            int ndx = name.indexOf("_pu");
            nameList.add(name.substring(0, ndx));
        }
        return nameList;
    }

    public static void setInstallParamValues(Configurations existing, String confName, Map<String, String> installParams) {
        String puConfName = confName + "_pu";
        Configuration def = existing.get("defaults");
        Configuration conf = existing.get(confName);
        if (conf != null) {
            String value = !NullOrEmpty.nullOrEmpty((CharSequence)conf.get("db.hostname")) ? conf.get("db.hostname") : def.get("db.hostname");
            installParams.put("db.hostname", value);
            value = !NullOrEmpty.nullOrEmpty((CharSequence)conf.get("db.port")) ? conf.get("db.port") : def.get("db.port");
            installParams.put("db.port", value);
            value = !NullOrEmpty.nullOrEmpty((CharSequence)conf.get("db.servicename")) ? conf.get("db.servicename") : def.get("db.servicename");
            installParams.put("db.servicename", value);
            value = !NullOrEmpty.nullOrEmpty((CharSequence)conf.get("db.sid")) ? conf.get("db.sid") : def.get("db.sid");
            installParams.put("db.sid", value);
            value = !NullOrEmpty.nullOrEmpty((CharSequence)conf.get("db.username")) ? conf.get("db.username") : def.get("db.username");
            installParams.put("db.username", value);
            value = !NullOrEmpty.nullOrEmpty((CharSequence)conf.get("db.password")) ? conf.get("db.password") : def.get("db.password");
            installParams.put("db.password", value);
        } else {
            installParams.put("db.hostname", def.get("db.hostname"));
            installParams.put("db.port", def.get("db.port"));
            installParams.put("db.servicename", def.get("db.servicename"));
            installParams.put("db.sid", def.get("db.sid"));
            installParams.put("db.username", def.get("db.username"));
            installParams.put("db.password", def.get("db.password"));
        }
        installParams.put("user.name.public", existing.get(puConfName).get("db.username"));
        installParams.put("user.public.password", existing.get(puConfName).get("db.password"));
    }
}

