/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.Console;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import oracle.dbtools.common.di.Factory;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.plugin.api.cmdline.CommandProvider;
import oracle.dbtools.plugin.api.cmdline.annotations.Command;
import oracle.dbtools.plugin.api.cmdline.annotations.Option;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.i18n.annotations.TranslatableText;
import oracle.dbtools.rt.config.setup.InstallParams;
import oracle.dbtools.rt.config.setup.SchemaSetup;
import oracle.dbtools.rt.config.setup.Setting;
import oracle.dbtools.rt.config.setup.SetupMessages;

@Provides
@Command(name="uninstall", description=@TranslatableText(type=SetupMessages.class, id="UNINSTALL_DESCRIPTION"), options={@Option(name="parameterFile", description=@TranslatableText(type=SetupMessages.class, id="PARAMETERFILE"))})
public class Uninstall
implements CommandProvider {
    private final Factory factory;
    private final File war;
    private boolean isSimpleInstall;
    private static Setting PORT = Setting.setting("DB_SERVER_PORT", "db.port", "1521");
    private static Setting SERVER = Setting.setting("DB_SERVER_NAME", "db.hostname", "localhost");
    private static Setting SERVICE_NAME = Setting.setting("DB_SERVICE_NAME", "db.servicename", null);
    private static final Setting SERVICE_OR_SID = Setting.setting("DB_CHOOSE_SID_OR_SERVICE", null, "1", false, "1", "2");
    private static Setting SID = Setting.setting("DB_SERVICE_ID", "db.sid", "xe");
    private static final Log LOG = Log.get(Uninstall.class);

    @Inject
    Uninstall(@Named(value="war") File war, Factory factory) {
        this.war = war;
        this.factory = factory;
    }

    public void execute(Map<String, Object> values) throws Exception {
        Console console;
        Map<String, String> installParams;
        block14: {
            installParams = InstallParams.getInstallParameters(this.war, (String)values.get("installtype"), (String)values.get("parameterFile"));
            if (installParams == null) {
                LOG.warning(SetupMessages.getString("ERR_INSTALL_PARAMS"));
                return;
            }
            if (!NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("file.creator")) && installParams.get("file.creator").equals("sqldev")) {
                this.isSimpleInstall = true;
                installParams.put("install.type", "install.simple");
            }
            console = System.console();
            try {
                this.settingValue(console, installParams, "db.hostname", SERVER);
                this.settingValue(console, installParams, "db.port", PORT);
                if (installParams.containsKey("db.servicename")) {
                    this.settingValue(console, installParams, "db.servicename", SERVICE_NAME);
                    break block14;
                }
                if (installParams.containsKey("db.sid")) {
                    this.settingValue(console, installParams, "db.sid", SID);
                    break block14;
                }
                if (console != null) {
                    String choice = SERVICE_OR_SID.prompt(console, new String[0]);
                    if ("1".equals(choice)) {
                        this.settingValue(console, installParams, "db.servicename", SERVICE_NAME);
                    } else {
                        this.settingValue(console, installParams, "db.sid", SID);
                    }
                    break block14;
                }
                if (this.isSimpleInstall) {
                    String keys = "db.servicename or db.sid";
                    LOG.warning(SetupMessages.format("ERR_MISSING_VALUE_SIMPLE", keys));
                    return;
                }
                LOG.warning(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
                return;
            }
            catch (Exception e) {
                LOG.warning(e.getMessage());
                return;
            }
        }
        String dbUrl = SchemaSetup.getDbUrl(installParams);
        if (SchemaSetup.getSysDbaUserCredentials(console, installParams, dbUrl)) {
            installParams.put("db.url", dbUrl);
            installParams.put("installer", "uninstall");
            Class type = (Class)values.get("installer");
            if (type != null) {
                CommandProvider installProvider = (CommandProvider)this.factory.newInstance(type);
                Map requiredValues = (Map)Maps.builder().add((Object)"install.params", installParams).build();
                try {
                    installProvider.execute(requiredValues);
                }
                catch (Exception e) {
                    LOG.warning(e.getMessage());
                }
            }
        }
    }

    private String settingValue(Console console, Map<String, String> installParams, String key, Setting setting) throws Exception {
        String val = installParams.get(key);
        if (console != null) {
            if (!this.isSimpleInstall || NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                if (!NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                    setting.setDefaultValue(val);
                }
                val = setting.prompt(console, new String[0]);
                installParams.put(key, val);
            }
        } else if (this.isSimpleInstall) {
            if (NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                throw new Exception(SetupMessages.format("ERR_MISSING_VALUE_SIMPLE", key));
            }
        } else {
            throw new Exception(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
        }
        return val;
    }
}

