/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.auth.AuthenticatorBase;
import oracle.dbtools.auth.HeaderCallback;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.session.ServletSessionCallback;
import oracle.dbtools.rt.session.SessionState;

@Service
@Authenticates(value=AuthenticationRealm.SESSION)
public class SessionVerifier
extends AuthenticatorBase
implements RealmAuthenticator {
    public AuthenticationResult authenticate(CallbackHandler callbackHandler) {
        ServletSessionCallback existingSession = new ServletSessionCallback("_com.oracle.al");
        HeaderCallback pathHeader = new HeaderCallback((CharSequence)"X-APEX-PATH");
        Callback[] callbacks = new Callback[]{pathHeader, existingSession};
        try {
            callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw this.wrap(e);
        }
        catch (UnsupportedCallbackException e) {
            throw this.wrap(e);
        }
        boolean authenticationRequired = this.isAuthenticationRequired(pathHeader);
        if (!authenticationRequired) {
            return this.verifySession(existingSession);
        }
        return AuthenticationResult.unknown();
    }

    private boolean isAuthenticationRequired(HeaderCallback pathHeader) {
        String requestPath = pathHeader.getValue();
        return SessionState.authenticationRequired(requestPath);
    }

    private AuthenticationResult verifySession(ServletSessionCallback existingSession) {
        SessionState session = (SessionState)existingSession.getAttribute();
        if (session == null || !session.authenticated()) {
            return AuthenticationResult.unknown();
        }
        return AuthenticationResult.valid((Iterable)session.principal());
    }
}

