/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.LogonAuthenticatorBase;
import oracle.dbtools.rt.authentication.LogonRealm;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.session.ServletSessionCallback;
import oracle.dbtools.rt.session.ServletSessionPrincipal;
import oracle.dbtools.rt.session.SessionState;

@Service
@Authenticates(value=AuthenticationRealm.LOGON)
public class SessionAuthenticator
extends LogonAuthenticatorBase
implements RealmAuthenticator {
    @Override
    public AuthenticationResult authenticate(CallbackHandler callbackHandler) {
        AuthenticationResult result = super.authenticate(callbackHandler);
        if (result.isValid()) {
            ServletSessionCallback s = new ServletSessionCallback("_com.oracle.al");
            Callback[] callbacks = new Callback[]{s};
            try {
                callbackHandler.handle(callbacks);
            }
            catch (IOException e) {
                throw this.wrap(e);
            }
            catch (UnsupportedCallbackException e) {
                throw this.wrap(e);
            }
            SessionState preLogonSession = (SessionState)s.getAttribute();
            if (preLogonSession != null) {
                String startPath = preLogonSession.startPath();
                LogonRealm realm = preLogonSession.logonRealm();
                return this.session(startPath, realm, (Iterable<Principal>)result);
            }
        }
        return result;
    }

    private AuthenticationResult session(String startPath, LogonRealm realm, Iterable<Principal> principals) {
        CompoundPrincipal principal = CompoundPrincipal.compound(principals);
        if (principal == null) {
            return null;
        }
        SessionState session = SessionState.authenticatedSession(startPath, realm, principal);
        ArrayList<ServletSessionPrincipal> all = new ArrayList<ServletSessionPrincipal>();
        Iterables.add(all, principals);
        all.add(new ServletSessionPrincipal("_com.oracle.al", session));
        return AuthenticationResult.valid(all);
    }
}

