/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.auth.HeaderCallback;
import oracle.dbtools.auth.HttpServletRequestCallback;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.authentication.apex.SessionVerifierBase;

@Service(priority=2)
@Authenticates(value=AuthenticationRealm.RESOURCE_TEMPLATES)
public class ExternalSessionVerifier
extends SessionVerifierBase
implements RealmAuthenticator {
    private String externalRolesHeader;
    private String externalUserHeader;
    private boolean verifyOrigin = true;
    public static final String EXTERNAL_ROLES_HEADER = "security.externalRolesHeader";
    public static final String EXTERNAL_SESSION_VERIFY_ORIGIN = "security.externalSessionVerifyOrigin";
    public static final String EXTERNAL_USER_HEADER = "security.externalUserHeader";

    public AuthenticationResult authenticate(CallbackHandler callbackHandler) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)this.externalUserHeader)) {
            HeaderCallback u = new HeaderCallback((CharSequence)this.externalUserHeader);
            HeaderCallback o = new HeaderCallback((CharSequence)"Origin");
            HttpServletRequestCallback req = new HttpServletRequestCallback();
            this.callback(callbackHandler, new Callback[]{u, o, req});
            String user = u.getValue();
            String[] roles = new String[]{};
            if (!NullOrEmpty.nullOrEmpty((CharSequence)user)) {
                HttpServletRequest request;
                String origin;
                if (!NullOrEmpty.nullOrEmpty((CharSequence)this.externalRolesHeader)) {
                    HeaderCallback r = new HeaderCallback((CharSequence)this.externalRolesHeader);
                    this.callback(callbackHandler, new Callback[]{r});
                    String text = r.getValue();
                    if (!NullOrEmpty.nullOrEmpty((CharSequence)text)) {
                        roles = Text.commaDelimited((String)text);
                    }
                }
                if (this.verifyOrigin(origin = o.getValue(), request = req.getRequest())) {
                    return this.authorize(callbackHandler, user, roles);
                }
            }
        }
        return AuthenticationResult.unknown();
    }

    protected void activate(ServiceProperties props) {
        this.externalUserHeader = GlobalConfiguration.globalConfiguration().get(EXTERNAL_USER_HEADER);
        this.externalRolesHeader = GlobalConfiguration.globalConfiguration().get(EXTERNAL_ROLES_HEADER);
        this.verifyOrigin = (Boolean)PrimitiveTypes.valueOf((CharSequence)GlobalConfiguration.globalConfiguration().get(EXTERNAL_SESSION_VERIFY_ORIGIN, "true"), Boolean.class);
    }

    private String serverOrigin(HttpServletRequest request) {
        StringBuilder b = new StringBuilder();
        String scheme = request.getScheme();
        b.append(scheme);
        b.append("://");
        b.append(request.getServerName());
        int port = request.getServerPort();
        if (this.includePort(scheme, port)) {
            b.append(':');
            b.append(port);
        }
        return b.toString();
    }

    private boolean includePort(String scheme, int port) {
        boolean includePort = true;
        if (port > -1) {
            if ("http".equals(scheme) && 80 == port) {
                includePort = false;
            } else if ("https".equals(scheme) && 443 == port) {
                includePort = false;
            }
        } else {
            includePort = false;
        }
        return includePort;
    }

    private boolean verifyOrigin(String origin, HttpServletRequest request) {
        if (this.verifyOrigin) {
            String expected = this.serverOrigin(request);
            return origin == null || expected.equals(origin);
        }
        return true;
    }

    ExternalSessionVerifier externalRolesHeader(String externalRolesHeader) {
        this.externalRolesHeader = externalRolesHeader;
        return this;
    }

    ExternalSessionVerifier externalUserHeader(String externalUserHeader) {
        this.externalUserHeader = externalUserHeader;
        return this;
    }

    ExternalSessionVerifier verifyOrigin(boolean verify) {
        this.verifyOrigin = verify;
        return this;
    }
}

