/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.layout;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.adfdtinternal.model.dvt.util.gui.layout.PageItem;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.dnd.JFCSupport;
import oracle.bali.ewt.elaf.EWTPagingComponentUI;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.pivot.PagingPivotEvent;
import oracle.bali.ewt.pivot.PagingPivotListener;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.bali.share.event.ListenerManager;

public class PagingComponent
extends LWComponent
implements Scrollable,
Accessible {
    public static final Object PRINT_RAISED = "pagingComponent.printRaised";
    public static final String PROPERTY_SELECTION = "selectedIndex";
    protected static final int INSTR_TEXT_PADDING_LEFT = 10;
    public static final Color HINT_TEXT = new Color(90, 90, 90);
    private static final KeyStroke _KEY_STROKE_LEFT = KeyStroke.getKeyStroke(37, 0);
    private static final KeyStroke _KEY_STROKE_RIGHT = KeyStroke.getKeyStroke(39, 0);
    private static final String _DRAG_GESTURE_RECOGNIZER = "oracle.bali.ewt.pivot.PagingComponent.DRAG_GESTURE_RECOGNIZER";
    static final String COMMAND_LEFT = "LEFT";
    static final String COMMAND_RIGHT = "RIGHT";
    private static final int _FEEDBACK_SIZE = 5;
    private static final int _PIVOT_SIZE = 6;
    private PageItem _dragComponent;
    private int _dragIndex = -1;
    private int _dropIndex = -1;
    private PageItem _selectedItem;
    private boolean _allowSwap;
    private boolean _swapping;
    private DragGestureListener _draggy;
    private DropTargetListener _droppy;
    private ListenerManager _pivotListeners;
    private UIListener _listener;
    private boolean _prefSizeSet;
    private DropTarget _dropTarget;
    private boolean _selectionTransparent;
    private boolean m_bScrollingEnabled = true;
    private static final int NO_RESIZING_NEEDED = -1;
    private String m_strInstructionText = null;

    public PagingComponent() {
        this(null);
    }

    public PagingComponent(PageItem[] items) {
        this(items, true);
    }

    public PagingComponent(PageItem[] items, boolean bScrollingEnabled) {
        this.setLayout(null);
        this.setScrollingEnabled(bScrollingEnabled);
        this._listener = new UIListener();
        this._droppy = new Droppy();
        this._draggy = new Draggy();
        this.enableEvents(16L);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                this.add((Component)((Object)items[i]));
            }
        }
        this._dropTarget = new DropTarget((Component)((Object)this), this._droppy);
        this.updateUI();
    }

    public static JFrame getFrameForComponent(Component component) {
        JFrame jFrame = null;
        while (component != null) {
            if (component instanceof JFrame) {
                jFrame = (JFrame)component;
                break;
            }
            component = component instanceof JPopupMenu ? ((JPopupMenu)component).getInvoker() : component.getParent();
        }
        return jFrame;
    }

    public void dispose() {
        if (this._dropTarget == null) {
            return;
        }
        Component[] components = this.getComponents();
        int count = components == null ? 0 : components.length;
        for (int i = 0; i < count; ++i) {
            this.remove(components[i]);
            if (!(components[i] instanceof PageItem)) continue;
            ((PageItem)((Object)components[i])).dispose();
        }
        this._dropTarget.setComponent(null);
        this._dropTarget.removeDropTargetListener(this._droppy);
        this._dropTarget = null;
        this._listener = null;
        this._droppy = null;
        this._draggy = null;
        this._dragComponent = null;
        this._selectedItem = null;
        this._pivotListeners = null;
    }

    public void setScrollingEnabled(boolean bScrollingEnabled) {
        this.m_bScrollingEnabled = bScrollingEnabled;
    }

    public boolean isScrollingEnabled() {
        return this.m_bScrollingEnabled;
    }

    public void setInstructionText(String strInstructionText) {
        this.m_strInstructionText = strInstructionText;
    }

    public String getInstructionText() {
        return this.m_strInstructionText;
    }

    public PageItem getItem(int index) {
        Component c = this.getComponent(index);
        return c instanceof PageItem ? (PageItem)((Object)c) : null;
    }

    public int getIndex(PageItem item) {
        return this._getIndex((Component)((Object)item));
    }

    public void setSelectedItem(PageItem item) {
        if (this._selectedItem != item) {
            PageItem old = this._selectedItem;
            if (this._selectedItem != null) {
                this._selectedItem.setSelected(false);
            }
            this._selectedItem = item;
            if (this._selectedItem != null) {
                this._selectedItem.setSelected(true);
                this._ensureVisible(this._selectedItem);
            }
            this.firePropertyChange(PROPERTY_SELECTION, old, this._selectedItem);
            this.repaint();
        }
    }

    public PageItem getSelectedItem() {
        return this._selectedItem;
    }

    public void setSelectionTransparent(boolean transparent) {
        if (transparent != this._selectionTransparent) {
            this._selectionTransparent = transparent;
            PageItem selected = this.getSelectedItem();
            if (selected != null) {
                selected.repaint();
            }
        }
    }

    public boolean isSelectionTransparent() {
        return this._selectionTransparent;
    }

    public void setSwapAllowed(boolean allowSwap) {
        this._allowSwap = allowSwap;
    }

    public boolean isSwapAllowed() {
        return this._allowSwap;
    }

    public synchronized void addPivotListener(PagingPivotListener listener) {
        if (this._pivotListeners == null) {
            this._pivotListeners = new ListenerManager();
        }
        this._pivotListeners.addListener((EventListener)listener);
    }

    public synchronized void removePivotListener(PagingPivotListener listener) {
        if (this._pivotListeners != null) {
            this._pivotListeners.removeListener((EventListener)listener);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int unit = 0;
        if (1 == orientation) {
            return unit;
        }
        ImmInsets borderInsets = this.getBorderInsets();
        visibleRect.x += borderInsets.left;
        Component c = this.getComponentAt(visibleRect.x, this.getHeight() / 2);
        if (c == null || c == this) {
            return unit;
        }
        int index = this._getIndex(c);
        if (direction < 0) {
            int temp = visibleRect.x - c.getLocation().x;
            if (index == 0) {
                unit = temp > visibleRect.width ? visibleRect.width : temp;
            } else if (temp == 0) {
                int tempWidth;
                c = this.getComponent(index - 1);
                unit = tempWidth = c.getSize().width;
                if (index == 1 && tempWidth > visibleRect.width) {
                    unit = visibleRect.width;
                }
            } else {
                unit = temp;
            }
        } else {
            int hiddenWidth;
            int extraWidth;
            unit = index != this.getComponentCount() - 1 ? c.getSize().width : ((extraWidth = c.getSize().width - (hiddenWidth = visibleRect.x - c.getLocation().x)) > visibleRect.width ? visibleRect.width : extraWidth);
        }
        return unit;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        int parentWidth;
        int preferredWidth = this.getPreferredSize().width;
        if (this.getParent() instanceof JViewport) {
            JViewport vp = (JViewport)this.getParent();
            parentWidth = vp.getExtentSize().width;
        } else {
            parentWidth = preferredWidth;
        }
        return parentWidth > preferredWidth;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printPage(PaintContext context, Dictionary printProperties, Graphics g) {
        Shape savedClip = g.getClip();
        Rectangle clip = g.getClipBounds();
        if (context == null) {
            context = this.getPrintPaintContext(g);
        }
        this.freezeRepaints();
        try {
            boolean newRaised = PrinterUtils.getPrinterProperty((Dictionary)printProperties, (Object)PRINT_RAISED, (boolean)false);
            int count = this.getComponentCount();
            int x = 0;
            int y = 0;
            ImmInsets insets = this.getBorderInsets();
            int height = this.getPreferredSize().height - (insets.top + insets.bottom);
            UIDefaults defaults = context.getPaintUIDefaults();
            Color dark = defaults.getColor("darkIntensity");
            for (int i = 0; i < count; ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof PageItem)) continue;
                PageItem item = (PageItem)((Object)c);
                Dimension size = item.getDocumentSize(context, printProperties);
                if (x + size.width > clip.width) {
                    g.translate(0, y);
                    g.setClip(0, 0, 2, height);
                    g.setColor(dark);
                    g.drawLine(0, 0, 0, height);
                    g.translate(0, -y);
                    y += height - 1;
                    x = 0;
                }
                g.translate(x, y);
                g.setClip(0, 0, size.width, height);
                boolean oldRaised = item.isDrawRaised();
                item.setDrawRaised(newRaised);
                item.printPage(context, printProperties, g);
                item.setDrawRaised(oldRaised);
                g.translate(-x, -y);
                x += size.width;
            }
            g.translate(0, y);
            g.setClip(0, 0, 2, height - 1);
            g.setColor(dark);
            g.drawLine(0, 0, 0, height - 1);
            g.translate(0, -y);
        }
        finally {
            this.unfreezeRepaints();
        }
        g.setClip(savedClip);
    }

    public Dimension getDocumentSize(PaintContext context, Dictionary printProperties) {
        return this.getPreferredSize();
    }

    public Rectangle getPageBounds(PaintContext context, Dictionary printProperties, int pageXOrigin, int pageYOrigin, int pageWidth, int pageHeight) {
        Dimension prefSize = this.getPreferredSize();
        ImmInsets insets = this.getBorderInsets();
        int height = prefSize.height - (insets.top + insets.bottom + 1);
        if (prefSize.width >= pageWidth) {
            int maxWidth = 0;
            int itemCount = this.getComponentCount();
            int x = 0;
            int rows = 1;
            for (int i = 0; i < itemCount; ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof PageItem)) continue;
                PageItem item = (PageItem)((Object)c);
                Dimension itemSize = item.getDocumentSize(context, printProperties);
                if (x + itemSize.width > pageWidth) {
                    ++rows;
                    x = 0;
                }
                if ((x += itemSize.width) <= maxWidth) continue;
                maxWidth = x;
            }
            pageWidth = maxWidth;
            pageHeight = rows * height;
            pageXOrigin = prefSize.width;
        } else {
            pageXOrigin = pageWidth;
            pageHeight = prefSize.height;
        }
        return new Rectangle(pageXOrigin, pageHeight, pageWidth, pageHeight);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePagingComponent();
        }
        return this.accessibleContext;
    }

    public String getUIClassID() {
        return "EWTPagingComponentUI";
    }

    public void updateUI() {
        this.setUI((ComponentUI)((EWTPagingComponentUI)UIManager.getUI((JComponent)((Object)this))));
    }

    public void doLayout() {
        ImmInsets immInsets = this.getBorderInsets();
        int nHeight = this.getHeight() - (immInsets.top + immInsets.bottom);
        Component[] components = this.getComponents();
        int nCount = components == null ? 0 : components.length;
        int nX = immInsets.left;
        int nTotalWidth = -1;
        Dimension sizePagingComponent = this.getSize();
        if (!this.isScrollingEnabled()) {
            nTotalWidth = this.isResizingNeeded((Container)((Object)this));
        }
        for (int i = 0; i < nCount; ++i) {
            Component component = components[i];
            Dimension sizeComponent = component.getPreferredSize();
            if (!this.isScrollingEnabled() && nTotalWidth != -1) {
                sizeComponent.width = this.getScaledWidth(sizeComponent.width, nTotalWidth, (int)sizePagingComponent.getWidth());
            }
            component.setBounds(nX, immInsets.top, sizeComponent.width, nHeight);
            nX += sizeComponent.width;
        }
    }

    protected int getScaledWidth(int nCurrent, int nTotal, int nAvailable) {
        int nScaledValue = nCurrent;
        if (nCurrent > 0 && nTotal > 0 && nAvailable > 0) {
            nScaledValue = nCurrent * nAvailable / nTotal;
        }
        return nScaledValue;
    }

    protected int isResizingNeeded(Container container) {
        Component[] components;
        int nTotalWidth = -1;
        if (container != null && (components = container.getComponents()) != null && components.length > 0) {
            int nLength = components.length;
            int nWidth = 0;
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                nWidth = (int)((double)nWidth + components[nIndex].getPreferredSize().getWidth());
            }
            Dimension sizeContainer = container.getSize();
            if (sizeContainer.getWidth() < (double)nWidth) {
                nTotalWidth = nWidth;
            }
        }
        return nTotalWidth;
    }

    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
        this._prefSizeSet = true;
    }

    public Dimension getPreferredSize() {
        Font f;
        if (this._prefSizeSet) {
            return super.getPreferredSize();
        }
        int width = 5;
        int height = -1;
        Component[] comps = this.getComponents();
        int count = comps == null ? 0 : comps.length;
        for (int i = 0; i < count; ++i) {
            Component c = comps[i];
            Dimension d = c.getPreferredSize();
            width += d.width;
            if (d.height <= height) continue;
            height = d.height;
        }
        if (height == -1 && (f = this.getFont()) != null) {
            height = this.getFontMetrics(f).getHeight() + 10;
        }
        ImmInsets insets = this.getBorderInsets();
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    public void remove(int index) {
        AccessibleContext ac;
        Component c = this.getComponent(index);
        super.remove(index);
        this._removeDropTarget(c);
        if (c instanceof PageItem) {
            this._removeDragListener(c);
        }
        c.removeMouseListener(this._listener);
        c.removeFocusListener(this._listener);
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.removePropertyChangeListener(this._listener);
            this._unregisterKeyStrokes(jc);
        }
        if (this._selectedItem == c) {
            this.setSelectedItem(null);
        }
        if ((ac = this.accessibleContext) != null && c instanceof Accessible) {
            ac.firePropertyChange("AccessibleChild", c, null);
        }
        this.revalidate();
        this.repaint();
    }

    public void removeAll() {
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            this.remove(0);
        }
        this.setSelectedItem(null);
        this.revalidate();
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            DropTarget dropTarget = new DropTarget((Component)parent, this._droppy);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            JFCSupport.setEWTDropTarget((JComponent)((JComponent)parent), null);
        }
    }

    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle;
        if (this.isOpaque() && graphics != null && (rectangle = graphics.getClipBounds()) != null) {
            Color colorOld = graphics.getColor();
            graphics.setColor(UIManager.getColor("TextArea.background"));
            graphics.fillRect(0, 0, (int)rectangle.getWidth(), (int)rectangle.getHeight());
            graphics.setColor(colorOld);
        }
        super.paintComponent(graphics);
        this.drawInstructionText(graphics);
    }

    protected void drawInstructionText(Graphics graphics) {
        Component[] components;
        String strInstructionText = this.getInstructionText();
        if (strInstructionText != null && strInstructionText.length() != 0 && ((components = this.getComponents()) == null || components.length == 0)) {
            graphics.setColor(HINT_TEXT);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D rectangle = fontMetrics.getStringBounds(strInstructionText, graphics);
            graphics.drawString(strInstructionText, (int)rectangle.getX() + 10, (int)rectangle.getHeight());
        }
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        AccessibleContext ac;
        super.addImpl(comp, constraints, index);
        this._addDropTarget(comp);
        if (comp instanceof PageItem) {
            this._addDragListener((Component)((Object)((PageItem)((Object)comp))));
        }
        comp.addMouseListener(this._listener);
        comp.addFocusListener(this._listener);
        if (comp instanceof JComponent) {
            JComponent jc = (JComponent)comp;
            jc.addPropertyChangeListener(this._listener);
            this._registerKeyStrokes(jc);
        }
        if (comp instanceof Accessible && (ac = this.accessibleContext) != null) {
            ((Accessible)((Object)comp)).getAccessibleContext().setAccessibleParent(this);
            ac.firePropertyChange("AccessibleChild", null, comp);
        }
        this.revalidate();
        this.repaint();
    }

    protected void processEventImpl(AWTEvent e) {
        if (e instanceof PagingPivotEvent) {
            this.processPivotEvent((PagingPivotEvent)e);
        } else {
            super.processEventImpl(e);
        }
    }

    protected void processPivotEvent(PagingPivotEvent e) {
        if (this._pivotListeners == null) {
            return;
        }
        Enumeration enumeration = this._pivotListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (e.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((PagingPivotListener)enumeration.nextElement()).pivot(e);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    ((PagingPivotListener)enumeration.nextElement()).swap(e);
                }
                break;
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.isConsumed() || !this.isEnabled() || e.getID() != 501) {
            return;
        }
        this.setSelectedItem(null);
    }

    protected void paintOverChildren(Graphics g) {
        if (!this._swapping && this._dropIndex != -1) {
            int position;
            int temp;
            if (this._dragComponent != null && ((temp = this._getIndex((Component)((Object)this._dragComponent))) == this._dropIndex || temp + 1 == this._dropIndex)) {
                return;
            }
            int count = this.getComponentCount();
            if (this._dropIndex == count) {
                if (count == 0) {
                    position = 0;
                } else {
                    Component c = this.getComponent(count - 1);
                    position = c.getLocation().x + c.getSize().width;
                }
            } else {
                position = this.getComponent((int)this._dropIndex).getLocation().x;
            }
            Color oldColor = g.getColor();
            g.setColor(Color.BLUE);
            ImmInsets insets = this.getBorderInsets();
            Rectangle rect = new Rectangle(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
            int x = position - 2;
            if (x < rect.x) {
                x = rect.x;
            }
            if (x + 5 > rect.width) {
                x = rect.width - 5;
            }
            g.fillRect(x, rect.y, 2, rect.height);
            if (oldColor != null) {
                g.setColor(oldColor);
            }
        }
    }

    EWTPagingComponentUI getUI() {
        return (EWTPagingComponentUI)this.ui;
    }

    Image getDragImage(int index) {
        PageItem i = this.getItem(index);
        return i == null ? null : i.getDragImage();
    }

    final void firePivotEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        PagingPivotEvent e = new PagingPivotEvent(source, 2001, destination, sourceIndex, destinationIndex);
        this.processEvent((AWTEvent)e);
    }

    final void fireSwapEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        PagingPivotEvent e = new PagingPivotEvent(source, 2002, destination, sourceIndex, destinationIndex);
        this.processEvent((AWTEvent)e);
    }

    boolean isSwap(Component c, Point p) {
        boolean swap = false;
        if (this.isSwapAllowed() && c != this && c != this.getParent()) {
            swap = p.x >= 6 && p.x <= c.getSize().width - 6;
        }
        return swap;
    }

    private PageItem _convertPointAndFindPageItem(Component c, Point p) {
        if (c instanceof PageItem) {
            return (PageItem)((Object)c);
        }
        if (c == null) {
            return null;
        }
        Point temp = c.getLocation();
        p.x += temp.x;
        p.y += temp.y;
        return this._convertPointAndFindPageItem(c.getParent(), p);
    }

    int getIndex(Component c, Point p, boolean swap) {
        if (c == this || c == this.getParent()) {
            return this.getComponentCount();
        }
        int index = this._getIndex(c);
        if (!swap && p.x > c.getSize().width / 2) {
            ++index;
        }
        return index;
    }

    void setDropLocation(int index, boolean swapping) {
        if (this._dropIndex != index || swapping != this._swapping) {
            PageItem item;
            if (this._dropIndex != -1 && this._dropIndex < this.getComponentCount() && (item = this.getItem(this._dropIndex)) != null) {
                item.setSwapping(false);
            }
            this._dropIndex = index;
            this._swapping = swapping;
            if (this._dropIndex != -1 && this._dropIndex < this.getComponentCount() && (item = this.getItem(this._dropIndex)) != null) {
                item.setSwapping(swapping);
            }
            this.repaint();
        }
    }

    boolean acceptDrag(DropTargetDragEvent e) {
        if (!this.isEnabled()) {
            return false;
        }
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        if (flavors == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)PivotTransfer.DATA_FLAVOR)) continue;
            return true;
        }
        return false;
    }

    void moveRight() {
        int index;
        int count = this.getComponentCount();
        if (count == 0) {
            return;
        }
        int n = index = this._selectedItem == null ? 0 : this._getIndex((Component)((Object)this._selectedItem));
        if (++index > count - 1) {
            index = count - 1;
        }
        PageItem item = this.getItem(index);
        this.setSelectedItem(item);
        if (item != null) {
            item.requestFocus();
        }
    }

    void moveLeft() {
        int index;
        int count = this.getComponentCount();
        if (count == 0) {
            return;
        }
        int n = index = this._selectedItem == null ? 0 : this._getIndex((Component)((Object)this._selectedItem));
        if (--index < 0) {
            index = 0;
        }
        PageItem item = this.getItem(index);
        this.setSelectedItem(item);
        if (item != null) {
            item.requestFocus();
        }
    }

    private void _ensureVisible(PageItem item) {
        this.scrollRectToVisible(item.getBounds());
    }

    private int _getIndex(Component c) {
        int index = -1;
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (this.getComponent(i) != c) continue;
            index = i;
            break;
        }
        return index;
    }

    private void _addDropTarget(Component c) {
        DropTarget dummy = new DropTarget(c, this._droppy);
        if (c instanceof Container) {
            Container cont = (Container)c;
            int count = cont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this._addDropTarget(cont.getComponent(i));
            }
        }
    }

    private void _addDragListener(Component comp) {
        DragGestureRecognizer recognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(comp, 2, this._draggy);
        if (comp instanceof JComponent) {
            JComponent c = (JComponent)comp;
            c.putClientProperty(_DRAG_GESTURE_RECOGNIZER, recognizer);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            int count = cont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this._addDragListener(cont.getComponent(i));
            }
        }
    }

    private void _removeDragListener(Component comp) {
        if (comp instanceof JComponent) {
            JComponent c = (JComponent)comp;
            Object o = c.getClientProperty(_DRAG_GESTURE_RECOGNIZER);
            if (o instanceof DragGestureRecognizer) {
                DragGestureRecognizer r = (DragGestureRecognizer)o;
                r.setComponent(null);
                r.removeDragGestureListener(this._draggy);
            }
            c.putClientProperty(_DRAG_GESTURE_RECOGNIZER, null);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            int count = cont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this._removeDragListener(cont.getComponent(i));
            }
        }
    }

    private void _removeDropTarget(Component c) {
        if (c instanceof JComponent) {
            JComponent comp = (JComponent)c;
            DropTarget target = JFCSupport.getEWTDropTarget((JComponent)comp);
            if (target != null) {
                target.setComponent(null);
                target.removeDropTargetListener(this._droppy);
            }
            JFCSupport.setEWTDropTarget((JComponent)comp, null);
            int count = comp.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this._removeDropTarget(comp.getComponent(i));
            }
        }
    }

    private void _registerKeyStrokes(JComponent c) {
        UIListener listener = this._listener;
        c.registerKeyboardAction(listener, COMMAND_LEFT, _KEY_STROKE_LEFT, 0);
        c.registerKeyboardAction(listener, COMMAND_RIGHT, _KEY_STROKE_RIGHT, 0);
    }

    private void _unregisterKeyStrokes(JComponent c) {
        c.unregisterKeyboardAction(_KEY_STROKE_LEFT);
        c.unregisterKeyboardAction(_KEY_STROKE_RIGHT);
    }

    private class Droppy
    implements DropTargetListener {
        private Droppy() {
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (!PagingComponent.this.acceptDrag(dtde)) {
                dtde.rejectDrag();
                return;
            }
            Object c = dtde.getDropTargetContext().getComponent();
            Point p = dtde.getLocation();
            if (c != PagingComponent.this && c != PagingComponent.this.getParent()) {
                c = PagingComponent.this._convertPointAndFindPageItem((Component)c, p);
            }
            boolean swap = PagingComponent.this.isSwap((Component)c, p);
            int index = PagingComponent.this.getIndex((Component)c, p, swap);
            PagingComponent.this.setDropLocation(index, swap);
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (!PagingComponent.this.acceptDrag(dtde)) {
                dtde.rejectDrag();
                return;
            }
            Object c = dtde.getDropTargetContext().getComponent();
            Point p = dtde.getLocation();
            if (c != PagingComponent.this && c != PagingComponent.this.getParent()) {
                c = PagingComponent.this._convertPointAndFindPageItem((Component)c, p);
            }
            boolean swap = PagingComponent.this.isSwap((Component)c, p);
            int index = PagingComponent.this.getIndex((Component)c, p, swap);
            PagingComponent.this.setDropLocation(index, swap);
        }

        public void dragExit(DropTargetEvent dtde) {
            PagingComponent.this.setDropLocation(-1, false);
        }

        public void drop(DropTargetDropEvent e) {
            if (PagingComponent.this._dragComponent != null && PagingComponent.this._dropIndex != -1 && PagingComponent.this._getIndex((Component)((Object)PagingComponent.this._dragComponent)) == PagingComponent.this._dropIndex) {
                e.rejectDrop();
                PagingComponent.this.setDropLocation(-1, false);
                PagingComponent.this.repaint();
                return;
            }
            int index = PagingComponent.this._dropIndex;
            boolean swap = PagingComponent.this._swapping;
            PagingComponent.this.setDropLocation(-1, false);
            PagingComponent.this.repaint();
            Transferable transfer = e.getTransferable();
            Object data = null;
            try {
                data = transfer.getTransferData(PivotTransfer.DATA_FLAVOR);
            }
            catch (IOException ioException) {
                data = null;
            }
            catch (UnsupportedFlavorException ufException) {
                data = null;
            }
            boolean success = false;
            if (data != null && data instanceof PivotTransfer) {
                PivotTransfer pivotTransfer = (PivotTransfer)data;
                Object source = pivotTransfer.getSource();
                int sourceIndex = pivotTransfer.getIndex();
                if (!swap) {
                    if ((source == PagingComponent.this || source == PagingComponent.this.getParent()) && sourceIndex < index) {
                        --index;
                    }
                    PagingComponent.this.firePivotEvent(source, sourceIndex, PagingComponent.this, index);
                } else {
                    PagingComponent.this.fireSwapEvent(source, sourceIndex, PagingComponent.this, index);
                }
                success = true;
            }
            e.dropComplete(success);
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    private class Draggy
    implements DragGestureListener,
    DragSourceListener {
        private Draggy() {
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            Point origin = e.getDragOrigin();
            Component c = e.getComponent();
            PageItem item = this._getPageItem(c);
            if (item != null && item.isDragEnabled()) {
                int index = PagingComponent.this._getIndex((Component)((Object)item));
                Float floatTransparency = Float.valueOf(0.3f);
                BufferedImage dragImage = new BufferedImage(c.getWidth(), c.getHeight(), 3);
                Graphics graphics = dragImage.getGraphics();
                ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, floatTransparency.floatValue()));
                c.paint(graphics);
                Cursor cursor = Cursor.getPredefinedCursor(1);
                PagingComponent.this._dragComponent = item;
                PagingComponent.this._dragIndex = index;
                PagingComponent.this._dragComponent.setDragging(true);
                Transferable t = PivotTransfer.createTransferable((Object)PagingComponent.this, (int)index);
                e.startDrag(cursor, (Image)dragImage, new Point(5, -origin.y), t, (DragSourceListener)this);
            }
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (PagingComponent.this._dragComponent != null) {
                int count;
                if (PagingComponent.this._dragComponent.isShowing()) {
                    PagingComponent.this._dragComponent.requestFocus();
                } else if (PagingComponent.this._dragIndex != -1 && (count = PagingComponent.this.getComponentCount()) != 0) {
                    int index = PagingComponent.this._dragIndex - 1;
                    if (index < 0) {
                        index = 0;
                    }
                    if (index >= count) {
                        index = count - 1;
                    }
                    PagingComponent.this.getComponent(index).requestFocus();
                }
                PagingComponent.this._dragComponent.setDragging(false);
                PagingComponent.this._dragComponent = null;
                PagingComponent.this._dragIndex = -1;
            }
            PagingComponent.this.repaint();
        }

        public void dragEnter(DragSourceDragEvent dsde) {
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        public void dragExit(DragSourceEvent dsde) {
        }

        private PageItem _getPageItem(Component c) {
            if (c == null) {
                return null;
            }
            if (c instanceof PageItem) {
                return (PageItem)((Object)c);
            }
            return this._getPageItem(c.getParent());
        }
    }

    private class UIListener
    extends MouseAdapter
    implements PropertyChangeListener,
    ActionListener,
    FocusListener {
        private UIListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (PagingComponent.PROPERTY_SELECTION.equals(e.getPropertyName())) {
                PagingComponent.this.revalidate();
                PagingComponent.this.repaint();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PagingComponent.COMMAND_LEFT.equals(e.getActionCommand())) {
                PagingComponent.this.moveLeft();
            } else if (PagingComponent.COMMAND_RIGHT.equals(e.getActionCommand())) {
                PagingComponent.this.moveRight();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getComponent() instanceof PageItem) {
                PagingComponent.this.setSelectedItem((PageItem)((Object)e.getComponent()));
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            PageItem selectedItem = e.getComponent() instanceof PageItem ? (PageItem)((Object)e.getComponent()) : null;
            PagingComponent.this.setSelectedItem(selectedItem);
        }

        @Override
        public void focusLost(FocusEvent e) {
            PageItem selectedItem = null;
            selectedItem = e.isTemporary() || PagingComponent.this._dragComponent != null ? PagingComponent.this._selectedItem : null;
            PagingComponent.this.setSelectedItem(selectedItem);
        }
    }

    protected class AccessiblePagingComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        protected AccessiblePagingComponent() {
            super((JComponent)((Object)PagingComponent.this));
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            return PagingComponent.this.getSelectedItem() == null ? 0 : 1;
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            return i >= this.getAccessibleSelectionCount() ? null : PagingComponent.this.getSelectedItem();
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            return PagingComponent.this.getSelectedItem() == PagingComponent.this.getComponent(i);
        }

        @Override
        public void addAccessibleSelection(int i) {
            PagingComponent.this.setSelectedItem(PagingComponent.this.getItem(i));
        }

        @Override
        public void removeAccessibleSelection(int i) {
            if (PagingComponent.this.getSelectedItem() == PagingComponent.this.getComponent(i)) {
                PagingComponent.this.setSelectedItem(null);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            PagingComponent.this.setSelectedItem(null);
        }

        @Override
        public void selectAllAccessibleSelection() {
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (PagingComponent.this.getComponentCount() != 0 && states.contains(AccessibleState.ENABLED)) {
                states.add(AccessibleState.EDITABLE);
            }
            if (PagingComponent.this.hasFocus()) {
                states.add(AccessibleState.FOCUSED);
            }
            return states;
        }
    }
}

