/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureEventListener;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.ui.AbstractCommonMigrationProgressRunnable;
import oracle.dbtools.migration.workbench.plugin.MSAccessMigrationAddinArb;
import oracle.dbtools.migration.workbench.plugin.MSAccessPlugin;
import oracle.dbtools.migration.workbench.plugin.MSAccessXMLExporterFileParser;

public class MSAccessCapture
extends AbstractCommonMigrationProgressRunnable
implements CaptureEventListener {
    private CaptureContext _context;
    private MigrationStorer m_storer;
    private String m_mdbfile;
    private MSAccessXMLExporterFileParser m_parser;

    public MSAccessCapture(String string, MigrationStorer migrationStorer) {
        this.setTitle(MigrationAddinArb.getString((String)"CAPTURERUNNER_TITLE"));
        this.setMessage(MigrationAddinArb.getString((String)"CAPTURERUNNER_INITIAL_MESSAGE"));
        this._context = new CaptureContext();
        this._context.getAudience().addListener((CaptureEventListener)this);
        this.m_parser = new MSAccessXMLExporterFileParser(string, migrationStorer, this._context);
        this.m_storer = migrationStorer;
        this.m_mdbfile = string;
    }

    protected Object doWork() throws Exception {
        MdConnection mdConnection;
        try {
            mdConnection = this.storeConnection();
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, persistenceException.getLocalizedMessage());
            return Boolean.FALSE;
        }
        if (this.m_parser.loadFile()) {
            CapturedDatabases.getInstance().addMdConnection(mdConnection);
            int n = this.m_parser.getUAValue();
            MigrationAddin.getMigrationConfig().updateUACode(n);
            this.updateStatistics(mdConnection);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void updateStatistics(MdConnection mdConnection) throws PersistenceException {
        PersistenceUtility persistenceUtility = this.m_storer.getPersistenceUtility();
        persistenceUtility.updateConnectionStatistics(mdConnection);
    }

    public void raiseEvent(CaptureEvent captureEvent) {
        String string = MigrationAddinArb.getString((String)"STORING") + " " + captureEvent.getEventSource();
        switch (captureEvent.getEventId()) {
            case 1: {
                string = MessageFormat.format("{0} {1}", "CAPTURING", captureEvent.getEventSource());
                this.updateProgress(1, captureEvent, string);
                break;
            }
            case 2: {
                string = MessageFormat.format("{0} {1}", captureEvent.getEventSource(), "CAPTURED");
                this.updateProgress(2, captureEvent, string);
                break;
            }
            case 3: {
                string = MessageFormat.format("{0} {1}", "STORING", captureEvent.getEventSource());
                this.updateProgress(3, captureEvent, string);
                break;
            }
            case 4: {
                string = MessageFormat.format("{0} {1}", "STORED", captureEvent.getEventSource());
                this.updateProgress(4, captureEvent, string);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                string = MigrationAddinArb.getString((String)"START_CAPTURE");
                this.updateProgress(6, captureEvent, string);
                break;
            }
            case 7: {
                string = MigrationAddinArb.getString((String)"END_CAPTURE");
                this.updateProgress(7, captureEvent, string);
                break;
            }
        }
    }

    public void setTableCellRenderer() {
    }

    public void setToolTip() {
    }

    public String[] getColumnNames() {
        return new String[]{MigrationAddinArb.getString((String)"OBJECT_TYPE"), MigrationAddinArb.getString((String)"OBJECTS_CAPTURED")};
    }

    public String getEventString(Object object) {
        if (object != null && object instanceof CaptureEvent) {
            CaptureEvent captureEvent = (CaptureEvent)object;
            String string = null;
            if (captureEvent.getEventId() == 3) {
                for (int i = 0; i < CaptureEvent.CAPTURE_OBJECTS.length; ++i) {
                    if (!captureEvent.getEventSourceType().equalsIgnoreCase(CaptureEvent.CAPTURE_OBJECTS[i])) continue;
                    string = CaptureEvent.CAPTURE_OBJECTS[i];
                }
            }
            return string;
        }
        return null;
    }

    private MdConnection storeConnection() throws PersistenceException {
        MdProject mdProject = new MdProject("Dummy Access Project");
        mdProject = (MdProject)this.m_storer.storeObject((PersistableObject)mdProject);
        this._context.setContextVariable("PROJECTID", (Object)mdProject.getKey());
        MdConnection mdConnection = new MdConnection(mdProject.getKey());
        mdConnection.setDburl("dummy");
        mdConnection.setUsername("dummy");
        mdConnection.setPassword("dummy");
        CaptureEvent captureEvent = new CaptureEvent(3, MSAccessMigrationAddinArb.getString("CONNECTION"), mdConnection.getDburl());
        mdConnection.setName(MSAccessPlugin.getModelNameFromMDBFileName(this.m_mdbfile));
        mdConnection = (MdConnection)this.m_storer.storeObject((PersistableObject)mdConnection);
        mdConnection.addProperty("PLUGIN_ID", MSAccessPlugin.class.getName(), mdConnection.getKey());
        mdConnection = (MdConnection)this.m_storer.storeObject((PersistableObject)mdConnection);
        this._context.setContextVariable("CONNECTIONID", (Object)mdConnection.getKey());
        captureEvent.setEventId(4);
        this._context.getAudience().fireListeners(captureEvent);
        return mdConnection;
    }
}

