/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.schedule;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPTZ;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.GroupActionControl;
import oracle.dbtools.raptor.ui.controls.OptionalActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TemporalActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.IdSqlComboBoxActionControl;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalActionControl;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Identifier;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IdentifierImpl;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.QualifiedIdentifier;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenModel;
import oracle.javatools.util.ArrayMap;

public class ScheduleWhenActionControl
extends ActionControl {
    protected static final String EMPTY_STRING = "";
    protected static final String WHITESPACE = " ";
    protected static final String UNDERSCORE = "_";
    protected static final String PERIOD = ".";
    protected static final String PERIOD_REGEX = "[.]";
    private final FCOTarget target;
    private final Connection connection;
    private ActionControl.Value value;
    private OraTemporalDatum cacheDelayedStartDate;
    private final Format valuesDateFormat;
    private final DateFormat controlDateFormat;
    private ScheduleWhenModel model;
    private PropertyChangeListener delegateChangelistener;
    private final PropertyChangeSupport propertyChangeDelegate = new PropertyChangeSupport((Object)this);
    private CardLayoutActionControl cardActionControl;
    private Map<CardType, ActionControl> cardMap;
    private CardLayoutPanel.Type type;
    private String cardLayoutTitle;
    private final boolean fileWatcherAllowed;
    private final boolean queueAllowed;
    private boolean layedOut = false;

    public static CardType getCardType(String string) {
        for (CardType cardType : CardType.values()) {
            if (!cardType.displayName.equals(string)) continue;
            return cardType;
        }
        return CardType.valueOf(string);
    }

    public static CardType getCardType(ScheduleWhenModel.EventType eventType) {
        for (CardType cardType : CardType.values()) {
            if (cardType.eventType != eventType) continue;
            return cardType;
        }
        return null;
    }

    public ScheduleWhenActionControl(String string, String string2, CardLayoutPanel.Type type, String string3, FCOTarget fCOTarget, Connection connection) {
        this(string, string2, type, string3, fCOTarget, connection, null);
    }

    public ScheduleWhenActionControl(String string, String string2, CardLayoutPanel.Type type, String string3, FCOTarget fCOTarget, Connection connection, Format format) {
        this(string, string2, type, string3, fCOTarget, connection, format, null);
    }

    public ScheduleWhenActionControl(String string, String string2, CardLayoutPanel.Type type, String string3, FCOTarget fCOTarget, Connection connection, Format format, DateFormat dateFormat) {
        super(string, string2);
        this.type = type;
        this.cardLayoutTitle = string3;
        this.cardActionControl = null;
        this.target = fCOTarget;
        this.connection = connection;
        this.fileWatcherAllowed = fCOTarget != FCOTarget.WINDOW && DBUtil.checkVersion((Connection)connection, null, (Version)new Version("11.2"));
        this.queueAllowed = fCOTarget != FCOTarget.WINDOW && DBUtil.checkVersion((Connection)connection, null, (Version)new Version("10.2"));
        this.value = new ActionControl.Value();
        this.cacheDelayedStartDate = null;
        this.valuesDateFormat = format;
        this.controlDateFormat = dateFormat;
        this.delegateChangelistener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ScheduleWhenActionControl.this.propertyChangeDelegate.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        };
        this.model = null;
        this.setModel(new ScheduleWhenModel());
        this.propertyChangeDelegate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                ScheduleWhenModel.Property property = ScheduleWhenModel.Property.valueOf(string);
                String string2 = property.getValueName();
                Object object = propertyChangeEvent.getNewValue();
                ScheduleWhenActionControl.this.updateValueProperty(string2, ScheduleWhenActionControl.this.castToString(property, object));
                switch (property) {
                    case SCHEDULE_NAME: 
                    case SCHEDULE_OWNER: {
                        String string3 = ScheduleWhenActionControl.this.model.makeScheduleSpec();
                        ScheduleWhenActionControl.this.updateValueProperty(ScheduleWhenModel.SCHEDULE_SPEC, string3);
                        break;
                    }
                    case EVENT_QUEUE_AGENT: 
                    case EVENT_QUEUE_NAME: 
                    case EVENT_QUEUE_OWNER: 
                    case FILE_WATCHER_NAME: 
                    case FILE_WATCHER_OWNER: {
                        String string4 = ScheduleWhenActionControl.this.model.makeQueueSpec();
                        ScheduleWhenActionControl.this.updateValueProperty(ScheduleWhenModel.QUEUE_SPEC, string4);
                    }
                }
                ScheduleWhenActionControl.this.firePropertyChangeListeners();
            }
        });
    }

    protected void updateValueProperty(String string, String string2) {
        if (string2 != null) {
            this.value.add(string, string2);
        } else {
            this.value.remove(string);
        }
    }

    public ScheduleWhenActionControl(CardLayoutPanel.Type type, String string, FCOTarget fCOTarget, Connection connection) {
        this(null, null, type, string, fCOTarget, connection);
    }

    protected ActionControl getCalendarPanel() {
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl();
        return propertyPanelActionControl;
    }

    private Format getValuesDateFormat() {
        return this.valuesDateFormat != null ? (Format)this.valuesDateFormat.clone() : null;
    }

    private DateFormat getControlDateFormat() {
        return this.controlDateFormat != null ? (DateFormat)this.controlDateFormat.clone() : null;
    }

    public ActionControl.Value getValue() {
        return this.value;
    }

    public CardLayoutPanel getUI() {
        if (!this.layedOut) {
            try {
                this.cardActionControl = this.createScheduleCard();
            }
            finally {
                this.layedOut = true;
            }
        }
        return this.cardActionControl.getUI();
    }

    public void setEditable(boolean bl) {
        this.cardActionControl.setEditable(bl);
    }

    public ScheduleWhenModel getModel() {
        return this.model;
    }

    public void setModel(ScheduleWhenModel scheduleWhenModel) {
        ScheduleWhenModel scheduleWhenModel2 = this.model;
        if (scheduleWhenModel != scheduleWhenModel2) {
            if (scheduleWhenModel2 != null) {
                scheduleWhenModel2.removePropertyChangeListener(this.delegateChangelistener);
            }
            this.model = scheduleWhenModel != null ? scheduleWhenModel : new ScheduleWhenModel();
            this.model.addPropertyChangeListener(this.delegateChangelistener);
            this.model.firePropertyChangeListeners(scheduleWhenModel2);
        }
    }

    protected String getQuery(Connection connection, String string) {
        return Utils.getQuery(ScheduleWhenActionControl.class, (Connection)connection, (String)string);
    }

    protected CardLayoutActionControl createScheduleCard() {
        this.cardMap = new ArrayMap<CardType, ActionControl>(){
            {
                if (ScheduleWhenActionControl.this.target == FCOTarget.JOB) {
                    this.put((Object)CardType.IMMEDIATE, ScheduleWhenActionControl.this.createImmediatePanel());
                    this.put((Object)CardType.ONCE, ScheduleWhenActionControl.this.createOncePanel());
                }
                this.put((Object)CardType.CALENDAR, ScheduleWhenActionControl.this.createCalendarPanel());
                if (ScheduleWhenActionControl.this.queueAllowed) {
                    this.put((Object)CardType.QUEUE, ScheduleWhenActionControl.this.createQueueEventPanel());
                }
                if (ScheduleWhenActionControl.this.fileWatcherAllowed) {
                    this.put((Object)CardType.FILE_WATCHER, ScheduleWhenActionControl.this.createFileWatcherEventPanel());
                }
                if (ScheduleWhenActionControl.this.target != FCOTarget.SCHEDULE) {
                    this.put((Object)CardType.SCHEDULE, ScheduleWhenActionControl.this.createSchedulePanel());
                    if (ScheduleWhenActionControl.this.target != FCOTarget.WINDOW) {
                        this.put((Object)CardType.WINDOW, ScheduleWhenActionControl.this.createWindowPanel());
                        this.put((Object)CardType.WINDOW_GROUP, ScheduleWhenActionControl.this.createWindowGroupPanel());
                    }
                }
            }
        };
        final CardLayoutActionControl cardLayoutActionControl = new CardLayoutActionControl(null, null, this.type, this.cardLayoutTitle, this.cardMap);
        cardLayoutActionControl.getUI().setPreferredSize(new Dimension(410, 196));
        ScheduleWhenModel.EventType eventType = this.model.getEventType();
        CardType cardType = ScheduleWhenActionControl.getCardType(eventType);
        cardLayoutActionControl.setSelected((Object)cardType);
        cardLayoutActionControl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ActionControl.Value value = (ActionControl.Value)propertyChangeEvent.getNewValue();
                String string = value != null ? value.get() : null;
                string = ScheduleWhenActionControl.castEmptyToNull(string);
                CardType cardType = ScheduleWhenActionControl.getCardType(string);
                ScheduleWhenModel.EventType eventType = cardType != null ? cardType.getEventType() : null;
                ScheduleWhenActionControl.this.model.setProperty(ScheduleWhenModel.Property.EVENT_TYPE, (Object)eventType);
                if (eventType == ScheduleWhenModel.EventType.DELAYED) {
                    ScheduleWhenActionControl.this.model.setProperty(ScheduleWhenModel.Property.START_DATE, ScheduleWhenActionControl.this.cacheDelayedStartDate);
                }
            }
        });
        this.propertyChangeDelegate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    ScheduleWhenModel.Property property = ScheduleWhenModel.Property.valueOf(propertyChangeEvent.getPropertyName());
                    if (property == ScheduleWhenModel.Property.EVENT_TYPE) {
                        ScheduleWhenModel.EventType eventType = (ScheduleWhenModel.EventType)((Object)propertyChangeEvent.getNewValue());
                        CardType cardType = ScheduleWhenActionControl.getCardType(eventType);
                        cardLayoutActionControl.setSelected((Object)cardType);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return cardLayoutActionControl;
    }

    protected ActionControl createImmediatePanel() {
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl();
        return propertyPanelActionControl;
    }

    protected ActionControl createOncePanel() {
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl();
        propertyPanelActionControl.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(ScheduleWhenActionControl.this.getDelayedStartDateActionControl());
            }
        });
        return propertyPanelActionControl;
    }

    protected ActionControl createCalendarPanel() {
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl();
        propertyPanelActionControl.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(ScheduleWhenActionControl.this.getRepeatIntervalActionControl());
                this.add(ScheduleWhenActionControl.this.getCalendarGroupActionControl());
            }
        });
        return propertyPanelActionControl;
    }

    protected ActionControl createQueueEventPanel() {
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl();
        propertyPanelActionControl.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(ScheduleWhenActionControl.this.getEventQueueIdActionControl());
                this.add(ScheduleWhenActionControl.this.getEventAgentActionControl());
                this.add(ScheduleWhenActionControl.this.getEventConditionActionControl());
                this.add(ScheduleWhenActionControl.this.getCalendarGroupActionControl());
            }
        });
        return propertyPanelActionControl;
    }

    protected ActionControl createFileWatcherEventPanel() {
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl();
        propertyPanelActionControl.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(ScheduleWhenActionControl.this.getFileWatcherIdActionControl());
                this.add(ScheduleWhenActionControl.this.getEventConditionActionControl());
                this.add(ScheduleWhenActionControl.this.getCalendarGroupActionControl());
            }
        });
        return propertyPanelActionControl;
    }

    protected ActionControl createSchedulePanel() {
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl();
        propertyPanelActionControl.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(ScheduleWhenActionControl.this.getScheduleIdActionControl());
            }
        });
        return propertyPanelActionControl;
    }

    protected ActionControl createWindowPanel() {
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl();
        propertyPanelActionControl.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(ScheduleWhenActionControl.this.getWindowIdActionControl());
            }
        });
        return propertyPanelActionControl;
    }

    protected ActionControl createWindowGroupPanel() {
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl();
        propertyPanelActionControl.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(ScheduleWhenActionControl.this.getWindowGroupIdActionControl());
            }
        });
        return propertyPanelActionControl;
    }

    protected ActionControl getCalendarGroupActionControl() {
        final ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(ScheduleWhenActionControl.this.getOptionalStartDateActionControl());
                this.add(ScheduleWhenActionControl.this.getOptionalEndDateActionControl());
            }
        };
        GroupActionControl groupActionControl = new GroupActionControl(){

            public List<ActionControl> getChildControls() {
                return arrayList;
            }
        };
        return groupActionControl;
    }

    protected ActionControl getDelayedStartDateActionControl() {
        final ScheduleWhenModel.Property property = ScheduleWhenModel.Property.START_DATE;
        OraTemporalDatum oraTemporalDatum = (OraTemporalDatum)this.model.getProperty(property);
        final TemporalActionControl temporalActionControl = new TemporalActionControl(property.toString(), SchedulerArb.getString("SCHEDULEWHEN_PANEL_START_DATE_LABEL"), oraTemporalDatum, this.getValuesDateFormat(), this.getControlDateFormat()){

            public OraTemporalDatum getNonNullDefaultValue() {
                OraTIMESTAMPTZ oraTIMESTAMPTZ = OraTIMESTAMPTZ.getInstance();
                oraTIMESTAMPTZ.setPrecision(OraTemporalDatum.Precision.SECOND);
                return oraTIMESTAMPTZ;
            }
        };
        temporalActionControl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if (object != null) {
                    object = temporalActionControl.getTemporalDatum();
                }
                ScheduleWhenActionControl.this.cacheDelayedStartDate = (OraTemporalDatum)object;
                if (ScheduleWhenActionControl.this.model.getEventType() == ScheduleWhenModel.EventType.DELAYED) {
                    ScheduleWhenActionControl.this.model.setProperty(property, object);
                }
            }
        });
        this.propertyChangeDelegate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    ScheduleWhenModel.Property property2 = ScheduleWhenModel.Property.valueOf(propertyChangeEvent.getPropertyName());
                    if (property2 == property) {
                        OraTemporalDatum oraTemporalDatum = (OraTemporalDatum)propertyChangeEvent.getNewValue();
                        temporalActionControl.set(oraTemporalDatum);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return temporalActionControl;
    }

    protected ActionControl getOptionalStartDateActionControl() {
        final ScheduleWhenModel.Property property = ScheduleWhenModel.Property.START_DATE;
        OraTemporalDatum oraTemporalDatum = (OraTemporalDatum)this.model.getProperty(property);
        final TemporalActionControl temporalActionControl = new TemporalActionControl(property.toString(), SchedulerArb.getString("SCHEDULEWHEN_PANEL_START_DATE_LABEL"), oraTemporalDatum, this.getValuesDateFormat(), this.getControlDateFormat()){

            public OraTemporalDatum getNonNullDefaultValue() {
                OraTIMESTAMPTZ oraTIMESTAMPTZ = OraTIMESTAMPTZ.getInstance();
                oraTIMESTAMPTZ.setPrecision(OraTemporalDatum.Precision.SECOND);
                return oraTIMESTAMPTZ;
            }
        };
        final OptionalActionControl optionalActionControl = new OptionalActionControl(oraTemporalDatum != null, (ActionControl)temporalActionControl);
        optionalActionControl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if (object != null) {
                    object = temporalActionControl.getTemporalDatum();
                }
                ScheduleWhenActionControl.this.model.setProperty(property, object);
            }
        });
        this.propertyChangeDelegate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    ScheduleWhenModel.Property property2 = ScheduleWhenModel.Property.valueOf(propertyChangeEvent.getPropertyName());
                    if (property2 == property) {
                        OraTemporalDatum oraTemporalDatum = (OraTemporalDatum)propertyChangeEvent.getNewValue();
                        if (oraTemporalDatum == null) {
                            optionalActionControl.set(false);
                            temporalActionControl.reset();
                        } else {
                            optionalActionControl.set(true);
                            temporalActionControl.set(oraTemporalDatum);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return optionalActionControl;
    }

    protected ActionControl getOptionalEndDateActionControl() {
        final ScheduleWhenModel.Property property = ScheduleWhenModel.Property.END_DATE;
        OraTemporalDatum oraTemporalDatum = (OraTemporalDatum)this.model.getProperty(property);
        final TemporalActionControl temporalActionControl = new TemporalActionControl(property.toString(), SchedulerArb.getString("SCHEDULEWHEN_PANEL_END_DATE_LABEL"), oraTemporalDatum, this.getValuesDateFormat(), this.getControlDateFormat()){

            public OraTemporalDatum getNonNullDefaultValue() {
                OraTIMESTAMPTZ oraTIMESTAMPTZ = OraTIMESTAMPTZ.getInstance();
                oraTIMESTAMPTZ.setPrecision(OraTemporalDatum.Precision.SECOND);
                return oraTIMESTAMPTZ;
            }
        };
        final OptionalActionControl optionalActionControl = new OptionalActionControl(oraTemporalDatum != null, (ActionControl)temporalActionControl);
        optionalActionControl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if (object != null) {
                    object = temporalActionControl.getTemporalDatum();
                }
                ScheduleWhenActionControl.this.model.setProperty(property, object);
            }
        });
        this.propertyChangeDelegate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    ScheduleWhenModel.Property property2 = ScheduleWhenModel.Property.valueOf(propertyChangeEvent.getPropertyName());
                    if (property2 == property) {
                        OraTemporalDatum oraTemporalDatum = (OraTemporalDatum)propertyChangeEvent.getNewValue();
                        if (oraTemporalDatum == null) {
                            optionalActionControl.set(false);
                            temporalActionControl.reset();
                        } else {
                            optionalActionControl.set(true);
                            temporalActionControl.set(oraTemporalDatum);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return optionalActionControl;
    }

    protected ActionControl getRepeatIntervalActionControl() {
        final ScheduleWhenModel.Property property = ScheduleWhenModel.Property.REPEAT_INTERVAL;
        final RepeatIntervalActionControl repeatIntervalActionControl = new RepeatIntervalActionControl(property.toString(), SchedulerArb.getString("SCHEDULEWHEN_PANEL_REPEAT_INTERVAL_LABEL"), this.connection, (String)this.model.getProperty(property));
        repeatIntervalActionControl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ActionControl.Value value = (ActionControl.Value)propertyChangeEvent.getNewValue();
                String string = value != null ? value.get() : null;
                string = ScheduleWhenActionControl.castEmptyToNull(string);
                ScheduleWhenActionControl.this.model.setProperty(property, string);
            }
        });
        this.propertyChangeDelegate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    ScheduleWhenModel.Property property2 = ScheduleWhenModel.Property.valueOf(propertyChangeEvent.getPropertyName());
                    if (property2 == property) {
                        String string = (String)propertyChangeEvent.getNewValue();
                        repeatIntervalActionControl.set(string);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return repeatIntervalActionControl;
    }

    protected ActionControl getEventConditionActionControl() {
        final ScheduleWhenModel.Property property = ScheduleWhenModel.Property.EVENT_CONDITION;
        final TextBoxActionControl textBoxActionControl = new TextBoxActionControl(property.toString(), SchedulerArb.getString("SCHEDULEWHEN_PANEL_CONDITION_LABEL"), (String)this.model.getProperty(property));
        textBoxActionControl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ActionControl.Value value = (ActionControl.Value)propertyChangeEvent.getNewValue();
                String string = value != null ? value.get() : null;
                string = ScheduleWhenActionControl.castEmptyToNull(string);
                ScheduleWhenActionControl.this.model.setProperty(property, string);
            }
        });
        this.propertyChangeDelegate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    ScheduleWhenModel.Property property2 = ScheduleWhenModel.Property.valueOf(propertyChangeEvent.getPropertyName());
                    if (property2 == property) {
                        String string = (String)propertyChangeEvent.getNewValue();
                        textBoxActionControl.set(string);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return textBoxActionControl;
    }

    protected ActionControl getEventAgentActionControl() {
        final ScheduleWhenModel.Property property = ScheduleWhenModel.Property.EVENT_QUEUE_AGENT;
        String string = this.getQuery(this.connection, "getAgents");
        String string2 = (String)this.model.getProperty(property);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        adminSqlComboBoxActionControl adminSqlComboBoxActionControl2 = new adminSqlComboBoxActionControl(property.toString(), SchedulerArb.getString("SCHEDULEWHEN_PANEL_AGENT_LABEL"), this.connection, string, hashMap, ScheduleWhenActionControl.castEmptyToNull(string2), false, false);
        adminSqlComboBoxActionControl adminSqlComboBoxActionControl3 = adminSqlComboBoxActionControl2.isLoaded() != null && adminSqlComboBoxActionControl2.isLoaded() == false ? new TextBoxActionControl(property.toString(), SchedulerArb.getString("SCHEDULEWHEN_PANEL_AGENT_LABEL"), ScheduleWhenActionControl.castNullToEmpty(string2)) : null;
        adminSqlComboBoxActionControl adminSqlComboBoxActionControl4 = adminSqlComboBoxActionControl3 != null ? adminSqlComboBoxActionControl3 : adminSqlComboBoxActionControl2;
        adminSqlComboBoxActionControl4.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ActionControl.Value value = (ActionControl.Value)propertyChangeEvent.getNewValue();
                String string = value != null ? value.get() : null;
                string = ScheduleWhenActionControl.castEmptyToNull(string);
                ScheduleWhenActionControl.this.model.setProperty(property, ScheduleWhenActionControl.castEmptyToNull(new IdentifierImpl(string).getId(false)));
            }
        });
        this.propertyChangeDelegate.addPropertyChangeListener(new PropertyChangeListener((TextBoxActionControl)adminSqlComboBoxActionControl3, adminSqlComboBoxActionControl2){
            final /* synthetic */ TextBoxActionControl val$textControl;
            final /* synthetic */ SqlComboBoxActionControl val$sqlControl;
            {
                this.val$textControl = textBoxActionControl;
                this.val$sqlControl = sqlComboBoxActionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    ScheduleWhenModel.Property property2 = ScheduleWhenModel.Property.valueOf(propertyChangeEvent.getPropertyName());
                    if (property2 == property) {
                        String string = (String)propertyChangeEvent.getNewValue();
                        if (this.val$textControl != null) {
                            this.val$textControl.set(ScheduleWhenActionControl.castNullToEmpty(string));
                        } else {
                            String string2 = ScheduleWhenActionControl.this.makeIdentifier(null, string);
                            this.val$sqlControl.setSelected((Object)ScheduleWhenActionControl.castEmptyToNull(string2));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return adminSqlComboBoxActionControl4;
    }

    protected ActionControl getEventQueueIdActionControl() {
        final ScheduleWhenModel.Property property = ScheduleWhenModel.Property.EVENT_QUEUE_OWNER;
        final ScheduleWhenModel.Property property2 = ScheduleWhenModel.Property.EVENT_QUEUE_NAME;
        String string = this.getQuery(this.connection, "getAdvancedQueues");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = this.makeIdentifier((String)this.model.getProperty(property), (String)this.model.getProperty(property2));
        final WhenIdSqlComboBoxActionControl whenIdSqlComboBoxActionControl = new WhenIdSqlComboBoxActionControl(property.toString() + UNDERSCORE + property2.toString(), SchedulerArb.getString("SCHEDULEWHEN_PANEL_QUEUE_LABEL"), this.connection, string, hashMap, ScheduleWhenActionControl.castEmptyToNull(string2), false, true);
        whenIdSqlComboBoxActionControl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ActionControl.Value value = (ActionControl.Value)propertyChangeEvent.getNewValue();
                String string = value != null ? value.get() : null;
                string = ScheduleWhenActionControl.castEmptyToNull(string);
                ScheduleWhenActionControl.this.model.setProperty(property, ScheduleWhenActionControl.this.getOwner(string));
                ScheduleWhenActionControl.this.model.setProperty(property2, ScheduleWhenActionControl.this.getName(string));
            }
        });
        this.propertyChangeDelegate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    ScheduleWhenModel.Property property3 = ScheduleWhenModel.Property.valueOf(propertyChangeEvent.getPropertyName());
                    switch (property3) {
                        case EVENT_QUEUE_NAME: 
                        case EVENT_QUEUE_OWNER: {
                            String string = (String)ScheduleWhenActionControl.this.model.getProperty(property);
                            String string2 = (String)ScheduleWhenActionControl.this.model.getProperty(property2);
                            String string3 = ScheduleWhenActionControl.this.makeIdentifier(string, string2);
                            whenIdSqlComboBoxActionControl.setSelected((Object)ScheduleWhenActionControl.castEmptyToNull(string3));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return whenIdSqlComboBoxActionControl;
    }

    protected ActionControl getFileWatcherIdActionControl() {
        final ScheduleWhenModel.Property property = ScheduleWhenModel.Property.FILE_WATCHER_OWNER;
        final ScheduleWhenModel.Property property2 = ScheduleWhenModel.Property.FILE_WATCHER_NAME;
        String string = this.getQuery(this.connection, "getFileWatchers");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = this.makeIdentifier((String)this.model.getProperty(property), (String)this.model.getProperty(property2));
        final WhenIdSqlComboBoxActionControl whenIdSqlComboBoxActionControl = new WhenIdSqlComboBoxActionControl(property.toString() + UNDERSCORE + property2.toString(), SchedulerArb.getString("SCHEDULEWHEN_PANEL_FILE_WATCHER_LABEL"), this.connection, string, hashMap, ScheduleWhenActionControl.castEmptyToNull(string2), false, true);
        whenIdSqlComboBoxActionControl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ActionControl.Value value = (ActionControl.Value)propertyChangeEvent.getNewValue();
                String string = value != null ? value.get() : null;
                string = ScheduleWhenActionControl.castEmptyToNull(string);
                ScheduleWhenActionControl.this.model.setProperty(property, ScheduleWhenActionControl.this.getOwner(string));
                ScheduleWhenActionControl.this.model.setProperty(property2, ScheduleWhenActionControl.this.getName(string));
            }
        });
        this.propertyChangeDelegate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    ScheduleWhenModel.Property property3 = ScheduleWhenModel.Property.valueOf(propertyChangeEvent.getPropertyName());
                    switch (property3) {
                        case FILE_WATCHER_NAME: 
                        case FILE_WATCHER_OWNER: {
                            String string = (String)ScheduleWhenActionControl.this.model.getProperty(property);
                            String string2 = (String)ScheduleWhenActionControl.this.model.getProperty(property2);
                            String string3 = ScheduleWhenActionControl.this.makeIdentifier(string, string2);
                            whenIdSqlComboBoxActionControl.setSelected((Object)ScheduleWhenActionControl.castEmptyToNull(string3));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return whenIdSqlComboBoxActionControl;
    }

    protected ActionControl getScheduleIdActionControl() {
        return this.getScheduleIdActionControl(ScheduleWhenModel.EventType.NAMED_SCHEDULE, "SCHEDULEWHEN_PANEL_SCHEDULE_LABEL", "getSchedules");
    }

    protected ActionControl getWindowIdActionControl() {
        return this.getScheduleIdActionControl(ScheduleWhenModel.EventType.NAMED_WINDOW, "SCHEDULEWHEN_PANEL_WINDOW_LABEL", "getWindows");
    }

    protected ActionControl getWindowGroupIdActionControl() {
        return this.getScheduleIdActionControl(ScheduleWhenModel.EventType.NAMED_WINDOW_GROUP, "SCHEDULEWHEN_PANEL_WINDOW_GROUP_LABEL", "getWindowGroups");
    }

    protected ActionControl getScheduleIdActionControl(final ScheduleWhenModel.EventType eventType, String string, String string2) {
        final ScheduleWhenModel.Property property = ScheduleWhenModel.Property.SCHEDULE_OWNER;
        final ScheduleWhenModel.Property property2 = ScheduleWhenModel.Property.SCHEDULE_NAME;
        String string3 = this.getQuery(this.connection, string2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string4 = eventType == this.model.getProperty(ScheduleWhenModel.Property.EVENT_TYPE) ? this.makeIdentifier((String)this.model.getProperty(property), (String)this.model.getProperty(property2)) : null;
        final WhenIdSqlComboBoxActionControl whenIdSqlComboBoxActionControl = new WhenIdSqlComboBoxActionControl(property.toString() + UNDERSCORE + property2.toString(), SchedulerArb.getString(string), this.connection, string3, hashMap, ScheduleWhenActionControl.castEmptyToNull(string4), false, true);
        whenIdSqlComboBoxActionControl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ActionControl.Value value = (ActionControl.Value)propertyChangeEvent.getNewValue();
                String string = value != null ? value.get() : null;
                string = ScheduleWhenActionControl.castEmptyToNull(string);
                ScheduleWhenActionControl.this.model.setProperty(property, ScheduleWhenActionControl.this.getOwner(string));
                ScheduleWhenActionControl.this.model.setProperty(property2, ScheduleWhenActionControl.this.getName(string));
            }
        });
        this.propertyChangeDelegate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    ScheduleWhenModel.Property property3 = ScheduleWhenModel.Property.valueOf(propertyChangeEvent.getPropertyName());
                    switch (property3) {
                        case SCHEDULE_NAME: 
                        case SCHEDULE_OWNER: {
                            String string = (String)ScheduleWhenActionControl.this.model.getProperty(property);
                            String string2 = (String)ScheduleWhenActionControl.this.model.getProperty(property2);
                            String string3 = ScheduleWhenActionControl.this.makeIdentifier(string, string2);
                            if (eventType != ScheduleWhenActionControl.this.model.getProperty(ScheduleWhenModel.Property.EVENT_TYPE)) break;
                            whenIdSqlComboBoxActionControl.setSelected((Object)ScheduleWhenActionControl.castEmptyToNull(string3));
                            break;
                        }
                        case EVENT_TYPE: {
                            ScheduleWhenModel.EventType eventType2 = (ScheduleWhenModel.EventType)((Object)propertyChangeEvent.getNewValue());
                            if (eventType != eventType2) break;
                            String string = ScheduleWhenActionControl.castEmptyToNull(whenIdSqlComboBoxActionControl.getValue().get());
                            ScheduleWhenActionControl.this.model.setProperty(property, ScheduleWhenActionControl.this.getOwner(string));
                            ScheduleWhenActionControl.this.model.setProperty(property2, ScheduleWhenActionControl.this.getName(string));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return whenIdSqlComboBoxActionControl;
    }

    private String makeIdentifier(String string, String string2) {
        String string3 = null;
        if (string != null || string2 != null) {
            QualifiedIdentifier qualifiedIdentifier = new QualifiedIdentifier(string, string2);
            string3 = qualifiedIdentifier.getId(Boolean.TRUE);
        }
        return ScheduleWhenActionControl.castEmptyToNull(string3);
    }

    private String getOwner(String string) {
        String string2 = null;
        if (string != null) {
            QualifiedIdentifier qualifiedIdentifier = new QualifiedIdentifier(string);
            Identifier identifier = qualifiedIdentifier.getUserNameId();
            string2 = identifier.getId(false);
        }
        return ScheduleWhenActionControl.castEmptyToNull(string2);
    }

    private String getName(String string) {
        String string2 = null;
        if (string != null) {
            QualifiedIdentifier qualifiedIdentifier = new QualifiedIdentifier(string);
            Identifier identifier = qualifiedIdentifier.getObjectNameId();
            string2 = identifier.getId(false);
        }
        return ScheduleWhenActionControl.castEmptyToNull(string2);
    }

    protected String castToString(ScheduleWhenModel.Property property, Object object) {
        if (object != null) {
            switch (property) {
                case START_DATE: 
                case END_DATE: {
                    return this.formatDATEValue((OraTemporalDatum)object);
                }
            }
            return object.toString();
        }
        return null;
    }

    protected String formatDATEValue(OraTemporalDatum oraTemporalDatum) {
        String string = null;
        if (oraTemporalDatum != null) {
            Format format = this.getValuesDateFormat();
            string = format instanceof DateFormat ? format.format(oraTemporalDatum.getTime()) : (format != null ? format.format(oraTemporalDatum) : oraTemporalDatum.toString());
        }
        return string;
    }

    private static String castEmptyToNull(String string) {
        return string == null || string.length() > 0 ? string : null;
    }

    private static String castNullToEmpty(String string) {
        return string != null ? string : EMPTY_STRING;
    }

    protected class adminSqlComboBoxActionControl
    extends WhenIdSqlComboBoxActionControl {
        public adminSqlComboBoxActionControl(String string, String string2, Connection connection, String string3, Map<String, Object> map, String string4, boolean bl, boolean bl2) {
            super(string, string2, connection, string3, map, string4, bl, bl2);
        }

        @Override
        protected SQLComboxModel createModel(String string, String string2, Map<String, Object> map, String string3) {
            this.setRaiseError(false);
            return super.createModel(string, string2, map, string3);
        }
    }

    protected class WhenIdSqlComboBoxActionControl
    extends IdSqlComboBoxActionControl {
        public WhenIdSqlComboBoxActionControl(String string, String string2, Connection connection, String string3, Map<String, Object> map, String string4, boolean bl, boolean bl2) {
            super(string, string2, connection, string3, map, string4, bl, bl2);
        }

        @Override
        protected Object convertToElement(Object object) {
            if (object instanceof String) {
                String string = (String)object;
                return new QualifiedIdentifier(string.length() > 0 ? string : null);
            }
            if (object == null) {
                return new QualifiedIdentifier(null);
            }
            return object;
        }
    }

    public static enum CardType {
        IMMEDIATE(ScheduleWhenModel.EventType.IMMEDIATE),
        ONCE(ScheduleWhenModel.EventType.DELAYED),
        CALENDAR(ScheduleWhenModel.EventType.REPEATING),
        QUEUE(ScheduleWhenModel.EventType.QUEUE_EVENT),
        FILE_WATCHER(ScheduleWhenModel.EventType.FILE_EVENT),
        SCHEDULE(ScheduleWhenModel.EventType.NAMED_SCHEDULE),
        WINDOW(ScheduleWhenModel.EventType.NAMED_WINDOW),
        WINDOW_GROUP(ScheduleWhenModel.EventType.NAMED_WINDOW_GROUP);

        private final ScheduleWhenModel.EventType eventType;
        private final String displayName;

        private CardType(ScheduleWhenModel.EventType eventType) {
            this.eventType = eventType;
            this.displayName = SchedulerArb.getString("SCHEDULEWHEN_CARD_" + super.toString() + "_LABEL");
        }

        public ScheduleWhenModel.EventType getEventType() {
            return this.eventType;
        }

        public String getDisplayName() {
            return this.displayName != null ? this.displayName : super.toString();
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    public static enum FCOTarget {
        SCHEDULE,
        JOB,
        WINDOW;

    }
}

