/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.component;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.ByClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Time;

public class TimePanel
extends ByClause
implements ActionListener {
    private boolean hourIncluded;
    private DateEditor timeEditor = new DateEditor(new Date());
    private JButton addButton;
    private JButton delButton;
    private JButton clearButton;
    private TreeSet<Time> selectedTimes;
    private TreeSet<Integer> selectedHours;
    private TreeSet<Integer> selectedMinutes;
    private TreeSet<Integer> selectedSeconds;
    private EventListenerList actionListeners;
    private boolean singleSelection;
    private boolean emulate;
    private Time[] initVal;
    private Time defaultTime;
    private String timeSep = ":";

    public TimePanel(Properties properties, boolean bl, boolean bl2, boolean bl3, Time[] timeArray) {
        super(properties);
        this.hourIncluded = bl;
        this.singleSelection = bl2;
        this.initVal = timeArray;
        this.emulate = bl3;
        this.defaultTime = new Time(0, 0, bl ? Integer.valueOf(12) : null);
        this.applyLocale(Locale.getDefault());
        this.setLayout(new GridBagLayout());
        Component component = this.createTimeComponents();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 4, 0));
        this.addButton = new JButton(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_ADD"));
        this.addButton.setActionCommand("Add");
        this.addButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_ADD_TOOLTIP"));
        this.addButton.addActionListener(this);
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(this.addButton);
        this.delButton = new JButton(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_REMOVE"));
        this.delButton.setActionCommand("Del");
        this.delButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_REMOVE_TOOLTIP"));
        this.delButton.addActionListener(this);
        this.delButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(this.delButton);
        this.clearButton = new JButton(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL"));
        this.clearButton.setActionCommand("Clear");
        this.clearButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL_TOOLTIP"));
        this.clearButton.addActionListener(this);
        this.clearButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(this.clearButton);
        this.add(component, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 19, 0, new Insets(4, 0, 0, 0), 0, 0));
        if (bl2) {
            this.addButton.setVisible(false);
            this.delButton.setVisible(false);
            this.clearButton.setVisible(false);
        }
        this.selectedTimes = new TreeSet();
        this.selectedHours = new TreeSet();
        this.selectedMinutes = new TreeSet();
        this.selectedSeconds = new TreeSet();
        this.actionListeners = new EventListenerList();
        this.reset();
    }

    public TimePanel(boolean bl, boolean bl2, boolean bl3, Time[] timeArray) {
        this(null, bl, bl2, bl3, timeArray);
    }

    private Component createTimeComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(1970, 1, 1, 12, 0, 0);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.hourIncluded ? "HH" + this.timeSep + "mm" + this.timeSep + "ss" : "mm" + this.timeSep + "ss");
        this.timeEditor = new DateEditor(calendar.getTime(), calendar, (DateFormat)simpleDateFormat);
        this.timeEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TimePanel.this.timeChanged();
            }
        });
        int n = -1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = ++n;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.createTimeLabel(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.timeEditor, gridBagConstraints);
        return jPanel;
    }

    private JLabel createTimeLabel() {
        String string = (this.hourIncluded ? SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_HOURS_SHORT") + this.timeSep : "") + SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_MINUTES_SHORT") + this.timeSep + SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_SECONDS_SHORT");
        return new JLabel(string);
    }

    private boolean isValidTime(Time time, boolean bl) {
        return time != null && time.isValid(this.hourIncluded, bl);
    }

    private boolean isStorableTime(Time time, Action action) {
        switch (action) {
            case Add: {
                return this.isValidTime(time, this.emulate);
            }
            case Del: {
                return this.isValidTime(time, true);
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean addSelection(Time time) {
        boolean bl = false;
        if (this.isStorableTime(time, Action.Add)) {
            if (this.emulate) {
                if (time.getHour() != null) {
                    bl |= this.selectedHours.add(time.getHour());
                }
                if (time.getMinute() != null) {
                    bl |= this.selectedMinutes.add(time.getMinute());
                }
                if (time.getSecond() != null) {
                    bl |= this.selectedSeconds.add(time.getSecond());
                }
            } else {
                bl = this.selectedTimes.add(time);
            }
        }
        return bl;
    }

    private boolean removeSelection(Time time) {
        boolean bl = false;
        if (this.isStorableTime(time, Action.Del)) {
            if (this.emulate) {
                if (time.getHour() != null) {
                    bl |= this.selectedHours.remove(time.getHour());
                }
                if (time.getMinute() != null) {
                    bl |= this.selectedMinutes.remove(time.getMinute());
                }
                if (time.getSecond() != null) {
                    bl |= this.selectedSeconds.remove(time.getSecond());
                }
            } else {
                bl = this.selectedTimes.remove(time);
            }
        }
        return bl;
    }

    private boolean clearSelections() {
        if (this.emulate) {
            return this.clearSelections(Time.ComponentType.SECOND) | this.clearSelections(Time.ComponentType.MINUTE) | this.clearSelections(Time.ComponentType.HOUR);
        }
        int n = this.selectedTimes.size();
        this.selectedTimes.clear();
        return n > 0;
    }

    private boolean clearSelections(Time.ComponentType componentType) {
        int n = 0;
        switch (componentType) {
            case HOUR: {
                n = this.selectedHours.size();
                this.selectedHours.clear();
                break;
            }
            case MINUTE: {
                n = this.selectedMinutes.size();
                this.selectedMinutes.clear();
                break;
            }
            case SECOND: {
                n = this.selectedSeconds.size();
                this.selectedSeconds.clear();
            }
        }
        return n > 0;
    }

    private boolean isSelected(Time time, Action action) {
        if (this.isStorableTime(time, action)) {
            switch (action) {
                case Add: {
                    if (this.emulate) {
                        return !(time.getHour() != null && !this.selectedHours.contains(time.getHour()) || time.getMinute() != null && !this.selectedMinutes.contains(time.getMinute()) || time.getSecond() != null && !this.selectedSeconds.contains(time.getSecond()));
                    }
                    return this.selectedTimes.contains(time);
                }
                case Del: {
                    if (this.emulate) {
                        return !(time.getHour() != null && this.selectedHours.contains(time.getHour()) || time.getMinute() != null && this.selectedMinutes.contains(time.getMinute()) || time.getSecond() != null && this.selectedSeconds.contains(time.getSecond()));
                    }
                    return !this.selectedTimes.contains(time);
                }
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    private boolean isTimeActionValid(Time time, Action action) {
        try {
            return !this.isSelected(time, action);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void reset() {
        this.clearSelections();
        Time time = null;
        if (this.initVal != null) {
            for (Time time2 : this.initVal) {
                boolean bl = this.addSelection(time2);
                if (!bl || time != null) continue;
                time = time2;
            }
            this.initVal = null;
        }
        if (time == null) {
            time = this.defaultTime;
        }
        this.paintTimeSelected(time, true);
        this.enableButtons();
    }

    protected void reset(Time.ComponentType componentType) {
        this.clearSelections(componentType);
        Time time = this.resetTimeComponent(this.getTime(), componentType);
        this.paintTimeSelected(time, true);
        this.enableButtons();
    }

    protected Time resetTimeComponent(Time time, Time.ComponentType componentType) {
        return new Time(componentType == Time.ComponentType.SECOND ? this.defaultTime.getSecond() : time.getSecond(), componentType == Time.ComponentType.MINUTE ? this.defaultTime.getMinute() : time.getMinute(), componentType == Time.ComponentType.HOUR ? this.defaultTime.getHour() : time.getHour());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Add") || string.equals("Del")) {
            Time time = this.getClauseElement();
            boolean bl = false;
            bl = string.equals("Add") ? this.addSelection(time) : this.removeSelection(time);
            if (bl) {
                this.fireAction(new ActionEvent(this, 1001, "BYTIME"));
            }
        } else if (string.equals("Clear")) {
            this.reset();
            this.fireAction(new ActionEvent(this, 1001, "BYTIME"));
        }
        this.enableButtons();
    }

    private void timeChanged() {
        if (this.singleSelection) {
            this.fireAction(new ActionEvent(this, 1001, "BYTIME"));
            return;
        }
        this.enableButtons();
    }

    private void enableButtons() {
        Time time = this.getClauseElement();
        this.delButton.setEnabled(this.isTimeActionValid(time, Action.Del));
        this.addButton.setEnabled(this.isTimeActionValid(time, Action.Add));
    }

    protected void paintTimeSelected(Time time, boolean bl) {
        if (bl) {
            Integer n = time.getHour();
            Integer n2 = time.getMinute();
            Integer n3 = time.getSecond();
            Calendar calendar = this.timeEditor.getCalendar();
            if (this.hourIncluded && n != null) {
                calendar.set(11, n);
            }
            if (n2 != null) {
                calendar.set(12, n2);
            }
            if (n3 != null) {
                calendar.set(13, n3);
            }
            this.timeEditor.setCalendar(calendar);
        }
    }

    protected boolean setSelection(Time time) {
        return this.setSelection(time, (Boolean)true, false);
    }

    protected boolean setSelection(Time time, Boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (time != null) {
            if (bl == null) {
                bl = this.isSelected(time, Action.Add);
            } else {
                bl3 = bl != false ? this.addSelection(time) : this.removeSelection(time);
            }
            if (bl2) {
                this.paintTimeSelected(time, bl);
            }
        }
        return bl3;
    }

    protected boolean setSelection(Time[] timeArray) {
        return this.setSelection(timeArray, (Boolean)true, false);
    }

    protected boolean setSelection(Time[] timeArray, Boolean bl, boolean bl2) {
        Boolean bl3 = null;
        boolean bl4 = bl2;
        if (timeArray != null) {
            for (Time time : timeArray) {
                boolean bl5 = this.setSelection(time, bl, bl4);
                if (bl5) {
                    bl4 = false;
                }
                if (bl3 != null && !bl3.booleanValue()) continue;
                bl3 = bl5;
            }
        }
        return bl3 == null ? false : bl3;
    }

    protected void changeSelection(Time time, Boolean bl) {
        this.setSelection(time, bl, true);
    }

    protected void resetSelections(Time[] timeArray, Time.ComponentType componentType) {
        this.reset(componentType);
        for (int i = 0; i < timeArray.length; ++i) {
            this.changeSelection(timeArray[i], true);
        }
    }

    protected void resetSelections(Time[] timeArray) {
        this.reset();
        for (int i = 0; i < timeArray.length; ++i) {
            this.changeSelection(timeArray[i], true);
        }
    }

    protected void resetSelections() {
        this.reset();
    }

    protected Time getClauseElement() {
        return this.getTime();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(ActionListener.class, actionListener);
    }

    protected void fireAction(ActionEvent actionEvent) {
        Object[] objectArray = this.actionListeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    protected Time getTime() {
        Calendar calendar = this.timeEditor.getCalendar();
        return this.getTime(this.hourIncluded ? Integer.valueOf(calendar.get(11)) : null, calendar.get(12), calendar.get(13));
    }

    protected Time getTime(Integer n, Integer n2, Integer n3) {
        Integer n4 = n != null ? n : null;
        Integer n5 = n2 != null ? n2 : 0;
        Integer n6 = n3 != null ? n3 : 0;
        return new Time(n6, n5, n4);
    }

    protected void applyLocale(Locale locale) {
        DateFormat dateFormat = DateFormat.getTimeInstance(2, locale);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.timeSep = dateFormat.format(new Date(0L)).indexOf(58) < 0 ? "." : ":";
    }

    private static enum Action {
        Add,
        Del,
        Clear;

    }
}

