/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.chain;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.NameBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.ActionDialogBase;
import oracle.dbtools.scheduler.panels.common.ObjectNameValidator;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IdentifierImpl;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;

public class ChainCreateAction
extends ActionDialogBase {
    public static final String OWNER = "owner";
    public static final String NAME = "name";
    public static final String COMMENTS = "comments";
    public static final String ENABLED = "enabled";
    boolean showOwner = false;
    String owner = null;
    String chain_name = null;
    String comments = null;
    boolean enabled = true;
    ActionControl ownerCtl = null;
    NameBoxActionControl nameCtl = null;
    ActionControl commentsCtl = null;
    ActionControl enabledCtl = null;

    public ChainCreateAction() {
        this.setScriptEditingEnabled(false);
    }

    protected String getTitle() {
        return SchedulerArb.getString("CHAINCREATEDIALOG_TITLE");
    }

    protected String getQuery(Connection connection, String string) {
        String string2 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        return dBMSSchedulerCodeGenerator.generate(string2, string, null);
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        Operation operation;
        block18: {
            String string;
            block19: {
                String string2;
                operation = this.getOperation();
                try {
                    string2 = this.getObjectName();
                }
                catch (Exception exception) {
                    string2 = "null";
                }
                try {
                    string = this.getDBObjectSchemaName();
                    if (string == null) {
                        string = this.getDBObject().getSchemaName();
                    }
                }
                catch (Exception exception) {
                    string = "null";
                }
                if (operation == Operation.CREATE_NEW) break block19;
                if (!Connections.getInstance().lock(connection)) break block18;
                object = null;
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OBJECT_NAME", string2);
                    hashMap.put("OBJECT_OWNER", string);
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    object = dBUtil.executeOracleQuery(this.getQuery(connection, "CHAIN_DATA"), hashMap);
                    if (object != null && object.next()) {
                        this.owner = object.getString("OWNER");
                        this.chain_name = object.getString("CHAIN_NAME");
                        this.comments = object.getString("COMMENTS");
                        String string3 = object.getString("ENABLED").toLowerCase();
                        this.enabled = string3 == null ? false : Boolean.valueOf(string3);
                    }
                    DBUtil.closeResultSet((ResultSet)object);
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    break block18;
                }
                finally {
                    DBUtil.closeResultSet(object);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
                break block18;
            }
            this.owner = string;
        }
        switch (operation) {
            case UPDATE: {
                this.ownerCtl = new TextBoxActionControl(OWNER, SchedulerArb.getString("CHAINPANEL_SCHEMA_LABEL"), this.owner);
                this.ownerCtl.setEditable(false);
                object = ObjectNameValidator.displayName(this.chain_name);
                this.nameCtl = new NameBoxActionControl(NAME, SchedulerArb.getString("CHAINPANEL_NAME_LABEL"), (String)object);
                this.nameCtl.setEditable(false);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("CHAINPANEL_DESC_LABEL"), this.comments);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("CHAINPANEL_ENABLED_LABEL"), this.enabled, false);
                break;
            }
            case CREATE_LIKE: {
                this.ownerCtl = new SqlComboBoxActionControl(OWNER, SchedulerArb.getString("CHAINPANEL_SCHEMA_LABEL"), connection, this.getQuery(connection, "SCHEMAS_LIST"), null, this.owner);
                this.nameCtl = new NameBoxActionControl(NAME, SchedulerArb.getString("CHAINPANEL_NAME_LABEL"), "");
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("CHAINPANEL_DESC_LABEL"), this.comments);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("CHAINPANEL_ENABLED_LABEL"), this.enabled, false);
                break;
            }
            case CREATE_NEW: {
                this.ownerCtl = new SqlComboBoxActionControl(OWNER, SchedulerArb.getString("CHAINPANEL_SCHEMA_LABEL"), connection, this.getQuery(connection, "SCHEMAS_LIST"), null, this.owner);
                this.nameCtl = new NameBoxActionControl(NAME, SchedulerArb.getString("CHAINPANEL_NAME_LABEL"), this.chain_name);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("CHAINPANEL_DESC_LABEL"), this.comments);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("CHAINPANEL_ENABLED_LABEL"), this.enabled, false);
            }
        }
        object = new ArrayList<Object>();
        if (this.showOwner) {
            ((ArrayList)object).add(this.ownerCtl);
        } else {
            this.ownerCtl = new TextBoxActionControl(OWNER, SchedulerArb.getString("CHAINPANEL_SCHEMA_LABEL"), this.owner);
        }
        ((ArrayList)object).add(this.nameCtl);
        ((ArrayList)object).add(this.enabledCtl);
        ((ArrayList)object).add(this.commentsCtl);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        Object object;
        Operation operation = this.getOperation();
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = this.ownerCtl.getValue().get();
        String string3 = values.get(NAME);
        string3 = ObjectNameValidator.validateName(string3);
        String string4 = values.get(COMMENTS);
        String string5 = values.get(ENABLED);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string2 != null) {
            string2 = string2.trim();
            object = new IdentifierImpl(string2);
            string2 = ((IdentifierImpl)object).getId();
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string3 != null) {
            string3 = string3.trim();
            object = new IdentifierImpl(string3);
            string3 = ((IdentifierImpl)object).getId();
        }
        object = new TreeMap();
        object.put(OWNER, string2);
        object.put(NAME, string3);
        object.put(COMMENTS, string4);
        object.put(ENABLED, string5 == null ? false : Boolean.valueOf(string5));
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        treeMap.put(OWNER, ChainCreateAction.equals(string2, this.owner) == false);
        treeMap.put(NAME, ChainCreateAction.equals(string3, this.chain_name) == false);
        treeMap.put(COMMENTS, ChainCreateAction.equals(string4, this.comments) == false);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", object);
        treeMap2.put("changes", treeMap);
        String string6 = null;
        switch (operation) {
            case UPDATE: {
                string6 = dBMSSchedulerCodeGenerator.generate(string, "CHAIN_UPDATE", treeMap2);
                break;
            }
            case CREATE_LIKE: {
                string6 = dBMSSchedulerCodeGenerator.generate(string, "CHAIN_CREATE", treeMap2);
                break;
            }
            case CREATE_NEW: {
                string6 = dBMSSchedulerCodeGenerator.generate(string, "CHAIN_CREATE", treeMap2);
            }
        }
        return string6;
    }

    private static Boolean equals(Object object, Object object2) {
        if (object == null || object2 == null) {
            return Boolean.FALSE;
        }
        return object.equals(object2);
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    @Override
    protected String getObjectType() {
        return "SCHCHAIN";
    }

    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_newChainDialog_html");
    }

    protected boolean isCloseOnError() {
        return false;
    }

    public boolean isEnabled(Context context) {
        Version version = new Version("10.2");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }

    private class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return ChainCreateAction.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = dBMSSchedulerCodeGenerator.generate(ChainCreateAction.this.getDBObject().getDBVersion(), "CHAIN_LIST", null);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            Connection connection = ChainCreateAction.this.getDBObject().getConnection();
            DBUtil.getConnectionResolver().lock(connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString("OWNER") + "." + resultSet.getString("CHAIN_NAME");
                        vector.add(string);
                    }
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
            }
            finally {
                DBUtil.getConnectionResolver().unlock(connection);
            }
            return vector;
        }
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        UPDATE;

    }
}

