/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.schedule;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.NameBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.ActionDialogBase;
import oracle.dbtools.scheduler.panels.common.ObjectNameValidator;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenActionControl;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenModel;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.jdbc.OracleResultSet;

public class SchedulerCreateAction
extends ActionDialogBase {
    private static final String SCHEDULE_NAME = "schedule_name";
    private static final String COMMENTS = "comments";
    private static final String SCHEDULE_WHEN = "schedule_when";
    private String scheduleOwner;
    private String scheduleName;
    private String comments;
    private String oldComments;
    private ScheduleWhenModel whenModel;
    private ScheduleWhenActionControl whenCtrl;

    protected static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public SchedulerCreateAction() {
        this.setScriptEditingEnabled(false);
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        DBUtil dBUtil;
        NameBoxActionControl nameBoxActionControl;
        Object object;
        Operation operation;
        block13: {
            block14: {
                block12: {
                    String string;
                    String string2;
                    this.whenModel = new ScheduleWhenModel();
                    operation = this.getOperation();
                    try {
                        string2 = this.getObjectName();
                    }
                    catch (Exception exception) {
                        string2 = "null";
                    }
                    try {
                        string = this.getDBObjectSchemaName();
                    }
                    catch (Exception exception) {
                        string = "null";
                    }
                    if (operation == Operation.CREATE_NEW) break block14;
                    if (!Connections.getInstance().lock(connection)) break block13;
                    object = null;
                    try {
                        nameBoxActionControl = new HashMap();
                        nameBoxActionControl.put("OBJECT_NAME", string2);
                        nameBoxActionControl.put("OBJECT_OWNER", string);
                        dBUtil = DBUtil.getInstance((Connection)connection);
                        dBUtil.setRaiseError(true);
                        object = dBUtil.executeOracleQuery(this.getQuery(connection, "getScheduleData"), (Map)nameBoxActionControl);
                        if (object == null || !object.next()) break block12;
                        if (operation == Operation.EDIT) {
                            this.scheduleName = object.getString("SCHEDULE_NAME");
                        }
                        this.comments = this.oldComments = object.getString("COMMENTS");
                        this.whenModel.initPropertiesFromRS((OracleResultSet)object, connection);
                    }
                    catch (Exception exception) {
                        try {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                        catch (Throwable throwable) {
                            DBUtil.closeResultSet(object);
                            Connections.getInstance().unlock(connection);
                            throw throwable;
                        }
                        DBUtil.closeResultSet((ResultSet)object);
                        Connections.getInstance().unlock(connection);
                        break block13;
                    }
                }
                DBUtil.closeResultSet((ResultSet)object);
                Connections.getInstance().unlock(connection);
                break block13;
            }
            this.whenModel.initProperty(ScheduleWhenModel.Property.EVENT_TYPE, (Object)ScheduleWhenModel.EventType.REPEATING);
        }
        this.whenModel.doInitialize();
        try {
            this.scheduleOwner = this.getDBObjectSchemaName();
            if (this.scheduleOwner == null) {
                this.scheduleOwner = this.getDBObject().getSchemaName();
            }
        }
        catch (Exception exception) {
            this.scheduleOwner = "null";
        }
        object = ObjectNameValidator.displayName(this.scheduleName);
        nameBoxActionControl = new NameBoxActionControl(SCHEDULE_NAME, SchedulerArb.getString("SCHEDULEUPDATE_NAME_LABEL"), (String)object);
        dBUtil = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("SCHEDULEUPDATE_COMMENTS_LABEL"), this.comments);
        this.whenCtrl = new ScheduleWhenActionControl(SCHEDULE_WHEN, null, CardLayoutPanel.Type.TITLE_BORDER, SchedulerArb.getString("SCHEDULEWHEN_CARD_TITLE_BORDER"), ScheduleWhenActionControl.FCOTarget.SCHEDULE, connection);
        this.whenCtrl.setModel(this.whenModel);
        nameBoxActionControl.setEditable(operation != Operation.EDIT);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)nameBoxActionControl);
        arrayList.add((ActionControl)dBUtil);
        arrayList.add(this.whenCtrl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        Operation operation = this.getOperation();
        ScheduleWhenModel.EventType eventType = this.whenModel.getEventType();
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = values.get(SCHEDULE_NAME);
        string2 = ObjectNameValidator.validateName(string2);
        String string3 = values.get(COMMENTS);
        String string4 = values.get(SCHEDULE_WHEN, ScheduleWhenModel.Property.REPEAT_INTERVAL.getValueName());
        String string5 = values.get(SCHEDULE_WHEN, ScheduleWhenModel.Property.START_DATE.getValueName());
        String string6 = values.get(SCHEDULE_WHEN, ScheduleWhenModel.Property.END_DATE.getValueName());
        String string7 = values.get(SCHEDULE_WHEN, ScheduleWhenModel.Property.EVENT_CONDITION.getValueName());
        String string8 = values.get(SCHEDULE_WHEN, ScheduleWhenModel.QUEUE_SPEC);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("owner", this.wrapQuotes(this.scheduleOwner));
        treeMap.put("name", string2);
        treeMap.put("event_condition", this.wrapQuotes(string7));
        treeMap.put("end_date", string6);
        treeMap.put("start_date", string5);
        treeMap.put("queue_spec", string8);
        treeMap.put(COMMENTS, this.wrapQuotes(string3));
        treeMap.put("repeat_interval", this.wrapQuotes(string4));
        Map<String, Boolean> map = this.whenModel.getChanges();
        Map<String, Boolean> map2 = this.whenModel.getIsNull();
        map.put(COMMENTS, !SchedulerCreateAction.areEqual(this.oldComments, string3));
        if (!SchedulerCreateAction.areEqual(this.oldComments, string3)) {
            map.put("has_changes", true);
        }
        map2.put(COMMENTS, string3 == null);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("schema", this.scheduleOwner);
        treeMap2.put("model", treeMap);
        treeMap2.put("changes", map);
        treeMap2.put("isnull", map2);
        String string9 = null;
        string9 = operation == Operation.EDIT ? dBMSSchedulerCodeGenerator.generate(string, "SCHEDULE_UPDATE", treeMap2) : (eventType != null && eventType.getScheduleType() == ScheduleWhenModel.ScheduleType.EVENT ? dBMSSchedulerCodeGenerator.generate(string, "CREATE_EVENT_SCHEDULE", treeMap2) : dBMSSchedulerCodeGenerator.generate(string, "CREATE_SCHEDULE", treeMap2));
        return string9;
    }

    protected String getTitle() {
        Operation operation = this.getOperation();
        if (operation == Operation.EDIT) {
            return SchedulerArb.getString("SCHEDULEUPDATEDIALOG_TITLE");
        }
        return SchedulerArb.getString("SCHEDULECREATEDIALOG_TITLE");
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    @Override
    protected String getObjectType() {
        return "SCHSCHEDULE";
    }

    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_createScheduleDialog_html");
    }

    protected boolean isCloseOnError() {
        return false;
    }

    public boolean isEnabled(Context context) {
        Version version = new Version("10");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }

    private String wrapQuotes(String string) {
        return string != null ? string.replaceAll("'", "''") : string;
    }

    private class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return SchedulerCreateAction.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = dBMSSchedulerCodeGenerator.generate(SchedulerCreateAction.this.getDBObject().getDBVersion(), "SCHEDULE_LIST", null);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            Connection connection = SchedulerCreateAction.this.getDBObject().getConnection();
            DBUtil.getConnectionResolver().lock(connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString("OWNER") + "." + resultSet.getString("SCHEDULE_NAME");
                        vector.add(string);
                    }
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
            }
            finally {
                DBUtil.getConnectionResolver().unlock(connection);
            }
            return vector;
        }
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        EDIT;

    }
}

