/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.DeferredElementVisitorHook;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Version;
import oracle.ide.extension.MetaClassList;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLKey;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.library.AbstractLibraryHook;
import oracle.jdeveloper.library.AddinJDK;
import oracle.jdeveloper.library.AddinLibrary;
import oracle.jdeveloper.library.DerivedLibrary;
import oracle.jdeveloper.library.DynamicLibraryProvider;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdevimpl.library.DependentLibraryInfo;
import oracle.jdevimpl.library.LibraryProxy;

public final class LibrariesHook
extends AbstractLibraryHook {
    public static final ElementName ELEMENT = LibrariesHook.e("libraries");
    private static LibrariesHook INSTANCE;
    private static String LIBRARY;
    private static String DEPENDENT_LIBRARY;
    private static String LIBRARYNAME;
    private static String LIBRARYDEPLOYED;
    private static String LIBRARY_FORCES_EXT_INITIALIZATION;
    private static String LIBRARY_HIDDEN;
    private static String LIBRARY_FRAGMENT;
    private static final boolean VERIFY_DOC_PATHS;
    public static final String ATTR_PATH_ENTRY = "pathManifestEntry";
    public static final String ATTR_LIBRARY_ENTRY = "libraryManifestEntry";
    public static final String MANIFEST_ATTR = "manifest";
    private static final String NS = "http://xmlns.oracle.com/jdeveloper/1013/jdev-libraries";
    private final ElementVisitor _libraryHandler = new LibraryHandler();
    private final ElementVisitor _aliasHandler = new AliasHandler();
    private final ElementVisitor _dynamicLibraryHandler = new DynamicLibraryHandler();
    private final ElementVisitor _derivedLibraryHandler = new DerivedLibraryHandler();
    private final ElementVisitor _libraryListHandler = new LibraryListHandler();
    private final ElementVisitor _jdkHandler = new JdkHandler();
    private final ElementVisitor _overrideHandler = new OverrideHandler();
    private final ElementVisitor _fragmentHandler = new FragmentHandler();
    private final Map<String, String> _aliases = Collections.synchronizedMap(new HashMap());
    private final Map<String, AddinLibrary> _libraries = Collections.synchronizedMap(new HashMap());
    private final Map<String, AddinJDK> _jdks = Collections.synchronizedMap(new HashMap());
    private final Queue<JdkInfo> _jdkInfos = new ConcurrentLinkedQueue<JdkInfo>();
    private final Map<String, DependentLibraryInfo> _manifestLibraries = Collections.synchronizedMap(new HashMap());
    private final List<DynamicLibraryProviderInfo> _dynamicLibraryProviders = new ArrayList<DynamicLibraryProviderInfo>();
    private final Map<String, MetaClass<DerivedLibrary>> _derivedLibraries = Collections.synchronizedMap(new HashMap());
    private final MetaClassList<LibraryList> _libraryLists = MetaClassList.get(LibraryList.class);
    private final List<OverrideInfo> _overrides = new CopyOnWriteArrayList<OverrideInfo>();

    public static synchronized LibrariesHook getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LibrariesHook();
        }
        return INSTANCE;
    }

    private static Logger getLogger() {
        return Logger.getLogger(LibrariesHook.class.getName());
    }

    private static boolean isSanityBuild() {
        return Version.DEBUG_BUILD != 0 && Version.BUILD_LABEL.endsWith(".S");
    }

    private LibrariesHook() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        DeferredElementVisitorHook hookHandler = (DeferredElementVisitorHook)extensionRegistry.getHook(ELEMENT);
        hookHandler.attachElementVisitor((ElementVisitor)this);
    }

    private static final ElementName e(String name) {
        return new ElementName(NS, name);
    }

    public String resolveAlias(String name) {
        String realName = this._aliases.get(name);
        return realName == null ? name : realName;
    }

    public AddinLibrary getLibrary(String id) {
        return this._libraries.get(id);
    }

    public AddinJDK getJDK(String id) {
        this.processJdkInfoQueue();
        return this._jdks.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AddinLibrary> getLibraries() {
        ArrayList<AddinLibrary> libraries;
        Map<String, AddinLibrary> map = this._libraries;
        synchronized (map) {
            libraries = new ArrayList<AddinLibrary>(this._libraries.values());
        }
        return Collections.unmodifiableCollection(libraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AddinJDK> getJDKs() {
        ArrayList<AddinJDK> jdks;
        this.processJdkInfoQueue();
        Map<String, AddinJDK> map = this._jdks;
        synchronized (map) {
            jdks = new ArrayList<AddinJDK>(this._jdks.values());
        }
        return Collections.unmodifiableCollection(jdks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DependentLibraryInfo> getDependentManifestLibraries() {
        HashMap<String, DependentLibraryInfo> libraries;
        Map<String, DependentLibraryInfo> map = this._manifestLibraries;
        synchronized (map) {
            libraries = new HashMap<String, DependentLibraryInfo>(this._manifestLibraries);
        }
        return Collections.unmodifiableMap(libraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DynamicLibraryProvider> getDynamicLibraryProviders(String[] technologyKeys) {
        ArrayList<DynamicLibraryProvider> providers = new ArrayList<DynamicLibraryProvider>();
        List<DynamicLibraryProviderInfo> list = this._dynamicLibraryProviders;
        synchronized (list) {
            for (DynamicLibraryProviderInfo info : this._dynamicLibraryProviders) {
                if (!info.hasTechnology(technologyKeys)) continue;
                providers.add(info.getInstance());
            }
            return Collections.unmodifiableList(providers);
        }
    }

    public List<LibraryList> getExtensionLibraryLists() {
        return this._libraryLists.getInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<? extends DerivedLibrary> getDerivedLibraryClass(Class sourceClass) {
        Map<String, MetaClass<DerivedLibrary>> map = this._derivedLibraries;
        synchronized (map) {
            for (Class current = sourceClass; current != null; current = current.getSuperclass()) {
                MetaClass<DerivedLibrary> libraryClass = this._derivedLibraries.get(current.getName());
                if (libraryClass == null) continue;
                try {
                    return libraryClass.toClass();
                }
                catch (ClassNotFoundException e) {
                    LibrariesHook.getLogger().log(Level.SEVERE, "Unable to find derived library class " + libraryClass.getClassName(), e);
                }
            }
        }
        return null;
    }

    public JLibrary getLibraryOverride(Workspace workspace, Project project, JLibrary original) {
        if (!this._overrides.isEmpty()) {
            Context context = new Context();
            context.setWorkspace(workspace);
            context.setProject(project);
            JLibrary current = original;
            for (OverrideInfo info : this._overrides) {
                String ruleId = info.getRuleId();
                if (ruleId != null && !RuleEngine.getInstance().evaluateRule(ruleId, context)) continue;
                current = LibraryProxy.get(workspace, project, current, info.getOverrideInstance());
            }
            return current;
        }
        return original;
    }

    public void addLibraryOverride(Class overrideClass) {
        this._overrides.add(new OverrideInfo(new MetaClass(overrideClass.getClassLoader(), overrideClass.getName()), "always-enabled"));
    }

    public void removeLibraryOverride(Class overrideClass) {
        for (OverrideInfo info : this._overrides) {
            if (!info.overrideClass.getClassName().equals(overrideClass.getName()) || !info.overrideClass.getClassLoader().equals(overrideClass.getClassLoader())) continue;
            this._overrides.remove(info);
            break;
        }
    }

    private void processJdkInfoQueue() {
        JDK defaultJdk;
        JdkInfo jdkInfo = this._jdkInfos.poll();
        if (jdkInfo != null && (defaultJdk = JLibraryManager.getDefaultJDK()) != null) {
            while (jdkInfo != null) {
                this._jdks.put(jdkInfo.getName(), this.getJdk(jdkInfo, defaultJdk));
                jdkInfo = this._jdkInfos.poll();
            }
        }
    }

    private AddinJDK getJdk(JdkInfo jdkInfo, JDK defaultJdk) {
        String name = jdkInfo.getName();
        String version = jdkInfo.getVersion();
        return new AddinJDK(name, jdkInfo._classPath.size() > 0 ? jdkInfo._classPath : defaultJdk.getClassPath(), jdkInfo._srcPath.size() > 0 ? jdkInfo._srcPath : defaultJdk.getSourcePath(), jdkInfo._docPath.size() > 0 ? jdkInfo._docPath : defaultJdk.getDocPath(), defaultJdk.getJavaExecutable(), version == null ? defaultJdk.getJavaVersion() : new VersionNumber(version), defaultJdk.getSDKBinDir());
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(LibrariesHook.e("library"), this._libraryHandler);
        context.registerChildVisitor(LibrariesHook.e("alias"), this._aliasHandler);
        context.registerChildVisitor(LibrariesHook.e("dynamic-library"), this._dynamicLibraryHandler);
        context.registerChildVisitor(LibrariesHook.e("derived-library"), this._derivedLibraryHandler);
        context.registerChildVisitor(LibrariesHook.e("library-list"), this._libraryListHandler);
        context.registerChildVisitor(LibrariesHook.e("jdk"), this._jdkHandler);
        context.registerChildVisitor(LibrariesHook.e("override"), this._overrideHandler);
        context.registerChildVisitor(LibrariesHook.e("fragment"), this._fragmentHandler);
    }

    static {
        LIBRARY = "Library";
        DEPENDENT_LIBRARY = "DependentLibrary";
        LIBRARYNAME = "LibraryName";
        LIBRARYDEPLOYED = "LibraryDeployed";
        LIBRARY_FORCES_EXT_INITIALIZATION = "LibraryForcesExtInitialization";
        LIBRARY_HIDDEN = "LibraryHidden";
        LIBRARY_FRAGMENT = "LibraryFragment";
        VERIFY_DOC_PATHS = !LibrariesHook.isSanityBuild() || Boolean.getBoolean("ide.library.verify.doc.paths");
    }

    private static final class OverrideInfo {
        private final MetaClass<?> overrideClass;
        private final String ruleId;
        private Object instance;

        public OverrideInfo(MetaClass<?> overrideClass, String ruleId) {
            this.overrideClass = overrideClass;
            this.ruleId = ruleId;
        }

        public String getRuleId() {
            return this.ruleId;
        }

        public synchronized Object getOverrideInstance() {
            if (this.instance == null) {
                try {
                    this.instance = this.overrideClass.newInstance();
                }
                catch (InstantiationException e) {
                    LibrariesHook.getLogger().log(Level.SEVERE, "Unable to instantiate library override class " + this.overrideClass.getClassName(), e);
                }
                catch (IllegalAccessException e) {
                    LibrariesHook.getLogger().log(Level.SEVERE, "Unable to instantiate library override class " + this.overrideClass.getClassName(), e);
                }
                catch (ClassNotFoundException e) {
                    LibrariesHook.getLogger().log(Level.SEVERE, "Unable to find library override class " + this.overrideClass.getClassName(), e);
                }
            }
            return this.instance;
        }
    }

    private static final class DynamicLibraryProviderInfo {
        private final MetaClass<DynamicLibraryProvider> providerClass;
        private final Set<String> technologyKeys;
        private DynamicLibraryProvider instance;

        public DynamicLibraryProviderInfo(MetaClass<DynamicLibraryProvider> providerClass, String[] technologyKeys) {
            this.providerClass = providerClass;
            this.technologyKeys = technologyKeys == null ? null : new HashSet<String>(Arrays.asList(technologyKeys));
        }

        public synchronized DynamicLibraryProvider getInstance() {
            if (this.instance == null) {
                try {
                    this.instance = (DynamicLibraryProvider)this.providerClass.newInstance();
                }
                catch (InstantiationException e) {
                    LibrariesHook.getLogger().log(Level.SEVERE, "Unable to instantiate dynamic library provider class " + this.providerClass.getClassName(), e);
                }
                catch (IllegalAccessException e) {
                    LibrariesHook.getLogger().log(Level.SEVERE, "Unable to instantiate dynamic library provider class " + this.providerClass.getClassName(), e);
                }
                catch (ClassNotFoundException e) {
                    LibrariesHook.getLogger().log(Level.SEVERE, "Unable to find dynamic library provider class " + this.providerClass.getClassName(), e);
                }
            }
            return this.instance;
        }

        public boolean hasTechnology(String[] technologyKeys) {
            if (this.technologyKeys == null) {
                return true;
            }
            for (String key : technologyKeys) {
                if (!this.technologyKeys.contains(key)) continue;
                return true;
            }
            return false;
        }
    }

    private class OverrideHandler
    extends ElementVisitor {
        private OverrideHandler() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            String ruleId = context.getAttributeValue("rule");
            if (ruleId != null) {
                if (RuleEngine.getInstance().validateRuleReference(ruleId, (ElementContext)context)) {
                    LibrariesHook.this._overrides.add(new OverrideInfo(new MetaClass(this.getMetaClassLoader((ElementContext)context), className), ruleId));
                }
            } else {
                this.log((ElementContext)context, Level.SEVERE, "Missing mandatory rule for library override");
            }
        }
    }

    private class LibraryListHandler
    extends ElementVisitor {
        private LibraryListHandler() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className != null) {
                className = className.trim();
            }
            if (className == null || className.isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "Missing class for library list");
            } else {
                LibrariesHook.this._libraryLists.add(new MetaClass(this.getMetaClassLoader((ElementContext)context), className));
            }
        }
    }

    private class DerivedLibraryHandler
    extends ElementVisitor {
        private DerivedLibraryHandler() {
        }

        public void start(ElementStartContext context) {
            String libraryClassName;
            String sourceClassName = context.getAttributeValue("source-class");
            if (sourceClassName != null) {
                sourceClassName = sourceClassName.trim();
            }
            if ((libraryClassName = context.getAttributeValue("library-class")) != null) {
                libraryClassName = libraryClassName.trim();
            }
            if (sourceClassName == null || sourceClassName.isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "Missing source-class for derived library");
            } else if (libraryClassName == null || libraryClassName.isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "Missing library-class for derived library");
            } else {
                ClassLoader classLoader = this.getMetaClassLoader((ElementContext)context);
                MetaClass libraryClass = new MetaClass(classLoader, libraryClassName);
                LibrariesHook.this._derivedLibraries.put(sourceClassName, libraryClass);
            }
        }
    }

    private class DynamicLibraryHandler
    extends ElementVisitor {
        private DynamicLibraryHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(ElementStartContext context) {
            String providerClassName = context.getAttributeValue("provider-class");
            if (providerClassName != null) {
                providerClassName = providerClassName.trim();
            }
            if (providerClassName == null || providerClassName.isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "Missing provider-class for dynamic library");
            } else {
                String technologyKeys = context.getAttributeValue("technology-keys");
                if (technologyKeys != null) {
                    technologyKeys = technologyKeys.trim();
                }
                if (technologyKeys == null || technologyKeys.isEmpty()) {
                    this.log((ElementContext)context, Level.SEVERE, "Missing technology-keys for dynamic library");
                } else {
                    String[] keys = technologyKeys.split(",");
                    MetaClass providerClass = new MetaClass(this.getMetaClassLoader((ElementContext)context), providerClassName);
                    List list = LibrariesHook.this._dynamicLibraryProviders;
                    synchronized (list) {
                        LibrariesHook.this._dynamicLibraryProviders.add(new DynamicLibraryProviderInfo((MetaClass<DynamicLibraryProvider>)providerClass, keys));
                    }
                }
            }
        }
    }

    private final class JdkInfo {
        private final String _name;
        private final String _version;
        private final URLPath _classPath = new URLPath();
        private final URLPath _srcPath = new URLPath();
        private final URLPath _docPath = new URLPath();

        JdkInfo(String name, String version) {
            this._name = name;
            this._version = version;
        }

        public String getName() {
            return this._name;
        }

        public String getVersion() {
            return this._version;
        }
    }

    private class JdkHandler
    extends ElementVisitor {
        private JdkHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(LibrariesHook.e("classpath"), (ElementVisitor)new ClassPathHandler());
            context.registerChildVisitor(LibrariesHook.e("docpath"), (ElementVisitor)new DocPathHandler());
            context.registerChildVisitor(LibrariesHook.e("srcpath"), (ElementVisitor)new SrcPathHandler());
            String name = context.getAttributeValue("name");
            String version = context.getAttributeValue("version");
            context.getScopeData().put(LIBRARY, new JdkInfo(name, version));
        }

        public void end(ElementEndContext context) {
            LibrariesHook.this._jdkInfos.add(this.getJdk((ElementContext)context));
        }

        private JdkInfo getJdk(ElementContext context) {
            return (JdkInfo)context.getScopeData().get(LIBRARY);
        }

        private final class SrcPathHandler
        extends ElementVisitor {
            private SrcPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, JdkHandler.this.getJdk((ElementContext)context)._srcPath, true);
            }
        }

        private final class DocPathHandler
        extends ElementVisitor {
            private DocPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, JdkHandler.this.getJdk((ElementContext)context)._docPath, VERIFY_DOC_PATHS);
            }
        }

        private final class ClassPathHandler
        extends ElementVisitor {
            private ClassPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, JdkHandler.this.getJdk((ElementContext)context)._classPath, true);
            }
        }
    }

    private class FragmentHandler
    extends ElementVisitor {
        private FragmentHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(LibrariesHook.e("docpath"), (ElementVisitor)new DocPathHandler());
            context.registerChildVisitor(LibrariesHook.e("srcpath"), (ElementVisitor)new SrcPathHandler());
            context.getScopeData().put(LIBRARYNAME, context.getAttributeValue("name"));
            context.getScopeData().put(LIBRARY_FRAGMENT, new FragmentObject());
        }

        public void end(ElementEndContext context) {
            String name = (String)context.getScopeData().get(LIBRARYNAME);
            FragmentObject fragment = this.getFragment((ElementContext)context);
            AddinLibrary library = (AddinLibrary)LibrariesHook.this._libraries.get(name);
            if (library == null) {
                this.log((ElementContext)context, Level.SEVERE, "No library definition for " + name);
            } else {
                URLPath srcPath = new URLPath();
                srcPath.add(library.getSourcePath());
                srcPath.add(fragment._srcPath);
                URLPath docPath = new URLPath();
                docPath.add(library.getDocPath());
                docPath.add(fragment._docPath);
                LibrariesHook.this._libraries.put(name, new AddinLibrary(name, library.getClassPath(), srcPath, docPath, library.getDeployedByDefault(), library.getForceExtensionInitialization(), library.getProviderExtensionId(), library.isHidden(), library.getEndorsedStandardsDirectories(), library.getEndorsedStandardsSourcePath(), library.getEndorsedStandardsDocPath()));
            }
        }

        private FragmentObject getFragment(ElementContext context) {
            return (FragmentObject)context.getScopeData().get(LIBRARY_FRAGMENT);
        }

        private final class SrcPathHandler
        extends ElementVisitor {
            private SrcPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, ((FragmentHandler)FragmentHandler.this).getFragment((ElementContext)context)._srcPath, true);
            }
        }

        private final class DocPathHandler
        extends ElementVisitor {
            private DocPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, ((FragmentHandler)FragmentHandler.this).getFragment((ElementContext)context)._docPath, VERIFY_DOC_PATHS);
            }
        }

        class FragmentObject {
            URLPath _srcPath = new URLPath();
            URLPath _docPath = new URLPath();

            FragmentObject() {
            }
        }
    }

    private class LibraryHandler
    extends ElementVisitor {
        private LibraryHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(LibrariesHook.e("classpath"), (ElementVisitor)new ClassPathHandler());
            context.registerChildVisitor(LibrariesHook.e("docpath"), (ElementVisitor)new DocPathHandler());
            context.registerChildVisitor(LibrariesHook.e("srcpath"), (ElementVisitor)new SrcPathHandler());
            context.registerChildVisitor(LibrariesHook.e("endorsed-dirs"), (ElementVisitor)new EndorsedDirsHandler());
            context.registerChildVisitor(LibrariesHook.e("endorsed-docpath"), (ElementVisitor)new EndorsedDocPathHandler());
            context.registerChildVisitor(LibrariesHook.e("endorsed-srcpath"), (ElementVisitor)new EndorsedSrcPathHandler());
            context.getScopeData().put(LIBRARYNAME, context.getAttributeValue("name"));
            context.getScopeData().put(LibrariesHook.ATTR_LIBRARY_ENTRY, this.getManifestValuePath((ElementContext)context, context.getAttributeValue(LibrariesHook.MANIFEST_ATTR)));
            context.getScopeData().put(LIBRARYDEPLOYED, context.getAttributeValue("deployed"));
            context.getScopeData().put(LIBRARY_FORCES_EXT_INITIALIZATION, context.getAttributeValue("forceExtensionInitialization"));
            context.getScopeData().put(LIBRARY_HIDDEN, context.getAttributeValue("hidden"));
            context.getScopeData().put(LIBRARY, new LibraryObject());
            context.getScopeData().put(DEPENDENT_LIBRARY, new DependentLibraryObject());
        }

        public void end(ElementEndContext context) {
            String hidden;
            String name = (String)context.getScopeData().get(LIBRARYNAME);
            LibraryObject library = this.getLibrary((ElementContext)context);
            String deployed = (String)context.getScopeData().get(LIBRARYDEPLOYED);
            boolean isDeployed = deployed != null && deployed.equalsIgnoreCase("true");
            String forceExtInit = (String)context.getScopeData().get(LIBRARY_FORCES_EXT_INITIALIZATION);
            boolean forceExtInitialization = true;
            if (forceExtInit != null && forceExtInit.equalsIgnoreCase("false")) {
                forceExtInitialization = false;
            }
            boolean isHidden = (hidden = (String)context.getScopeData().get(LIBRARY_HIDDEN)) != null && Boolean.valueOf(hidden) != false;
            LibrariesHook.this._libraries.put(name, new AddinLibrary(name, library._classPath, library._srcPath, library._docPath, isDeployed ? Boolean.TRUE : Boolean.FALSE, forceExtInitialization ? Boolean.TRUE : Boolean.FALSE, LibrariesHook.this.getExtension((ElementContext)context).getID(), isHidden, library._endorsedDirs, library._endorsedSrcPath, library._endorsedDocPath));
            URI libraryManifest = (URI)context.getScopeData().get(LibrariesHook.ATTR_LIBRARY_ENTRY);
            DependentLibraryObject dlo = this.getDependentLibrary((ElementContext)context);
            LibrariesHook.this._manifestLibraries.put(name, new DependentLibraryInfo(name, libraryManifest, dlo._mClassPath, dlo._mSrcPath, dlo._mDocPath));
        }

        private LibraryObject getLibrary(ElementContext context) {
            return (LibraryObject)context.getScopeData().get(LIBRARY);
        }

        private DependentLibraryObject getDependentLibrary(ElementContext context) {
            return (DependentLibraryObject)context.getScopeData().get(DEPENDENT_LIBRARY);
        }

        public URI getManifestValuePath(ElementContext context, String manifestValue) {
            if (manifestValue != null && manifestValue.trim().length() > 0) {
                URI sourceUri = context.getExtensionSourceURI();
                URI manifestUri = URIFactory.newJarURI((URI)sourceUri, (String)manifestValue);
                if (!VirtualFileSystem.getVirtualFileSystem().exists(manifestUri)) {
                    this.log(context, Level.SEVERE, "manifest library path not found: " + VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(manifestUri));
                    return null;
                }
                return manifestUri;
            }
            return null;
        }

        public void handleManifestAttribute(ElementStartContext context) {
            URI manifestUri;
            String manifestValue = context.getAttributeValue(LibrariesHook.MANIFEST_ATTR);
            if (manifestValue != null && (manifestUri = this.getManifestValuePath((ElementContext)context, manifestValue)) != null) {
                context.getScopeData().put(LibrariesHook.ATTR_PATH_ENTRY, manifestUri);
            }
        }

        public URL getPathEntry(ElementEndContext context) {
            URLPath path = new URLPath();
            LibrariesHook.this.addURLPath(context, path);
            URL artifactPath = path.getFirstEntry();
            return artifactPath;
        }

        private final class EndorsedSrcPathHandler
        extends ElementVisitor {
            private EndorsedSrcPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, ((LibraryHandler)LibraryHandler.this).getLibrary((ElementContext)context)._endorsedSrcPath, true);
            }
        }

        private final class EndorsedDocPathHandler
        extends ElementVisitor {
            private EndorsedDocPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, ((LibraryHandler)LibraryHandler.this).getLibrary((ElementContext)context)._endorsedDocPath, VERIFY_DOC_PATHS);
            }
        }

        private final class EndorsedDirsHandler
        extends ElementVisitor {
            private EndorsedDirsHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, ((LibraryHandler)LibraryHandler.this).getLibrary((ElementContext)context)._endorsedDirs, true);
            }
        }

        private final class SrcPathHandler
        extends ElementVisitor {
            private SrcPathHandler() {
            }

            public void start(ElementStartContext context) {
                LibraryHandler.this.handleManifestAttribute(context);
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, ((LibraryHandler)LibraryHandler.this).getLibrary((ElementContext)context)._srcPath, true);
                URL artifactPath = LibraryHandler.this.getPathEntry(context);
                URI manifestPath = (URI)context.getScopeData().get(LibrariesHook.ATTR_PATH_ENTRY);
                ((LibraryHandler)LibraryHandler.this).getDependentLibrary((ElementContext)context)._mSrcPath.put(URLKey.getInstance((URL)artifactPath).intern(), manifestPath);
            }
        }

        private final class DocPathHandler
        extends ElementVisitor {
            private DocPathHandler() {
            }

            public void start(ElementStartContext context) {
                LibraryHandler.this.handleManifestAttribute(context);
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, ((LibraryHandler)LibraryHandler.this).getLibrary((ElementContext)context)._docPath, VERIFY_DOC_PATHS);
                URL artifactPath = LibraryHandler.this.getPathEntry(context);
                URI manifestPath = (URI)context.getScopeData().get(LibrariesHook.ATTR_PATH_ENTRY);
                ((LibraryHandler)LibraryHandler.this).getDependentLibrary((ElementContext)context)._mDocPath.put(URLKey.getInstance((URL)artifactPath).intern(), manifestPath);
            }
        }

        private final class ClassPathHandler
        extends ElementVisitor {
            private ClassPathHandler() {
            }

            public void start(ElementStartContext context) {
                LibraryHandler.this.handleManifestAttribute(context);
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, ((LibraryHandler)LibraryHandler.this).getLibrary((ElementContext)context)._classPath, true);
                URL artifactPath = LibraryHandler.this.getPathEntry(context);
                URI manifestPath = (URI)context.getScopeData().get(LibrariesHook.ATTR_PATH_ENTRY);
                ((LibraryHandler)LibraryHandler.this).getDependentLibrary((ElementContext)context)._mClassPath.put(URLKey.getInstance((URL)artifactPath).intern(), manifestPath);
            }
        }

        class DependentLibraryObject {
            HashMap<URLKey, URI> _mClassPath = new HashMap();
            HashMap<URLKey, URI> _mSrcPath = new HashMap();
            HashMap<URLKey, URI> _mDocPath = new HashMap();

            DependentLibraryObject() {
            }
        }

        class LibraryObject {
            URLPath _classPath = new URLPath();
            URLPath _srcPath = new URLPath();
            URLPath _docPath = new URLPath();
            URLPath _endorsedDirs = new URLPath();
            URLPath _endorsedSrcPath = new URLPath();
            URLPath _endorsedDocPath = new URLPath();

            LibraryObject() {
            }
        }
    }

    private class AliasHandler
    extends ElementVisitor {
        private AliasHandler() {
        }

        public void start(ElementStartContext context) {
            String from = context.getAttributeValue("from");
            String to = context.getAttributeValue("to");
            LibrariesHook.this._aliases.put(from, to);
        }
    }
}

