/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.model.BooleanModel;
import oracle.bali.ewt.worker.DelegatingWorker;
import oracle.bali.ewt.worker.Worker;

public class SwitchingWorker
extends DelegatingWorker {
    private Worker _trueWorker;
    private Worker _falseWorker;

    public SwitchingWorker(Worker trueWorker, Worker falseWorker, BooleanModel controller) {
        if (controller == null) {
            throw new IllegalArgumentException();
        }
        this._trueWorker = trueWorker;
        this._falseWorker = falseWorker;
        controller.addChangeListener(new WorkerChanger());
        this._setNewWorker(controller);
    }

    public Worker getTrueWorker() {
        return this._trueWorker;
    }

    public Worker getFalseWorker() {
        return this._falseWorker;
    }

    private void _setNewWorker(BooleanModel workerController) {
        Worker newWorker = workerController.getState() ? this.getTrueWorker() : this.getFalseWorker();
        this.setDelegatedWorker(newWorker);
    }

    private class WorkerChanger
    implements ChangeListener {
        private WorkerChanger() {
        }

        public void stateChanged(ChangeEvent event) {
            SwitchingWorker.this._setNewWorker((BooleanModel)event.getSource());
        }
    }
}

