/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import javax.accessibility.AccessibleContext;
import oracle.bali.ewt.spinBox.NumberRange;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.collection.Range;

class NumericSpinBuddy
extends NumberTextField
implements SpinBuddy {
    private Range _range;
    private boolean _decimal;
    private boolean _doValidate = false;

    public NumericSpinBuddy() {
        this.setDecimal(false);
    }

    public void updateUI() {
        super.updateUI();
        this.setBorder(null);
        this.setOpaque(true);
        this.setForeground(null);
        this.setBackground(null);
    }

    public void setValue(Object value) {
        if (!value.equals(this.getNumber())) {
            this.__setValue(value);
        }
    }

    public void setRange(Range range) {
        if (range instanceof NumberRange) {
            this.setSigned(((NumberRange)range).getLower().doubleValue() < 0.0);
        } else {
            this.setSigned(range.getLowerLimit() < 0);
        }
        int lowerCol = this._digits(range.getLowerLimit());
        int upperCol = this._digits(range.getUpperLimit());
        this.setColumns(Math.max(lowerCol, upperCol));
        this._range = range;
    }

    protected boolean validateNumber(Number number) {
        if (!this._doValidate) {
            return true;
        }
        Range range = this.__getRange();
        if (range == null) {
            return true;
        }
        return !(this.isDecimal() ? (range instanceof NumberRange ? !((NumberRange)range).inRange(number) : !range.inRange(number.intValue())) : !range.inRange(number.intValue()));
    }

    void __setValue(Object value) {
        int decimal;
        boolean left = true;
        Number n = (Number)value;
        if (!this.isDecimal()) {
            value = new Integer(n.intValue());
        } else {
            decimal = -1;
            int prevDecimalDigits = 0;
            String text = this.getText();
            if (text != null && (decimal = text.indexOf(46)) != -1) {
                prevDecimalDigits = text.length() - decimal - 1;
                value = this._round(n.doubleValue(), prevDecimalDigits);
            }
            int caretPos = this.getCaretPosition();
            if (decimal != -1 && decimal < caretPos) {
                left = false;
            }
        }
        this.setNumber((Number)value);
        if (this.hasFocus()) {
            decimal = -1;
            String text = this.getText();
            if (text != null) {
                decimal = text.indexOf(46);
            }
            if (left) {
                if (decimal != -1) {
                    this.select(0, decimal);
                } else {
                    this.selectAll();
                }
            } else {
                this.select(decimal + 1, text.length());
            }
        }
    }

    void __setDoValidate(boolean validate) {
        this._doValidate = validate;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleNumericSpinBuddy();
        }
        return this.accessibleContext;
    }

    Range __getRange() {
        return this._range;
    }

    boolean __isDecimal() {
        return this._decimal;
    }

    void __setDecimal(boolean decimal) {
        if (this.isDecimal() != decimal) {
            this._decimal = decimal;
            if (decimal) {
                this.setDataType(Double.class);
            } else {
                this.setDataType(Integer.class);
            }
        }
    }

    private int _digits(int number) {
        int digits;
        if (number < 0) {
            number = -number;
            digits = 1;
        } else {
            digits = 0;
        }
        do {
            ++digits;
        } while ((number /= 10) > 0);
        return digits;
    }

    private double _round(double Rval, int sig) {
        double p = (float)Math.pow(10.0, sig);
        double tmp = Math.round(Rval *= p);
        return tmp / p;
    }

    protected class AccessibleNumericSpinBuddy
    extends NumberTextField.AccessibleNumberTextField {
        protected AccessibleNumericSpinBuddy() {
            super(NumericSpinBuddy.this);
        }

        public String getAccessibleName() {
            String name = super.getAccessibleName();
            return name == null ? this.getAccessibleParent().getAccessibleContext().getAccessibleName() : name;
        }

        public String getAccessibleDescription() {
            String name = super.getAccessibleDescription();
            return name == null ? this.getAccessibleParent().getAccessibleContext().getAccessibleDescription() : name;
        }

        public boolean setCurrentAccessibleValue(Number n) {
            Range range = NumericSpinBuddy.this.__getRange();
            if (range instanceof NumberRange) {
                if (((NumberRange)range).inRange(n)) {
                    NumericSpinBuddy.this.setValue(n);
                    return true;
                }
            } else if (range.inRange(n.intValue())) {
                NumericSpinBuddy.this.setValue(n);
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            Range range = NumericSpinBuddy.this.__getRange();
            if (range instanceof NumberRange) {
                return ((NumberRange)range).getLower();
            }
            return range.getLowerLimit();
        }

        public Number getMaximumAccessibleValue() {
            Range range = NumericSpinBuddy.this.__getRange();
            if (range instanceof NumberRange) {
                return ((NumberRange)range).getUpper();
            }
            return range.getUpperLimit();
        }

        public int getCaretPosition() {
            return this.getSelectionStart();
        }
    }
}

