/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.pivot.AbstractPivotHeaderHeaderItem;
import oracle.bali.ewt.pivot.AbstractPivotPopup;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingComponent;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.share.nls.LocaleUtils;

public class PivotPopup
extends AbstractPivotPopup {
    private static final String _KEY_COLUMN_HEADER = "PIVOT.MENU_COLUMN";
    private static final String _KEY_ROW_HEADER = "PIVOT.MENU_ROW";
    private static final String _KEY_PAGING = "PIVOT.MENU_PAGING";
    private static final String _KEY_LEVEL = "PIVOT.MENU_LEVEL";
    private static final String _BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private PivotTable _pivot;
    private PagingComponent _pagingComponent;

    public PivotPopup(PivotTable table) {
        this(table, null);
    }

    public PivotPopup(PivotTable table, PagingComponent pageComponent) {
        if (table == null) {
            throw new NullPointerException("table must be non null");
        }
        this._pivot = table;
        this._pagingComponent = pageComponent;
        this.initialize();
    }

    public boolean isSwapAllowed() {
        boolean swap = this._pivot.isSwapAllowed();
        if (this._pagingComponent != null) {
            swap &= this._pagingComponent.isSwapAllowed();
        }
        return swap;
    }

    public Locale getLocale() {
        return LocaleUtils.getDefaultableLocale((Component)this._pivot);
    }

    public Object[] getSources() {
        ArrayList<LWComponent> list = new ArrayList<LWComponent>(3);
        if (this._pivot.getColumnPivotHeader() != null) {
            list.add(this._pivot.getColumnPivotHeader());
        }
        if (this._pivot.getRowPivotHeader() != null) {
            list.add(this._pivot.getRowPivotHeader());
        }
        if (this._pagingComponent != null) {
            list.add(this._pagingComponent);
        }
        return list.toArray();
    }

    public Component getSourceComponent(Object source) {
        if (source == this._pivot.getColumnPivotHeader()) {
            return this._pivot.getColumnPivotHeader().getRowHeader();
        }
        if (source == this._pivot.getRowPivotHeader()) {
            return this._pivot.getRowPivotHeader().getColumnHeader();
        }
        if (source == this._pagingComponent) {
            return this._pagingComponent;
        }
        return null;
    }

    public Object getSource(Component component) {
        if (this._pivot.getColumnPivotHeader() != null && component == this._pivot.getColumnPivotHeader().getRowHeader()) {
            return this._pivot.getColumnPivotHeader();
        }
        if (this._pivot.getRowPivotHeader() != null && component == this._pivot.getRowPivotHeader().getColumnHeader()) {
            return this._pivot.getRowPivotHeader();
        }
        if (this._pagingComponent != null && this._pagingComponent.isAncestorOf(component)) {
            return this._pagingComponent;
        }
        return null;
    }

    public int getSourceIndex(Component component, int x, int y, boolean keyboard) {
        if (this._pivot.getColumnPivotHeader() != null && component == this._pivot.getColumnPivotHeader().getRowHeader()) {
            if (keyboard) {
                return this._pivot.getColumnPivotHeader().getRowHeader().getFocusItem();
            }
            return this._pivot.getColumnPivotHeader().getRowHeader().getItemAt(x, y);
        }
        if (this._pivot.getRowPivotHeader() != null && component == this._pivot.getRowPivotHeader().getColumnHeader()) {
            if (keyboard) {
                return this._pivot.getRowPivotHeader().getColumnHeader().getFocusItem();
            }
            return this._pivot.getRowPivotHeader().getColumnHeader().getItemAt(x, y);
        }
        if (this._pagingComponent != null && this._pagingComponent.isAncestorOf(component)) {
            PageItem item = null;
            while (component != null) {
                if (component instanceof PageItem) {
                    item = (PageItem)component;
                    break;
                }
                component = component.getParent();
            }
            if (item != null) {
                return this._pagingComponent.getIndex(item);
            }
        }
        return -1;
    }

    public Object[] getTargets() {
        return this.getSources();
    }

    public String getTargetLabel(Object target) {
        if (target == this._pivot.getColumnPivotHeader()) {
            return this._getTranslatedString(_KEY_COLUMN_HEADER);
        }
        if (target == this._pivot.getRowPivotHeader()) {
            return this._getTranslatedString(_KEY_ROW_HEADER);
        }
        if (target == this._pagingComponent) {
            return this._getTranslatedString(_KEY_PAGING);
        }
        return null;
    }

    public int getTargetDropCount(Object target) {
        if (target == this._pivot.getColumnPivotHeader()) {
            return this._pivot.getColumnPivotHeader().getRowHeader().getItemCount();
        }
        if (target == this._pivot.getRowPivotHeader()) {
            return this._pivot.getRowPivotHeader().getColumnHeader().getItemCount();
        }
        if (target == this._pagingComponent) {
            return this._pagingComponent.getComponentCount();
        }
        return 0;
    }

    public String getTargetDropLabel(Object target, int dropIndex) {
        PageItem item;
        if (target == this._pivot.getColumnPivotHeader() || target == this._pivot.getRowPivotHeader()) {
            String label;
            Object data;
            PivotHeader column = this._pivot.getColumnPivotHeader();
            PivotHeader row = this._pivot.getRowPivotHeader();
            Object object = data = target == column ? column.getRowHeader().getModel().getData(dropIndex) : row.getColumnHeader().getModel().getData(dropIndex);
            if (data instanceof AbstractPivotHeaderHeaderItem) {
                data = ((AbstractPivotHeaderHeaderItem)data).getData();
            }
            if ((label = this.getAxisLabelString(data)) == null) {
                MessageFormat levelFormat = new MessageFormat(this._getTranslatedString(_KEY_LEVEL));
                Object[] args = new Object[]{String.valueOf(dropIndex + 1)};
                label = levelFormat.format(args);
            }
            return label;
        }
        if (target == this._pagingComponent && (item = this._pagingComponent.getItem(dropIndex)) != null) {
            return item.getText();
        }
        return null;
    }

    public void firePivotEvent(Object source, int sourceIndex, Object target, int targetIndex) {
        if (source == this._pivot.getColumnPivotHeader() || source == this._pivot.getRowPivotHeader()) {
            this._pivot.firePivotEvent(source, sourceIndex, target, targetIndex);
        } else if (source == this._pagingComponent) {
            this._pagingComponent.firePivotEvent(source, sourceIndex, target, targetIndex);
        }
    }

    public void fireSwapEvent(Object source, int sourceIndex, Object target, int targetIndex) {
        if (source == this._pivot.getColumnPivotHeader() || source == this._pivot.getRowPivotHeader()) {
            this._pivot.fireSwapEvent(source, sourceIndex, target, targetIndex);
        } else if (source == this._pagingComponent) {
            this._pagingComponent.fireSwapEvent(source, sourceIndex, target, targetIndex);
        }
    }

    public void dispose() {
        super.dispose();
        this._pivot = null;
        this._pagingComponent = null;
    }

    protected String getAxisLabelString(Object data) {
        return data == null ? null : data.toString();
    }

    private String _getTranslatedString(String key) {
        try {
            ResourceBundle b = ResourceBundle.getBundle(_BUNDLE, this.getLocale());
            return b.getString(key);
        }
        catch (Exception e) {
            return "Key not found";
        }
    }
}

