/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleThumbPainter;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;

class OracleSplitPanePainter
extends AbstractPainter {
    private static final int _GRIPPY_SIZE = 3;
    private static final int _GRIPPY_GAP = 5;
    private static final int _GRIPPY_STRIDE = 8;
    private static final int _MIN_GRIPPIES = 3;
    private static final int _MIN_PERP_GRIPPY_SIZE = 5;
    private static final int _MIN_ORIENT_GRIPPY_SIZE = 19;
    private boolean _isHorizontal;

    public OracleSplitPanePainter(boolean isHorizontal) {
        this._isHorizontal = isHorizontal;
    }

    public Dimension getMinimumSize(PaintContext context) {
        if (this._isHorizontal) {
            return new Dimension(19, 5);
        }
        return new Dimension(5, 19);
    }

    public int getRepaintFlags(PaintContext context) {
        return 135;
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        g.setColor(context.getPaintBackground());
        g.fillRect(x, y, width, height);
        int state = context.getPaintState();
        if ((state & 5) == 0) {
            int availableSize;
            int n = availableSize = this._isHorizontal ? width : height;
            if (availableSize >= 19) {
                boolean isArmed;
                int numGrippies = availableSize / 40;
                if ((numGrippies |= 1) < 3) {
                    numGrippies = 3;
                }
                int grippySize = numGrippies * 3 + (numGrippies - 1) * 5;
                int grippyWidth = 3;
                int grippyHeight = 3;
                int xOffset = 0;
                int yOffset = 0;
                if (this._isHorizontal) {
                    grippyWidth = grippySize;
                    xOffset = 8;
                } else {
                    grippyHeight = grippySize;
                    yOffset = 8;
                }
                int grippyX = x + (width - grippyWidth) / 2;
                int grippyY = y + (height - grippyHeight) / 2;
                UIDefaults defaults = context.getPaintUIDefaults();
                Color highlight = defaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
                Color shadow = defaults.getColor(ColorScheme.CONTROL_SHADOW_DARK);
                boolean bl = isArmed = (state & 2) != 0;
                while (numGrippies > 0) {
                    OracleThumbPainter.__drawGrippy(g, grippyX, grippyY, highlight, shadow, isArmed);
                    --numGrippies;
                    grippyX += xOffset;
                    grippyY += yOffset;
                }
            }
        }
        g.setColor(savedColor);
    }
}

