/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import oracle.bali.ewt.olaf.MenuClearAction;
import oracle.bali.ewt.olaf.OraclePopupMenuBorder;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.util.FocusUtils;

public class OraclePopupMenuUI
extends BasicPopupMenuUI
implements PropertyChangeListener {
    private static boolean _sMenuClearActionSet;

    public static ComponentUI createUI(JComponent component) {
        return new OraclePopupMenuUI();
    }

    public void installUI(JComponent component) {
        super.installUI(component);
        Border oldBorder = component.getBorder();
        if (oldBorder == null || oldBorder instanceof UIResource) {
            this.popupMenu.setBorder(new BorderAdapter(new OraclePopupMenuBorder(null, this.popupMenu)));
        }
        OracleUIUtils.putPaintContext(component);
    }

    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        OracleUIUtils.removePaintContext(component);
    }

    public void update(Graphics g, JComponent c) {
        OracleUIUtils.fillBackground(g, c);
        this.paint(g, c);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("ancestor".equals(propertyName)) {
            Object newValue;
            Object oldValue = e.getOldValue();
            if (oldValue instanceof JComponent) {
                ((JComponent)oldValue).setOpaque(true);
            }
            if ((newValue = e.getNewValue()) instanceof JComponent) {
                ((JComponent)newValue).setOpaque(false);
            }
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            ActionMap map;
            if (!_sMenuClearActionSet && (map = (ActionMap)UIManager.get("PopupMenu.actionMap")) != null) {
                map.put("oracle.bali.ewt.olaf.MenuClearAction", MenuClearAction.getInstance());
                _sMenuClearActionSet = true;
            }
        } else {
            ActionMap map = SwingUtilities.getUIActionMap(this.popupMenu);
            if (map != null) {
                map.put("oracle.bali.ewt.olaf.MenuClearAction", MenuClearAction.getInstance());
            }
        }
    }

    protected void uninstallKeyboardActions() {
        ActionMap map;
        if (!FocusUtils.areNewFocusAPIsAvailable() && (map = SwingUtilities.getUIActionMap(this.popupMenu)) != null) {
            map.put("oracle.bali.ewt.olaf.MenuClearAction", null);
        }
        super.uninstallKeyboardActions();
    }

    protected void installListeners() {
        super.installListeners();
        this.popupMenu.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenu.removePropertyChangeListener(this);
    }

    private OraclePopupMenuUI() {
    }
}

