/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class OracleButtonPainter
extends AbstractBorderPainter {
    private static final int[] _sBGOffsets = new int[]{1, 2, 2, 3, 5, 8};
    private static final int _TOP = 3;
    private static final int _BOTTOM = 4;
    private static final int _LEFT = 3;
    private static final int _RIGHT = 3;
    private static final int _ARMED_SHIFT = 1;
    private static final int _EXTRA_CURVE_WIDTH = 5;
    private static final ImmInsets[] _INSETS_ARRAY = new ImmInsets[]{new ImmInsets(3, 3, 4, 3), new ImmInsets(4, 3, 3, 3), new ImmInsets(3, 3, 4, 8), new ImmInsets(4, 3, 3, 8), new ImmInsets(3, 8, 4, 3), new ImmInsets(4, 8, 3, 3), new ImmInsets(3, 8, 4, 8), new ImmInsets(4, 8, 3, 8)};
    private static final ImmInsets _THIN_INSETS = new ImmInsets(2, 2, 2, 2);
    private static final ImmInsets _THIN_ARMED_INSETS = new ImmInsets(3, 2, 1, 2);
    private boolean _hasLeftCurve;
    private boolean _hasRightCurve;
    private boolean _useThinBorder;
    private boolean _isToolBarButton;
    private boolean _hasMouseOverBorder;
    private boolean _isToggleButton;

    public OracleButtonPainter() {
    }

    public OracleButtonPainter(Painter wrappedPainter) {
        super(wrappedPainter);
    }

    public OracleButtonPainter(Painter wrappedPainter, boolean useThinBorder, boolean isToolBarButton, boolean hasMouseOverBorder) {
        this(wrappedPainter, useThinBorder, isToolBarButton, hasMouseOverBorder, false);
    }

    public OracleButtonPainter(Painter wrappedPainter, boolean useThinBorder, boolean isToolBarButton, boolean hasMouseOverBorder, boolean isToggleButton) {
        super(wrappedPainter);
        this._useThinBorder = useThinBorder;
        this._isToolBarButton = isToolBarButton;
        this._hasMouseOverBorder = hasMouseOverBorder;
        this._isToggleButton = isToggleButton;
    }

    public OracleButtonPainter(Painter wrappedPainter, boolean hasLeftCurve, boolean hasRightCurve) {
        this(wrappedPainter, hasLeftCurve, hasRightCurve, Boolean.FALSE);
    }

    public OracleButtonPainter(Painter wrappedPainter, boolean hasLeftCurve, boolean hasRightCurve, Boolean isToggleButton) {
        super(wrappedPainter);
        this._hasLeftCurve = hasLeftCurve;
        this._hasRightCurve = hasRightCurve;
        this._isToggleButton = isToggleButton;
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        boolean isArmed;
        boolean bl = isArmed = (context.getPaintState() & 2) != 0;
        if (this._useThinBorder) {
            return isArmed ? _THIN_ARMED_INSETS : _THIN_INSETS;
        }
        int insetsIndex = 0;
        if (this._hasLeftCurve(context)) {
            insetsIndex += 4;
        }
        if (this._hasRightCurve(context)) {
            insetsIndex += 2;
        }
        if (isArmed) {
            ++insetsIndex;
        }
        return _INSETS_ARRAY[insetsIndex];
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color gray;
        Color darkToLight;
        Color normalToLight;
        Color grayToLight;
        Color lightToGrayOrLight;
        Color lightToGray;
        Color lightToDark;
        Color upperLeftCorner;
        boolean isSet;
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color inactiveColor = defaults.getColor(ColorScheme.CONTROL_SHADOW_DARK);
        boolean isDisabled = (state & 1) != 0;
        boolean isInactive = (state & 4) != 0;
        boolean isArmed = (state & 2) != 0;
        boolean bl = isSet = (state & 8) != 0;
        if ((state & 0x80) != 0 && !this._isToolBarButton && !isInactive) {
            g.setColor(isInactive ? inactiveColor : Color.black);
            int armedY = isArmed ? y + 1 : bottom - 1;
            int lineStartX = x + 1;
            int lineEndX = right - 1;
            if (this._hasLeftCurve(context)) {
                this._drawDefaultCurve(g, (lineStartX += 6) - 1, y, bottom, 1);
            } else {
                g.drawLine(x, y + 1, x, bottom - 1);
                g.drawLine(x + 1, armedY, x + 1, armedY);
            }
            if (this._hasRightCurve(context)) {
                this._drawDefaultCurve(g, (lineEndX -= 6) + 1, y, bottom, -1);
            } else {
                g.drawLine(right, y + 1, right, bottom - 1);
                g.drawLine(right - 1, armedY, right - 1, armedY);
            }
            g.drawLine(lineStartX, y, lineEndX, y);
            g.drawLine(lineStartX, bottom, lineEndX, bottom);
        }
        ++x;
        ++y;
        --bottom;
        --right;
        Color background = context.getPaintBackground();
        if (isInactive) {
            upperLeftCorner = inactiveColor;
            lightToDark = inactiveColor;
            lightToGray = inactiveColor;
            lightToGrayOrLight = inactiveColor;
            grayToLight = inactiveColor;
            normalToLight = inactiveColor;
            darkToLight = inactiveColor;
            gray = inactiveColor;
        } else {
            Color light;
            String lightKey = this._isToggleButton ? "ToggleButton.lightBorder" : "Button.lightBorder";
            upperLeftCorner = light = defaults.getColor(lightKey);
            gray = defaults.getColor(ColorScheme.NORMAL_INTENSITY);
            lightToDark = light;
            lightToGrayOrLight = light;
            lightToGray = light;
            grayToLight = gray;
            normalToLight = defaults.getColor(LookAndFeel.CONTROL_SHADOW);
            String darkKey = this._isToggleButton ? "ToggleButton.darkBorder" : "Button.darkBorder";
            Color dark = defaults.getColor(darkKey);
            darkToLight = isDisabled ? gray : dark;
            if (isArmed || isSet) {
                if (!isDisabled && isArmed && this._isToolBarButton) {
                    background = gray;
                }
                upperLeftCorner = gray;
                lightToGrayOrLight = defaults.getColor(ColorScheme.CONTROL_SHADOW_VERY_LIGHT);
                lightToGray = gray;
                grayToLight = light;
                normalToLight = light;
                lightToDark = dark;
                darkToLight = light;
            }
        }
        if ((context.getPaintState() & 0x100) != 0) {
            background = null;
        }
        if (!this._isToolBarButton && !this._hasMouseOverBorder || isArmed || isSet || this._hasMouseOverBorder && !isDisabled && (state & 0x10) != 0) {
            if (this._hasLeftCurve(context)) {
                OracleButtonPainter.drawSideCurve(g, lightToDark, lightToGray, lightToGray, grayToLight, darkToLight, background, x += 5, y, bottom, 1);
            } else {
                this._drawLeftSide(g, upperLeftCorner, lightToDark, lightToGrayOrLight, normalToLight, gray, background, x, y, bottom);
            }
            if (this._hasRightCurve(context)) {
                OracleButtonPainter.drawSideCurve(g, lightToGray, grayToLight, darkToLight, darkToLight, darkToLight, background, right -= 5, y, bottom, -1);
            } else {
                this._drawRightSide(g, darkToLight, lightToGrayOrLight, normalToLight, gray, background, right, y, bottom);
            }
            g.setColor(lightToDark);
            g.drawLine(x + 2, y, right - 2, y);
            g.setColor(darkToLight);
            g.drawLine(x + 2, bottom, right - 2, bottom);
        }
        if (background != null) {
            g.setColor(background);
            g.drawLine(x += 2, (y += 2) - 1, right -= 2, y - 1);
            g.drawLine(x, (bottom -= 2) + 1, right, bottom + 1);
            int armedY = isArmed ? y : bottom;
            g.drawLine(x, armedY, right, armedY);
            if (isArmed && this._isToolBarButton) {
                g.fillRect(x, y, right - x + 1, bottom - y + 1);
            }
        }
        g.setColor(savedColor);
    }

    public Painter getContentPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        Painter contentPainter = super.getContentPainterAt(context, availableWidth, availableHeight, x, y, proxyPainter);
        if (proxyPainter == this && contentPainter != null || contentPainter == null && x >= 0 && y >= 0 && x < availableWidth && y < availableHeight) {
            contentPainter = this;
        }
        return contentPainter;
    }

    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    public int getRepaintFlags(PaintContext context) {
        int flags = super.getRepaintFlags(context) | 1 | 4 | 2 | 0x40 | 0x400 | 0x80;
        if (this._hasMouseOverBorder) {
            flags |= 0x10;
        }
        return flags;
    }

    private void _drawDefaultCurve(Graphics g, int x, int y, int bottom, int multiplier) {
        int x1 = x - multiplier;
        int x4 = x1 - multiplier * 3;
        int x5 = x4 - multiplier;
        int x6 = x5 - multiplier;
        g.drawLine(x, y + 1, x, y + 1);
        g.drawLine(x1, y + 1, x4, y + 4);
        g.drawLine(x4, y + 5, x5, y + 6);
        g.drawLine(x5, y + 7, x5, y + 8);
        g.drawLine(x6, y + 9, x6, bottom - 9);
        g.drawLine(x5, bottom - 7, x5, bottom - 8);
        g.drawLine(x4, bottom - 5, x5, bottom - 6);
        g.drawLine(x1, bottom - 1, x4, bottom - 4);
        g.drawLine(x, bottom - 1, x, bottom - 1);
    }

    public static void drawSideCurve(Graphics g, Color topCurveColor, Color upperCurveColor, Color middleCurveColor, Color bottomCurveColor, Color bottomColor, Color background, int x, int y, int bottom, int multiplier) {
        int xp1 = x + multiplier;
        int x1 = x - multiplier;
        int x2 = x1 - multiplier;
        int x3 = x2 - multiplier;
        int x4 = x3 - multiplier;
        int x5 = x4 - multiplier;
        g.setColor(topCurveColor);
        g.drawLine(xp1, y, xp1, y);
        g.drawLine(x1, y + 1, x, y + 1);
        g.drawLine(x2, y + 2, x2, y + 2);
        g.drawLine(x3, y + 3, x3, y + 3);
        g.setColor(upperCurveColor);
        g.drawLine(x3, y + 4, x3, y + 4);
        g.drawLine(x4, y + 5, x4, y + 7);
        g.setColor(middleCurveColor);
        g.drawLine(x5, y + 8, x5, bottom - 8);
        g.drawLine(x4, bottom - 5, x4, bottom - 7);
        g.drawLine(x3, bottom - 4, x3, bottom - 4);
        g.setColor(bottomCurveColor);
        g.drawLine(x3, bottom - 3, x3, bottom - 3);
        g.drawLine(x2, bottom - 2, x2, bottom - 2);
        g.drawLine(x1, bottom - 1, x, bottom - 1);
        g.setColor(bottomColor);
        g.drawLine(xp1, bottom, xp1, bottom);
        if (background != null) {
            g.setColor(background);
            int[] bgOffsets = _sBGOffsets;
            int numOffsets = _sBGOffsets.length;
            multiplier = -multiplier;
            x -= multiplier;
            for (int i = 0; i < numOffsets; ++i) {
                int currOffset = bgOffsets[i];
                g.drawLine(x, y + currOffset, x, bottom - currOffset);
                x += multiplier;
            }
        }
    }

    private void _drawLeftSide(Graphics g, Color upperLeftCorner, Color lightToDark, Color lightToGray, Color grayToLight, Color gray, Color background, int x, int y, int bottom) {
        g.setColor(upperLeftCorner);
        g.drawLine(x + 1, y + 1, x + 1, y + 1);
        g.setColor(lightToDark);
        g.drawLine(x + 1, y, x + 1, y);
        g.drawLine(x, y + 1, x, bottom - 2);
        g.setColor(lightToGray);
        g.drawLine(x, bottom - 1, x, bottom - 1);
        g.setColor(gray);
        g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
        g.setColor(grayToLight);
        g.drawLine(x + 1, bottom, x + 1, bottom);
        if (background != null) {
            g.setColor(background);
            g.drawLine(x + 1, y + 2, x + 1, bottom - 2);
        }
    }

    private void _drawRightSide(Graphics g, Color darkToLight, Color lightToGray, Color grayToLight, Color gray, Color background, int x, int y, int bottom) {
        g.setColor(darkToLight);
        g.drawLine(x, y + 2, x, bottom - 1);
        g.drawLine(x - 1, bottom, x - 1, bottom);
        g.setColor(grayToLight);
        g.drawLine(x, y + 1, x, y + 1);
        g.drawLine(x - 1, bottom - 1, x - 1, bottom - 1);
        g.setColor(gray);
        g.drawLine(x - 1, y + 1, x - 1, y + 1);
        g.setColor(lightToGray);
        g.drawLine(x - 1, y, x - 1, y);
        if (background != null) {
            g.setColor(background);
            g.drawLine(x - 1, y + 2, x - 1, bottom - 2);
        }
    }

    private boolean _hasLeftCurve(PaintContext context) {
        Object o;
        boolean hasLeftCurve = this._hasLeftCurve;
        JComponent c = context.getComponent();
        if (c instanceof JComponent && (o = c.getClientProperty(PushButton.LEFTMOST_BUTTON_KEY)) instanceof Boolean) {
            hasLeftCurve = (Boolean)o;
        }
        return hasLeftCurve;
    }

    private boolean _hasRightCurve(PaintContext context) {
        Object o;
        boolean hasRightCurve = this._hasRightCurve;
        JComponent c = context.getComponent();
        if (c instanceof JComponent && (o = c.getClientProperty(PushButton.RIGHTMOST_BUTTON_KEY)) instanceof Boolean) {
            hasRightCurve = (Boolean)o;
        }
        return hasRightCurve;
    }
}

