/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.model;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.model.AbstractBooleanModel;
import oracle.bali.ewt.model.ObjectModel;

public class ComparisonBooleanModel
extends AbstractBooleanModel {
    public static final int COMPARISON_EQUALS = 1;
    public static final int COMPARISON_NOT_EQUALS = -2;
    public static final int COMPARISON_GREATER_THAN = 2;
    public static final int COMPARISON_GREATER_THAN_OR_EQUALS = 3;
    public static final int COMPARISON_LESS_THAN = -4;
    public static final int COMPARISON_LESS_THAN_OR_EQUALS = -3;
    private ObjectModel _leftSideModel;
    private ObjectModel _rightSideModel;
    private Object _rightSide;
    private int _comparison;
    private transient boolean _state;

    public ComparisonBooleanModel(ObjectModel leftSideModel, ObjectModel rightSideModel, int comparison) {
        this._init(leftSideModel, rightSideModel, null, comparison);
    }

    public ComparisonBooleanModel(ObjectModel leftSideModel, Object rightSide, int comparison) {
        this._init(leftSideModel, null, rightSide, comparison);
    }

    public static ComparisonBooleanModel createExistsModel(ObjectModel existenceModel) {
        return new ComparisonBooleanModel(existenceModel, null, -2);
    }

    public boolean getState() {
        return this._state;
    }

    private void _init(ObjectModel leftSideModel, ObjectModel rightSideModel, Object rightSide, int comparison) {
        if (leftSideModel == null) {
            throw new IllegalArgumentException("Left side model required");
        }
        if (comparison < -4 || comparison > 3) {
            throw new IllegalArgumentException("Unknown comparison");
        }
        this._comparison = comparison;
        this._leftSideModel = leftSideModel;
        this._rightSideModel = rightSideModel;
        this._rightSide = rightSide;
        Changer listener = new Changer();
        this._state = this._calculateState();
        leftSideModel.addChangeListener(listener);
        if (rightSideModel != null) {
            rightSideModel.addChangeListener(listener);
        }
    }

    private boolean _calculateState() {
        boolean newResult;
        Object leftSide = this._leftSideModel.getObject();
        Object rightSide = this._rightSideModel != null ? this._rightSideModel.getObject() : this._rightSide;
        boolean isNot = false;
        int comparison = this._comparison;
        if ((comparison & 1) == 0) {
            comparison ^= 0xFFFFFFFF;
            isNot = true;
        }
        boolean bl = newResult = leftSide == rightSide || leftSide != null && leftSide.equals(rightSide);
        if (!newResult && comparison != 1) {
            if (leftSide == null || rightSide == null) {
                return false;
            }
            if (!(leftSide instanceof Number) || !(rightSide instanceof Number)) {
                throw new IllegalArgumentException("Numeric comparisons only allowed on numbers");
            }
            Number leftNumber = (Number)leftSide;
            Number rightNumber = (Number)rightSide;
            if (comparison == -3) {
                boolean bl2 = isNot = !isNot;
            }
            if (leftNumber instanceof Long) {
                newResult = leftNumber.longValue() > rightNumber.longValue();
            } else {
                boolean bl3 = newResult = leftNumber.doubleValue() > rightNumber.doubleValue();
            }
        }
        if (isNot) {
            newResult = !newResult;
        }
        return newResult;
    }

    private void _updateState() {
        boolean newState = this._calculateState();
        if (newState != this._state) {
            this._state = newState;
            this.fireStateChanged();
        }
    }

    private class Changer
    implements ChangeListener {
        private Changer() {
        }

        public void stateChanged(ChangeEvent event) {
            ComparisonBooleanModel.this._updateState();
        }
    }
}

