/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import oracle.bali.ewt.LWComponent;

public class NamelessCardLayout
implements LayoutManager2 {
    private static NamelessCardLayout _sNamelessCardLayout;

    public static final LayoutManager2 getLayoutManager() {
        if (_sNamelessCardLayout == null) {
            _sNamelessCardLayout = new NamelessCardLayout();
        }
        return _sNamelessCardLayout;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = comp.getPreferredSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height <= h) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
    }

    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = comp.getMinimumSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height <= h) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        Dimension parentSize = parent.getSize();
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            if (!comp.isVisible()) continue;
            comp.setBounds(insets.left, insets.top, parentSize.width - (insets.left + insets.right), parentSize.height - (insets.top + insets.bottom));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flipToComponent(Component component) {
        Container parent = component.getParent();
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        LWComponent lwComp = null;
        if (parent instanceof LWComponent) {
            lwComp = (LWComponent)parent;
            lwComp.freezeRepaints();
        }
        try {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int ncomponents = parent.getComponentCount();
                for (int i = 0; i < ncomponents; ++i) {
                    Component comp;
                    comp.setVisible((comp = parent.getComponent(i)) == component);
                }
            }
            parent.validate();
        }
        finally {
            if (lwComp != null) {
                lwComp.unfreezeRepaints();
            }
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    private NamelessCardLayout() {
    }
}

