/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;
import oracle.bali.ewt.graphics.ImageUtils;

public final class IconStrip {
    private Image _image;
    private transient Image _disabledImage;
    private transient boolean _loaded;
    private int _width;
    private int _height;
    int _tileWidth;
    int _tileHeight;
    private boolean _synthesizeDisabled;
    private Icon[] _icons;

    public IconStrip(Image image, int width) {
        this(image, width, 1, true);
    }

    public IconStrip(Image image, int width, boolean synthesizeDisabled) {
        this(image, width, 1, synthesizeDisabled);
    }

    public IconStrip(Image image, int width, int height) {
        this(image, width, height, true);
    }

    public IconStrip(Image image, int width, int height, boolean synthesizeDisabled) {
        if (image == null || image == ImageUtils.getNotLoadedImage()) {
            throw new IllegalArgumentException("Image not loaded");
        }
        this._image = image;
        this._width = width;
        this._height = height;
        this._icons = new Icon[width * height];
        ImageUtils.loadImage(image);
        this._tileWidth = image.getWidth(null) / width;
        this._tileHeight = image.getHeight(null) / height;
        this._synthesizeDisabled = synthesizeDisabled;
    }

    public Icon getIcon(int index) {
        return this.getIcon(index % this._width, index / this._width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon(int xIndex, int yIndex) {
        if (xIndex < 0 || xIndex >= this._width || yIndex < 0 || yIndex >= this._height) {
            throw new IllegalArgumentException();
        }
        int offset = xIndex + yIndex * this._width;
        IconStrip iconStrip = this;
        synchronized (iconStrip) {
            Icon icon = this._icons[offset];
            if (icon == null) {
                this._icons[offset] = icon = new OneIcon(xIndex, yIndex);
            }
            return icon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Image __getImage(Component c) {
        Image image = this._image;
        if (!c.isEnabled() && this._synthesizeDisabled) {
            IconStrip iconStrip = this;
            synchronized (iconStrip) {
                if (this._disabledImage == null) {
                    this._disabledImage = ImageUtils.createDisabledImage(image);
                    ImageUtils.loadImage(this._disabledImage);
                }
                image = this._disabledImage;
            }
        }
        return image;
    }

    private class OneIcon
    implements Icon {
        private int _x;
        private int _y;

        public OneIcon(int xIndex, int yIndex) {
            this._x = xIndex * IconStrip.this._tileWidth;
            this._y = yIndex * IconStrip.this._tileHeight;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            int srcX = this._x;
            int srcY = this._y;
            Image image = IconStrip.this.__getImage(c);
            g.drawImage(image, x, y, x + width, y + height, srcX, srcY, srcX + width, srcY + height, null);
        }

        public int getIconWidth() {
            return IconStrip.this._tileWidth;
        }

        public int getIconHeight() {
            return IconStrip.this._tileHeight;
        }
    }
}

