/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import oracle.bali.ewt.elaf.EWTLookAndFeel;
import oracle.bali.ewt.elaf.basic.BasicUIUtils;
import oracle.bali.ewt.graphics.IconStrip;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.share.util.IntegerUtils;

public final class IconRepository {
    public static final Object BOLD = IconRepository._addToKeySet(IntegerUtils.getInteger((int)0));
    public static final Object ITALIC = IconRepository._addToKeySet(IntegerUtils.getInteger((int)1));
    public static final Object UNDERLINE = IconRepository._addToKeySet(IntegerUtils.getInteger((int)2));
    public static final Object STRIKETHROUGH = IconRepository._addToKeySet(IntegerUtils.getInteger((int)3));
    public static final Object SUPERSCRIPT = IconRepository._addToKeySet(IntegerUtils.getInteger((int)4));
    public static final Object SUBSCRIPT = IconRepository._addToKeySet(IntegerUtils.getInteger((int)5));
    public static final Object FULL_JUSTIFY = IconRepository._addToKeySet(IntegerUtils.getInteger((int)7));
    public static final Object LEFT_JUSTIFY = IconRepository._addToKeySet(IntegerUtils.getInteger((int)8));
    public static final Object CENTER_JUSTIFY = IconRepository._addToKeySet(IntegerUtils.getInteger((int)9));
    public static final Object RIGHT_JUSTIFY = IconRepository._addToKeySet(IntegerUtils.getInteger((int)10));
    public static final Object TOP_JUSTIFY = IconRepository._addToKeySet(IntegerUtils.getInteger((int)11));
    public static final Object MIDDLE_JUSTIFY = IconRepository._addToKeySet(IntegerUtils.getInteger((int)12));
    public static final Object BOTTOM_JUSTIFY = IconRepository._addToKeySet(IntegerUtils.getInteger((int)13));
    public static final Object START_JUSTIFY = IconRepository._addToKeySet(IntegerUtils.getInteger((int)14));
    public static final Object END_JUSTIFY = IconRepository._addToKeySet(IntegerUtils.getInteger((int)15));
    public static final Object UP_ARROW = IconRepository._addToKeySet(IntegerUtils.getInteger((int)16));
    public static final Object LEFT_ARROW = IconRepository._addToKeySet(IntegerUtils.getInteger((int)17));
    public static final Object DOWN_ARROW = IconRepository._addToKeySet(IntegerUtils.getInteger((int)18));
    public static final Object RIGHT_ARROW = IconRepository._addToKeySet(IntegerUtils.getInteger((int)19));
    public static final Object SHUTTLE_LEFT_ARROW = IconRepository._addToKeySet("Shuttle.leftArrow");
    public static final Object SHUTTLE_LEFT_ALL_ARROW = IconRepository._addToKeySet("Shuttle.leftAllArrow");
    public static final Object SHUTTLE_RIGHT_ARROW = IconRepository._addToKeySet("Shuttle.rightArrow");
    public static final Object SHUTTLE_RIGHT_ALL_ARROW = IconRepository._addToKeySet("Shuttle.rightAllArrow");
    public static final Object SHUTTLE_DOWN_ARROW = IconRepository._addToKeySet("Shuttle.downArrow");
    public static final Object SHUTTLE_DOWN_ALL_ARROW = IconRepository._addToKeySet("Shuttle.downAllArrow");
    public static final Object SHUTTLE_UP_ARROW = IconRepository._addToKeySet("Shuttle.upArrow");
    public static final Object SHUTTLE_UP_ALL_ARROW = IconRepository._addToKeySet("Shuttle.upAllArrow");
    public static final Object SHUTTLE_REORDER_UP_RIGHT_ARROW = IconRepository._addToKeySet("Shuttle.reorderUpRight");
    public static final Object SHUTTLE_REORDER_DOWN_RIGHT_ARROW = IconRepository._addToKeySet("Shuttle.reorderDownRight");
    public static final Object SHUTTLE_REORDER_TOP_RIGHT_ARROW = IconRepository._addToKeySet("Shuttle.reorderTopRight");
    public static final Object SHUTTLE_REORDER_BOTTOM_RIGHT_ARROW = IconRepository._addToKeySet("Shuttle.reorderBottomRight");
    public static final Object SHUTTLE_REORDER_UP_LEFT_ARROW = IconRepository._addToKeySet("Shuttle.reorderUpLeft");
    public static final Object SHUTTLE_REORDER_DOWN_LEFT_ARROW = IconRepository._addToKeySet("Shuttle.reorderDownLeft");
    public static final Object SHUTTLE_REORDER_TOP_LEFT_ARROW = IconRepository._addToKeySet("Shuttle.reorderTopLeft");
    public static final Object SHUTTLE_REORDER_BOTTOM_LEFT_ARROW = IconRepository._addToKeySet("Shuttle.reorderBottomLeft");
    public static final Object UP_FOLDER = IconRepository._addToKeySet("FileChooser.upFolderIcon");
    public static final Object HOME_FOLDER = IconRepository._addToKeySet("FileChooser.homeFolderIcon");
    public static final Object NEW_FOLDER = IconRepository._addToKeySet("FileChooser.newFolderIcon");
    public static final Object LIST_VIEW = IconRepository._addToKeySet("FileChooser.listViewIcon");
    public static final Object DETAILS_VIEW = IconRepository._addToKeySet("FileChooser.detailsViewIcon");
    public static final Object DIRECTORY = IconRepository._addToKeySet("FileView.directoryIcon");
    public static final Object COMPUTER = IconRepository._addToKeySet("FileView.computerIcon");
    public static final Object FILE = IconRepository._addToKeySet("FileView.fileIcon");
    public static final Object HARDDRIVE = IconRepository._addToKeySet("FileView.hardDriveIcon");
    public static final Object FLOPPYDRIVE = IconRepository._addToKeySet("FileView.floppyDriveIcon");
    public static final Object OPEN_FOLDER = IconRepository._addToKeySet(IntegerUtils.getInteger((int)20));
    public static final Object CDDRIVE = IconRepository._addToKeySet(IntegerUtils.getInteger((int)21));
    public static final Object TREE_EXPANED = IconRepository._addToKeySet("Tree.expandedIcon");
    public static final Object TREE_COLLAPSED = IconRepository._addToKeySet("Tree.collapsedIcon");
    public static final Object ERROR = IconRepository._addToKeySet("OptionPane.errorIcon");
    public static final Object INFORM = IconRepository._addToKeySet("OptionPane.informationIcon");
    public static final Object QUESTION = IconRepository._addToKeySet("OptionPane.questionIcon");
    public static final Object WARN = IconRepository._addToKeySet("OptionPane.warningIcon");
    private static final int _FONT_ICONS_START = 0;
    private static final int _FONT_ICONS_END = 15;
    private static final int _ARROW_ICONS_START = 16;
    private static final int _ARROW_ICONS_END = 19;
    private static final int _FILE_ICONS_START = 20;
    private static final int _FILE_ICONS_END = 21;
    private static final int _FILE_ICONS_COUNT = 15;
    private static final int[] _FILE_ICONS = new int[]{6, 14};
    private static Set _keySet;
    private static Map _sIconCache;
    private static Map _sLAFIconCache;
    private static IconStrip _sFontIconStrip;
    private static IconStrip _sFileIconStrip;

    public static final Icon getIcon(Object key) {
        if (key == null) {
            return null;
        }
        if (_keySet.contains(key)) {
            if (key instanceof Integer) {
                int i = (Integer)key;
                if (i >= 0 && i <= 15) {
                    return IconRepository._getFontIcon(i);
                }
                if (i >= 16 && i <= 19) {
                    return IconRepository._getArrowIcon((Integer)key);
                }
                if (i >= 20 && i <= 21) {
                    return IconRepository._getFileIcons(i);
                }
            } else if (key instanceof String) {
                String s = key.toString();
                if (s.startsWith("Shuttle.")) {
                    return IconRepository._getShuttleIcons(s);
                }
                return UIManager.getIcon(s);
            }
        }
        Icon icon = null;
        if (_sIconCache != null) {
            icon = (Icon)_sIconCache.get(key);
        }
        if (icon == null) {
            icon = UIManager.getIcon(key);
        }
        return icon;
    }

    public static final void putIcon(Object key, Icon icon) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (icon == null) {
            throw new IllegalArgumentException("Icon cannot be null");
        }
        if (_keySet.contains(key) || _sIconCache != null && _sIconCache.containsKey(key)) {
            throw new IllegalArgumentException("Icon for the \"" + key + "\" " + "is already present");
        }
        Map map = IconRepository._getIconCache();
        map.put(key, icon);
    }

    private static Icon _getFontIcon(int index) {
        if (_sFontIconStrip == null) {
            Image im = ImageUtils.getImageResource(IconRepository.class, "/oracle/bali/ewt/chooser/font/icons/fontstrip.gif");
            _sFontIconStrip = new IconStrip(im, 16, false);
        }
        return _sFontIconStrip.getIcon(index);
    }

    private static Icon _getArrowIcon(Integer key) {
        Map map = IconRepository._getIconCache();
        Icon icon = (Icon)map.get(key);
        if (icon == null) {
            int i = key - 15;
            icon = new ImageIcon(BasicUIUtils.getArrow(i));
            map.put(key, icon);
        }
        return icon;
    }

    private static Icon _getShuttleIcons(String key) {
        Map map = IconRepository._getLAFIconCache();
        Icon icon = (Icon)map.get(key);
        if (icon == null) {
            try {
                EWTLookAndFeel.installEWTLookAndFeel();
                Object im = UIManager.get(key);
                if (im instanceof Image) {
                    if ("Oracle Look and Feel version 2".equals(UIManager.getLookAndFeel().getName())) {
                        icon = new ImageIcon((Image)im);
                    } else {
                        IconStrip strip = new IconStrip((Image)im, 1, 2, false);
                        icon = strip.getIcon(0, 0);
                    }
                    map.put(key, icon);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return icon;
    }

    private static Icon _getFileIcons(int i) {
        int index = _FILE_ICONS[i - 20];
        if (_sFileIconStrip == null) {
            Image image = ImageUtils.getImageResource(IconRepository.class, "/oracle/bali/ewt/olaf/icons/fileStrip.gif");
            _sFileIconStrip = new IconStrip(image, 15, false);
        }
        return _sFileIconStrip.getIcon(index);
    }

    private static Map _getLAFIconCache() {
        if (_sLAFIconCache == null) {
            _sLAFIconCache = new HashMap(1);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent pe) {
                    if ("lookAndFeel".equals(pe.getPropertyName())) {
                        _sLAFIconCache.clear();
                    }
                }
            });
        }
        return _sLAFIconCache;
    }

    private static Map _getIconCache() {
        if (_sIconCache == null) {
            _sIconCache = new HashMap(1);
        }
        return _sIconCache;
    }

    private static Object _addToKeySet(Object key) {
        if (_keySet == null) {
            _keySet = new HashSet(54);
        }
        _keySet.add(key);
        return key;
    }

    private IconRepository() {
    }
}

