/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.geometry;

import oracle.bali.ewt.geometry.AbstractGeometryManager;
import oracle.bali.share.collection.Range;

public class GeneralGeometryManager
extends AbstractGeometryManager {
    private int[] _itemPositions;
    private int[] _itemSizes;
    private int[] _modelToVisible;
    private int[] _visibleToModel;
    private boolean[] _notResizable;
    private int[] _minimumSizes;
    private int[] _maximumSizes;
    private int _items = 0;
    private int _visibleItems = 0;
    private int _itemSize;
    private int _defaultSize;
    private int _defaultMinimumSize = 20;
    private int _defaultMaximumSize = Integer.MAX_VALUE;
    private int _separatorSize;
    private boolean _needsLayout = true;
    private boolean _layingOut;
    private boolean _isDynamic = false;

    public void resetAll(int items) {
        this._items = items;
        this._visibleItems = items;
        this._needsLayout = true;
        this._itemPositions = null;
        this._itemSizes = null;
        this._modelToVisible = null;
        this._visibleToModel = null;
        this._notResizable = null;
        this._minimumSizes = null;
        this._maximumSizes = null;
        this.fireGeometryEvent(2001, -1, -1);
    }

    public int getItemPosition(int index) {
        this.layout();
        if (this._itemPositions == null) {
            if (this._defaultSize == 0) {
                return 0;
            }
            int temp = index * (this._defaultSize + this._separatorSize);
            return temp;
        }
        return this._itemPositions[index];
    }

    public int getItemAt(int location) {
        this.layout();
        if (location > this._itemSize || location < 0) {
            return -1;
        }
        if (this._itemPositions == null) {
            int size = this._defaultSize + this._separatorSize;
            if (size == 0) {
                return -1;
            }
            int index = location / size;
            if (index < this._items) {
                return index;
            }
            return this._items - 1;
        }
        int sepSize = this._separatorSize;
        for (int i = 0; i < this._items; ++i) {
            int index = this.visibleIndexToIndex(i);
            if (!this.isItemVisible(index)) continue;
            int pos = this._itemPositions[index];
            int size = this.getItemSize(index);
            if (location < pos || location >= pos + size + sepSize) continue;
            return index;
        }
        return -1;
    }

    public void setTotalSize(int size) {
    }

    public int getTotalSize() {
        this.layout();
        return this._itemSize;
    }

    public void setDefaultItemSize(int size) {
        this._defaultSize = size;
        this._needsLayout = true;
        this.fireGeometryEvent(2007, -1, size);
    }

    public int getDefaultItemSize() {
        return this._defaultSize;
    }

    public void itemsAdded(int startIndex, int numberOfItems) {
        int i;
        if (this._itemPositions != null) {
            this._itemPositions = this._addToArray(this._itemPositions, startIndex, numberOfItems);
        }
        if (this._itemSizes != null) {
            this._itemSizes = this._addToArray(this._itemSizes, startIndex, numberOfItems);
            for (i = startIndex; i < startIndex + numberOfItems; ++i) {
                this._itemSizes[i] = -1;
            }
        }
        if (this._modelToVisible != null) {
            this._modelToVisible = null;
            this._visibleToModel = null;
        }
        if (this._minimumSizes != null) {
            this._minimumSizes = this._addToArray(this._minimumSizes, startIndex, numberOfItems);
            for (i = startIndex; i < startIndex + numberOfItems; ++i) {
                this._minimumSizes[i] = -1;
            }
        }
        if (this._maximumSizes != null) {
            this._maximumSizes = this._addToArray(this._maximumSizes, startIndex, numberOfItems);
            for (i = startIndex; i < startIndex + numberOfItems; ++i) {
                this._maximumSizes[i] = -1;
            }
        }
        if (this._notResizable != null) {
            this._notResizable = this._addToArray(this._notResizable, startIndex, numberOfItems);
        }
        this._items += numberOfItems;
        this._visibleItems += numberOfItems;
        this._needsLayout = true;
    }

    public void itemsRemoved(int startIndex, int numberOfItems) {
        if (this._itemPositions != null) {
            this._itemPositions = this._removeFromArray(this._itemPositions, startIndex, numberOfItems);
        }
        if (this._itemSizes != null) {
            this._itemSizes = this._removeFromArray(this._itemSizes, startIndex, numberOfItems);
        }
        if (this._minimumSizes != null) {
            this._minimumSizes = this._removeFromArray(this._minimumSizes, startIndex, numberOfItems);
        }
        if (this._maximumSizes != null) {
            this._maximumSizes = this._removeFromArray(this._maximumSizes, startIndex, numberOfItems);
        }
        if (this._notResizable != null) {
            this._notResizable = this._removeFromArray(this._notResizable, startIndex, numberOfItems);
        }
        this._items -= numberOfItems;
        this._visibleItems = 0;
        for (int i = 0; i < this._items; ++i) {
            if (!this.isItemVisible(i)) continue;
            ++this._visibleItems;
        }
        if (this._modelToVisible != null) {
            this._modelToVisible = null;
            this._visibleToModel = null;
        }
        this._needsLayout = true;
    }

    public void setItemVisible(int index, boolean visible) {
        this.layout();
        if (this.isItemVisible(index) == visible) {
            return;
        }
        if (this._itemPositions == null) {
            this._createItemPositions();
        }
        if (!visible) {
            this._itemPositions[index] = -1;
            --this._visibleItems;
        } else {
            this._itemPositions[index] = 0;
            ++this._visibleItems;
        }
        this._needsLayout = true;
        this.fireGeometryEvent(2003, index, visible ? 1 : 0);
    }

    public boolean isItemVisible(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            return false;
        }
        this.layout();
        if (this._itemPositions == null) {
            return true;
        }
        return this._itemPositions[index] != -1;
    }

    public void setItemVisibleIndex(int modelIndex, int visibleIndex) {
        int start;
        int oldIndex;
        this.layout();
        if (this._visibleToModel == null) {
            if (modelIndex == visibleIndex) {
                return;
            }
            this._visibleToModel = new int[this._items];
            this._modelToVisible = new int[this._items];
            for (int i = 0; i < this._items; ++i) {
                this._visibleToModel[i] = i;
                this._modelToVisible[i] = i;
            }
            if (this._itemPositions == null) {
                this._createItemPositions();
            }
        }
        if ((oldIndex = this._modelToVisible[modelIndex]) == visibleIndex) {
            return;
        }
        if (oldIndex > visibleIndex) {
            start = visibleIndex;
            int length = oldIndex - start;
            System.arraycopy(this._visibleToModel, start, this._visibleToModel, start + 1, length);
        } else {
            start = oldIndex + 1;
            int length = visibleIndex - oldIndex;
            System.arraycopy(this._visibleToModel, start, this._visibleToModel, start - 1, length);
        }
        this._visibleToModel[visibleIndex] = modelIndex;
        this._updateModelToVisible();
        this._needsLayout = true;
        this.fireGeometryEvent(2004, modelIndex, visibleIndex);
    }

    public void setItemSize(int index, int size) {
        size = this._constrainSize(index, size);
        if (this.isResizing() && this.getItemSize(index) == size) {
            return;
        }
        this.layout();
        if (this._itemSizes == null && size == -1) {
            return;
        }
        if (this._itemSizes == null) {
            this._createItemSizes();
        }
        if (index >= 0 && index < this._items) {
            this._itemSizes[index] = size;
        }
        this._needsLayout = true;
        if (this.isDynamic() || !this.isResizing()) {
            this.fireGeometryEvent(2005, index, size);
        }
    }

    public int getItemSize(int index) {
        this.layout();
        if (this._itemSizes == null) {
            return this._defaultSize;
        }
        if (index < 0 || index >= this._items) {
            return -1;
        }
        int size = this._itemSizes[index];
        return size == -1 ? this._defaultSize : size;
    }

    public int getSeparatorSize() {
        return this._separatorSize;
    }

    public void setSeparatorSize(int size) {
        if (this._separatorSize != size) {
            this._separatorSize = size;
            this._needsLayout = true;
            this.fireGeometryEvent(2006, -1, size);
        }
    }

    public int getVisibleItemCount() {
        return this._visibleItems;
    }

    public int getItemVisibleIndex(int modelIndex) {
        if (this._modelToVisible == null) {
            return modelIndex;
        }
        return this._modelToVisible[modelIndex];
    }

    public int visibleIndexToIndex(int visibleIndex) {
        if (this._visibleToModel == null) {
            return visibleIndex;
        }
        return this._visibleToModel[visibleIndex];
    }

    public Range[] visibleRangesToRanges(Range[] visibleRanges) {
        if (this._visibleToModel == null) {
            return visibleRanges;
        }
        return super.visibleRangesToRanges(visibleRanges);
    }

    public Range[] rangesToVisibleRanges(Range[] modelRanges) {
        if (this._modelToVisible == null) {
            return modelRanges;
        }
        return super.rangesToVisibleRanges(modelRanges);
    }

    public void setItemResizable(int modelIndex, boolean yn) {
        if (this._notResizable == null && yn) {
            return;
        }
        if (this._notResizable == null) {
            this._notResizable = new boolean[this.getItemCount()];
        }
        this._notResizable[modelIndex] = !yn;
    }

    public boolean isItemResizable(int modelIndex) {
        return this._notResizable == null || !this._notResizable[modelIndex];
    }

    public void setDefaultMinimumItemSize(int minSize) {
        this._defaultMinimumSize = minSize;
    }

    public int getDefaultMinimumItemSize() {
        return this._defaultMinimumSize;
    }

    public void setMinimumItemSize(int modelIndex, int minSize) {
        if (this._minimumSizes != null || minSize != this.getDefaultMinimumItemSize()) {
            int maxSize;
            int count = this.getItemCount();
            if (this._minimumSizes == null) {
                this._minimumSizes = new int[count];
                for (int i = 0; i < count; ++i) {
                    this._minimumSizes[i] = -1;
                }
            }
            this._minimumSizes[modelIndex] = minSize;
            int itemSize = this.getItemSize(modelIndex);
            if (minSize > itemSize) {
                this.setItemSize(modelIndex, minSize);
            }
            if (minSize > (maxSize = this.getMaximumItemSize(modelIndex))) {
                this.setMaximumItemSize(modelIndex, minSize);
            }
        }
    }

    public int getMinimumItemSize(int modelIndex) {
        int result;
        int n = result = this._minimumSizes != null ? this._minimumSizes[modelIndex] : -1;
        if (result == -1) {
            result = this.getDefaultMinimumItemSize();
        }
        return result;
    }

    public void setDefaultMaximumItemSize(int maxSize) {
        this._defaultMaximumSize = maxSize;
    }

    public int getDefaultMaximumItemSize() {
        return this._defaultMaximumSize;
    }

    public void setMaximumItemSize(int modelIndex, int maxSize) {
        if (this._maximumSizes != null || maxSize != this.getDefaultMaximumItemSize()) {
            int minSize;
            int count = this.getItemCount();
            if (this._maximumSizes == null) {
                this._maximumSizes = new int[count];
                for (int i = 0; i < count; ++i) {
                    this._maximumSizes[i] = -1;
                }
            }
            this._maximumSizes[modelIndex] = maxSize;
            int itemSize = this.getItemSize(modelIndex);
            if (maxSize < itemSize) {
                this.setItemSize(modelIndex, maxSize);
            }
            if (maxSize < (minSize = this.getMinimumItemSize(modelIndex))) {
                this.setMinimumItemSize(modelIndex, maxSize);
            }
        }
    }

    public int getMaximumItemSize(int modelIndex) {
        int result;
        int n = result = this._maximumSizes != null ? this._maximumSizes[modelIndex] : -1;
        if (result == -1) {
            result = this.getDefaultMaximumItemSize();
        }
        return result;
    }

    public boolean isDynamic() {
        return this._isDynamic;
    }

    public void setDynamic(boolean yn) {
        this._isDynamic = yn;
    }

    private int[] _addToArray(int[] src, int start, int number) {
        int length = src.length;
        int[] dst = new int[length + number];
        if (start != 0) {
            System.arraycopy(src, 0, dst, 0, start);
        }
        if (start != length) {
            System.arraycopy(src, start, dst, start + number, length - start);
        }
        return dst;
    }

    private int[] _removeFromArray(int[] src, int start, int number) {
        int length = src.length;
        int[] dst = new int[length - number];
        if (start != 0) {
            System.arraycopy(src, 0, dst, 0, start);
        }
        if (length - number != start) {
            System.arraycopy(src, start + number, dst, start, length - (start + number));
        }
        return dst;
    }

    private boolean[] _addToArray(boolean[] src, int start, int number) {
        int length = src.length;
        boolean[] dst = new boolean[length + number];
        if (start != 0) {
            System.arraycopy(src, 0, dst, 0, start);
        }
        if (start != length) {
            System.arraycopy(src, start, dst, start + number, length - start);
        }
        return dst;
    }

    private boolean[] _removeFromArray(boolean[] src, int start, int number) {
        int length = src.length;
        boolean[] dst = new boolean[length - number];
        if (start != 0) {
            System.arraycopy(src, 0, dst, 0, start);
        }
        if (length - number != start) {
            System.arraycopy(src, start + number, dst, start, length - (start + number));
        }
        return dst;
    }

    private void _updateModelToVisible() {
        for (int i = 0; i < this._items; ++i) {
            int dsi = this._visibleToModel[i];
            if (dsi < 0) continue;
            this._modelToVisible[dsi] = i;
        }
    }

    private void _createItemSizes() {
        this._itemSizes = new int[this._items];
        for (int i = 0; i < this._items; ++i) {
            this._itemSizes[i] = -1;
        }
    }

    private void _createItemPositions() {
        this._itemPositions = new int[this._items];
    }

    protected void layout() {
        if (this._needsLayout && !this._layingOut) {
            this._layingOut = true;
            int result = 0;
            if (this._itemSizes == null && this._itemPositions == null) {
                result = this._defaultSize == 0 ? 0 : (this._defaultSize + this._separatorSize) * this._visibleItems;
            } else {
                if (this._itemPositions == null) {
                    this._createItemPositions();
                }
                int size = 0;
                int sSize = this._separatorSize;
                for (int i = 0; i < this._items; ++i) {
                    int index = this.visibleIndexToIndex(i);
                    if (!this.isItemVisible(index)) {
                        this._itemPositions[index] = -1;
                        continue;
                    }
                    this._itemPositions[index] = size;
                    size += this.getItemSize(index);
                    size += sSize;
                }
                result = size;
            }
            this._itemSize = result;
            this._layingOut = false;
            this._needsLayout = false;
        }
    }

    public int getItemCount() {
        return this._items;
    }

    private int _constrainSize(int index, int size) {
        if (size == -1) {
            return size;
        }
        int min = this.getMinimumItemSize(index);
        int max = this.getMaximumItemSize(index);
        if (size < min) {
            return min;
        }
        if (size > max) {
            return max;
        }
        return size;
    }
}

