/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

class OracleGridBorderPainter
extends AbstractBorderPainter {
    private boolean _upperLeft;
    private boolean _upperRight;
    private boolean _lowerLeft;
    private boolean _lowerRight;
    private boolean _drawBottom;
    private boolean _drawRight;
    private static final ImmInsets[] _sInsetsArr = new ImmInsets[]{new ImmInsets(1, 1, 0, 0), new ImmInsets(1, 1, 0, 1), new ImmInsets(1, 1, 1, 0), new ImmInsets(1, 1, 1, 1)};

    public OracleGridBorderPainter() {
        this(true, true, true, true, true, true);
    }

    public OracleGridBorderPainter(boolean upperLeftCurved, boolean upperRightCurved, boolean lowerLeftCurved, boolean lowerRightCurved, boolean drawBottom, boolean drawRight) {
        this._upperLeft = upperLeftCurved;
        this._upperRight = upperRightCurved;
        this._lowerLeft = lowerLeftCurved;
        this._lowerRight = lowerRightCurved;
        this._drawBottom = drawBottom;
        this._drawRight = drawRight;
    }

    protected boolean isBorderTransparent(PaintContext context) {
        return false;
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        int insetsIndex = 0;
        if (this._drawRight) {
            insetsIndex += 2;
        }
        if (this._drawBottom) {
            ++insetsIndex;
        }
        return _sInsetsArr[insetsIndex];
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        boolean inactive;
        Color savedColor = g.getColor();
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color dark = defaults.getColor("darkIntensity");
        Color highlight = defaults.getColor("controlHighlight");
        Color shadow = defaults.getColor("controlShadow");
        Color darkShadow = defaults.getColor("controlShadowDark");
        boolean bl = inactive = (state & 4) != 0;
        if (!inactive) {
            g.setColor(dark);
            g.drawLine(x, y, right, y);
            g.drawLine(x, y, x, bottom);
            if (this._drawRight) {
                g.setColor(highlight);
                g.drawLine(right, y, right, bottom);
            }
            if (this._drawBottom) {
                g.setColor(highlight);
                g.drawLine(x, bottom, right, bottom);
            }
            if (this._upperRight) {
                g.setColor(shadow);
                g.drawLine(right - 1, y, right - 1, y);
                g.drawLine(right, y, right, y + 3);
                g.setColor(dark);
                g.drawLine(right - 1, y + 1, right - 1, y + 1);
            }
            if (this._lowerLeft) {
                g.setColor(shadow);
                g.drawLine(x, bottom - 1, x, bottom - 1);
                g.drawLine(x, bottom, x + 3, bottom);
                g.setColor(dark);
                g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
            }
            if (this._upperLeft) {
                g.setColor(darkShadow);
                g.drawLine(x, y, x, y + 1);
                g.drawLine(x + 1, y, x + 1, y);
                g.setColor(dark);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
            }
            if (this._lowerRight) {
                g.setColor(Color.white);
                g.drawLine(right, bottom, right - 1, bottom);
                g.drawLine(right, bottom - 1, right, bottom - 1);
                g.setColor(highlight);
                g.drawLine(right - 1, bottom - 1, right - 1, bottom - 1);
            }
        } else if ((state & 1) != 0) {
            if (this._upperLeft) {
                g.setColor(darkShadow);
                g.drawLine(x, y, x, y + 1);
                g.drawLine(x + 1, y, x + 1, y);
                if (!inactive) {
                    g.setColor(dark);
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                }
            }
            if (this._lowerLeft) {
                g.setColor(defaults.getColor("lightIntensity"));
                g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
                if (inactive) {
                    g.setColor(darkShadow);
                    g.drawLine(x, bottom - 1, x, bottom);
                    g.drawLine(x + 1, bottom, x + 1, bottom);
                }
            }
            if (this._upperRight) {
                g.setColor(defaults.getColor("lightIntensity"));
                g.drawLine(right - 1, y + 1, right - 1, y + 1);
                if (inactive) {
                    g.setColor(darkShadow);
                    g.drawLine(right - 1, y, right, y);
                    g.drawLine(right, y + 1, right, y + 1);
                }
            }
            if (this._lowerRight) {
                g.setColor(darkShadow);
                g.drawLine(right, bottom, right - 1, bottom);
                g.drawLine(right, bottom - 1, right, bottom - 1);
                if (!inactive) {
                    g.setColor(dark);
                    g.drawLine(right - 1, bottom - 1, right - 1, bottom - 1);
                }
            }
        } else {
            g.setColor(darkShadow);
            if (this._upperLeft) {
                g.drawLine(x, y, x, y + 1);
                g.drawLine(x + 1, y, x + 1, y);
            }
            if (this._lowerLeft) {
                g.drawLine(x, bottom - 1, x, bottom);
                g.drawLine(x + 1, bottom, x + 1, bottom);
            }
            if (this._upperRight) {
                g.drawLine(right - 1, y, right, y);
                g.drawLine(right, y + 1, right, y + 1);
            }
            if (this._lowerRight) {
                g.drawLine(right, bottom, right - 1, bottom);
                g.drawLine(right, bottom - 1, right, bottom - 1);
            }
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }
}

