/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.sql.CallableStatement;
import oracle.jdevimpl.debugger.probe.DebugProbe;

final class DebugProbeRuntimeInfo {
    DebugProbe dp;
    private boolean oerSupported;
    private String info_request;
    int reason;
    int breakpoint;
    int oer;
    int stackDepth;
    int lineNumber;
    static final int reason_none = 0;
    static final int reason_interpreter_starting = 2;
    static final int reason_breakpoint = 3;
    static final int reason_enter = 6;
    static final int reason_return = 7;
    static final int reason_finish = 8;
    static final int reason_line = 9;
    static final int reason_interrupt = 10;
    static final int reason_exception = 11;
    static final int reason_exit = 15;
    static final int reason_handler = 16;
    static final int reason_timeout = 17;
    static final int reason_instantiate = 20;
    static final int reason_abort = 21;
    static final int reason_knl_exit = 25;
    static final int reason_oer_breakpoint = 26;

    DebugProbeRuntimeInfo(DebugProbe dp) {
        this.dp = dp;
        this.oerSupported = dp.checkVersion(2, 4);
    }

    String info_request() {
        if (this.info_request == null) {
            this.info_request = "DBMS_DEBUG.info_getStackDepth + DBMS_DEBUG.info_getBreakpoint";
            if (this.oerSupported) {
                this.info_request = this.info_request + " + DBMS_DEBUG.info_getOerInfo";
            }
        }
        return this.info_request;
    }

    String code(String varName) {
        StringBuffer sb = new StringBuffer();
        sb.append("  ? := " + varName + ".Reason;\n");
        sb.append("  ? := " + varName + ".Breakpoint;\n");
        if (this.oerSupported) {
            sb.append("  ? := " + varName + ".oer;\n");
        }
        sb.append("  ? := " + varName + ".StackDepth;\n");
        sb.append("  ? := " + varName + ".Line#;\n");
        return sb.toString();
    }

    int registerParameters(CallableStatement cs, int index) throws Exception {
        cs.registerOutParameter(index++, 4);
        cs.registerOutParameter(index++, 4);
        if (this.oerSupported) {
            cs.registerOutParameter(index++, 4);
        }
        cs.registerOutParameter(index++, 4);
        cs.registerOutParameter(index++, 4);
        return index;
    }

    int getParameters(CallableStatement cs, int index) throws Exception {
        this.reason = cs.getInt(index++);
        this.breakpoint = cs.getInt(index++);
        if (this.oerSupported) {
            this.oer = cs.getInt(index++);
        }
        this.stackDepth = cs.getInt(index++);
        this.lineNumber = cs.getInt(index++);
        return index;
    }

    String dump(String margin, String runtimeInfoName) {
        StringBuffer sb = new StringBuffer();
        sb.append(margin);
        sb.append(runtimeInfoName);
        sb.append("\n");
        sb.append(margin);
        sb.append("  reason:     ");
        sb.append(this.getReason());
        sb.append("\n");
        sb.append(margin);
        sb.append("  breakpoint: ");
        sb.append(this.breakpoint);
        sb.append("\n");
        if (this.oerSupported) {
            sb.append(margin);
        }
        sb.append("  oer:        ");
        sb.append(this.oer);
        sb.append("\n");
        sb.append(margin);
        sb.append("  stackDepth: ");
        sb.append(this.stackDepth);
        sb.append("\n");
        sb.append(margin);
        sb.append("  lineNumber: ");
        sb.append(this.lineNumber);
        sb.append("\n");
        return sb.toString();
    }

    private String getReason() {
        switch (this.reason) {
            default: {
                return Integer.toString(this.reason);
            }
            case 0: {
                return "reason_none";
            }
            case 2: {
                return "reason_interpreter_starting";
            }
            case 3: {
                return "reason_breakpoint";
            }
            case 6: {
                return "reason_enter";
            }
            case 7: {
                return "reason_return";
            }
            case 8: {
                return "reason_finish";
            }
            case 9: {
                return "reason_line";
            }
            case 10: {
                return "reason_interrupt";
            }
            case 11: {
                return "reason_exception";
            }
            case 15: {
                return "reason_exit";
            }
            case 16: {
                return "reason_handler";
            }
            case 17: {
                return "reason_timeout";
            }
            case 20: {
                return "reason_instantiate";
            }
            case 21: {
                return "reason_abort";
            }
            case 25: 
        }
        return "reason_knl_exit";
    }

    boolean isOerSupported() {
        return this.oerSupported;
    }

    int getSQLCode() {
        if (this.oer == 1403) {
            return 100;
        }
        return -this.oer;
    }
}

