/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo.prop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.model.ColorProvider;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithHint;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.LabelTableCellRenderer;
import oracle.javatools.ui.table.SimpleTableFormat;
import oracle.javatools.ui.table.SimpleTableModel;
import oracle.jdeveloper.todo.TaskPriority;
import oracle.jdeveloper.todo.TaskTag;
import oracle.jdevimpl.todo.SourceTodoArb;

public class TaskTagPrefsPanel
extends DefaultTraversablePanel {
    private static final String ADD_TAG_KEY = "add-tag";
    private static final String DELETE_TAG_KEY = "delete-tag";
    private static final String CONFIRM_DEL_TAG_ID = TaskTagPrefsPanel.class.getName() + ".deleteTag";
    private GenericTable tagTable;
    private JButton addTagButton;
    private JButton removeTagButton;
    private SimpleTableModel<TaskTag> tagTableModel;

    public TaskTagPrefsPanel() {
        this.initUI();
    }

    public void onEntry(TraversableContext dataContext) {
        super.onEntry(dataContext);
        this.loadData();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        super.onExit(dataContext);
        this.saveData();
    }

    private void initUI() {
        TaskTagPrefsPanel panel = this;
        ((Container)((Object)panel)).setLayout((LayoutManager)new MigLayout("insets 0, fill"));
        this.tagTable = this.createTagTable();
        ControlBar controlBar = new ControlBar();
        this.configureControls(controlBar);
        JScrollPane scrollPane = new JScrollPane((Component)this.tagTable);
        scrollPane.setOpaque(false);
        JLabel tagTableLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)tagTableLabel, (Component)scrollPane, (String)SourceTodoArb.get("OPTIONS_PANEL_TAG_TABLE_LABEL"));
        ComponentWithTitlebar titledComp = new ComponentWithTitlebar((JComponent)scrollPane, tagTableLabel, controlBar);
        ComponentWithHint hintedComp = new ComponentWithHint((Component)titledComp, SourceTodoArb.get("TAGS_PREFS_HINT"));
        ((Container)((Object)panel)).add((Component)hintedComp, "grow");
        this.setHelpID("f1_idedsettasks_html");
    }

    private GenericTable createTagTable() {
        final GenericTable table = new GenericTable();
        table.setColumnSelectorAvailable(false);
        table.setColumnHeaderSelectionEnabled(false);
        table.setSelectionMode(0);
        table.autoSizeColumnsToFit();
        this.tagTableModel = new SimpleTableModel((SimpleTableFormat)new TagTableFormat());
        table.setModel(this.tagTableModel);
        table.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new StringCellRenderer(this.tagTableModel)));
        table.setDefaultRenderer(TaskPriority.class, (TableCellRenderer)((Object)new PriorityCellRenderer(this.tagTableModel)));
        JComboBox<TaskPriority> priorityBox = new JComboBox<TaskPriority>(TaskPriority.values());
        priorityBox.setRenderer(new PriorityListCellRenderer());
        table.setDefaultEditor(TaskPriority.class, (TableCellEditor)new DefaultCellEditor(priorityBox));
        final ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (null != TaskTagPrefsPanel.this.removeTagButton) {
                    if (selectionModel.isSelectionEmpty()) {
                        TaskTagPrefsPanel.this.removeTagButton.setEnabled(false);
                    } else {
                        int row = table.getSelectedRowInModel();
                        if (((TaskTag)TaskTagPrefsPanel.this.tagTableModel.getRow(row)).isUserDefined()) {
                            TaskTagPrefsPanel.this.removeTagButton.setEnabled(true);
                        } else {
                            TaskTagPrefsPanel.this.removeTagButton.setEnabled(false);
                        }
                    }
                }
            }
        });
        table.getActionMap().put(ADD_TAG_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskTagPrefsPanel.this.addTagButtonPressed(e);
            }
        });
        table.getInputMap().put(KeyStroke.getKeyStroke(78, 128), ADD_TAG_KEY);
        table.getActionMap().put(DELETE_TAG_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TaskTagPrefsPanel.this.removeTagButton.isEnabled()) {
                    TaskTagPrefsPanel.this.removeTagButtonPressed(e);
                }
            }
        });
        table.getInputMap().put(KeyStroke.getKeyStroke(127, 0), DELETE_TAG_KEY);
        table.getInputMap().put(KeyStroke.getKeyStroke(8, 0), DELETE_TAG_KEY);
        table.setRolloverHighlightingEnabled(false);
        return table;
    }

    private void configureControls(ControlBar bar) {
        String label = SourceTodoArb.get("ADD_TAG_BUTTON");
        int mnemonic = StringUtils.getMnemonicKeyCode((String)label);
        label = StringUtils.stripMnemonic((String)label);
        this.addTagButton = new JButton();
        this.addTagButton.setToolTipText(label);
        this.addTagButton.setMnemonic(mnemonic);
        this.addTagButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.addTagButton.getAccessibleContext().setAccessibleName(SourceTodoArb.get("ADD_TAG_BUTTON_ADA_TEXT"));
        this.addTagButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskTagPrefsPanel.this.addTagButtonPressed(e);
            }
        });
        bar.add((Component)this.addTagButton);
        label = SourceTodoArb.get("REMOVE_TAG_BUTTON");
        mnemonic = StringUtils.getMnemonicKeyCode((String)label);
        label = StringUtils.stripMnemonic((String)label);
        this.removeTagButton = new JButton();
        this.removeTagButton.setEnabled(false);
        this.removeTagButton.setToolTipText(label);
        this.removeTagButton.setMnemonic(mnemonic);
        this.removeTagButton.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.removeTagButton.getAccessibleContext().setAccessibleName(SourceTodoArb.get("REMOVE_TAG_BUTTON_ADA_TEXT"));
        this.removeTagButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskTagPrefsPanel.this.removeTagButtonPressed(e);
            }
        });
        bar.add((Component)this.removeTagButton);
    }

    private void addTagButtonPressed(ActionEvent e) {
        TaskTag tag = TaskTag.Factory.newTag(SourceTodoArb.get("DEFAULT_TAG_NAME"), SourceTodoArb.get("DEFAULT_TAG_SEARCH_STRING"), TaskPriority.NORMAL);
        this.tagTableModel.asList().add(tag);
        this.tagTable.repaint();
    }

    private void removeTagButtonPressed(ActionEvent e) {
        String message = SourceTodoArb.get("DELETE_TAG_MESSAGE");
        String title = SourceTodoArb.get("DELETE_TAG_TITLE");
        String helpTopic = null;
        boolean confirmed = MessageDialog.optionalConfirm((String)CONFIRM_DEL_TAG_ID, (Component)Ide.getMainWindow(), (Object)message, (String)title, helpTopic);
        if (!confirmed) {
            return;
        }
        int row = this.tagTable.getSelectedRowInModel();
        this.tagTableModel.asList().remove(row);
        this.tagTable.repaint();
        this.tagTable.setSelectedRowInModel(Math.min(row, this.tagTable.getRowCount() - 1));
    }

    private void loadData() {
        List<TaskTag> taskTags = TaskTagPrefsPanel.copyOf(TaskTag.Factory.getTaskTags());
        this.tagTableModel.asList().clear();
        this.tagTableModel.asList().addAll(taskTags);
    }

    private void saveData() {
        ArrayList<TaskTag> tagsToBeSaved = new ArrayList<TaskTag>();
        for (TaskTag tag : this.tagTableModel.asList()) {
            if (!tag.isUserDefined() && tag.enabled()) continue;
            tagsToBeSaved.add(tag);
        }
        TaskTag.Factory.setPreferredTags(tagsToBeSaved);
    }

    private static TaskTag copyOf(TaskTag tag) {
        if (null == tag) {
            return null;
        }
        HashStructure tagHash = (HashStructure)AdapterManager.Factory.getAdapterManager().adapt((Object)tag, HashStructure.class);
        if (null == tagHash) {
            return null;
        }
        return (TaskTag)AdapterManager.Factory.getAdapterManager().adapt((Object)tagHash.copyTo(null), TaskTag.class);
    }

    private static List<TaskTag> copyOf(List<TaskTag> tags) {
        ArrayList<TaskTag> copies = new ArrayList<TaskTag>();
        for (TaskTag tag : tags) {
            copies.add(TaskTagPrefsPanel.copyOf(tag));
        }
        return copies;
    }

    private static class PriorityListCellRenderer
    extends DefaultListCellRenderer {
        private PriorityListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, ((TaskPriority)((Object)value)).getName(), index, isSelected, cellHasFocus);
        }
    }

    private static class PriorityCellRenderer
    extends LabelTableCellRenderer<TaskPriority> {
        private final StringCellRenderer stringRenderer;

        public PriorityCellRenderer(SimpleTableModel<TaskTag> model) {
            this.stringRenderer = new StringCellRenderer(model);
        }

        public void formatLabel(JLabel label, JTable table, TaskPriority value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (null == value) {
                return;
            }
            String stringValue = value.getName();
            label.setText(stringValue);
            this.stringRenderer.formatLabel(label, table, stringValue, isSelected, hasFocus, row, column);
        }
    }

    private static class StringCellRenderer
    extends LabelTableCellRenderer<String>
    implements ColorProvider<TaskTag> {
        private final SimpleTableModel<TaskTag> model;

        public StringCellRenderer(SimpleTableModel<TaskTag> model) {
            this.model = model;
        }

        public void formatLabel(JLabel label, JTable table, String value, boolean isSelected, boolean hasFocus, int row, int column) {
            TaskTag tag = (TaskTag)this.model.getRow(row);
            if (!tag.isUserDefined()) {
                label.setFont(label.getFont().deriveFont(2));
            }
            label.setForeground(this.foregroundFor(tag, isSelected ? SELECTED : DISABLED));
        }

        public Color backgroundFor(TaskTag obj, String key) {
            return null;
        }

        public Color foregroundFor(TaskTag obj, String key) {
            if ("selected".equals(key)) {
                return UIManager.getColor("Table.selectionForeground");
            }
            if (!obj.isUserDefined()) {
                return UIManager.getColor("Label.disabledForeground");
            }
            return null;
        }
    }

    private static enum TagTableColumn {
        NAME(SourceTodoArb.get("TODO_NAME"), String.class){

            @Override
            public Object getValue(TaskTag tag) {
                return tag.name();
            }

            @Override
            public void setValue(TaskTag tag, Object value) {
                tag.name(String.valueOf(value));
            }
        }
        ,
        SEARCH_STRING(SourceTodoArb.get("TODO_SEARCH_STRING"), String.class){

            @Override
            public Object getValue(TaskTag tag) {
                return tag.searchString();
            }

            @Override
            public void setValue(TaskTag tag, Object value) {
                tag.searchString(String.valueOf(value));
            }
        }
        ,
        PRIORITY(SourceTodoArb.get("TODO_PRIORITY"), TaskPriority.class){

            @Override
            public Object getValue(TaskTag tag) {
                return tag.priority();
            }

            @Override
            public void setValue(TaskTag tag, Object value) {
                if (value instanceof TaskPriority) {
                    tag.priority((TaskPriority)((Object)value));
                }
            }
        }
        ,
        ENABLED(SourceTodoArb.get("TODO_ENABLED"), Boolean.class){

            @Override
            public Object getValue(TaskTag tag) {
                return tag.enabled();
            }

            @Override
            public void setValue(TaskTag tag, Object value) {
                tag.enabled(Boolean.valueOf(String.valueOf(value)));
            }
        };

        private String name;
        private Class type;

        private TagTableColumn(String name, Class type) {
            this.name = name;
            this.type = type;
        }

        public abstract Object getValue(TaskTag var1);

        public abstract void setValue(TaskTag var1, Object var2);
    }

    private static class TagTableFormat
    implements SimpleTableFormat<TaskTag> {
        private TagTableFormat() {
        }

        public int getColumnCount() {
            return TagTableColumn.values().length;
        }

        public Class<?> getColumnClass(int columnIndex) {
            return TagTableColumn.values()[columnIndex].type;
        }

        public String getColumnName(int columnIndex) {
            return TagTableColumn.values()[columnIndex].name;
        }

        public Object getValueAt(TaskTag tag, int columnIndex) {
            return TagTableColumn.values()[columnIndex].getValue(tag);
        }

        public void setValueAt(TaskTag tag, Object value, int columnIndex) {
            TagTableColumn.values()[columnIndex].setValue(tag, value);
        }

        public boolean isCellEditable(TaskTag tag, int columnIndex) {
            switch (TagTableColumn.values()[columnIndex]) {
                default: {
                    return tag.isUserDefined();
                }
                case ENABLED: 
            }
            return true;
        }
    }
}

