/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.text.Position;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;

public class XmlKeyList
extends JList {
    private final XmlMetadataResolver _resolver;

    public XmlKeyList(Object[] keys, XmlMetadataResolver resolver) {
        super(keys);
        this._resolver = resolver;
        this._finishInit();
    }

    public XmlKeyList(ListModel listModel, XmlMetadataResolver resolver) {
        super(listModel);
        this._resolver = resolver;
        this._finishInit();
    }

    private void _finishInit() {
        this.setCellRenderer(new XmlKeyListCellRenderer());
        this.getSelectionModel().setSelectionMode(0);
    }

    public XmlKey getSelectedXmlKey() {
        Object selectedValue = this.getSelectedValue();
        if (selectedValue instanceof XmlKey) {
            return (XmlKey)selectedValue;
        }
        return null;
    }

    @Override
    public int getNextMatch(String text, int start, Position.Bias bias) {
        ListModel model = this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String name;
            if (!(model.getElementAt(i) instanceof XmlKey) || (name = this._resolver.getShortDisplayName((XmlKey)model.getElementAt(i)).toLowerCase()).compareTo(text) < 0) continue;
            this.ensureIndexIsVisible(i);
            return i;
        }
        return start - 1;
    }

    private class XmlKeyListCellRenderer
    extends DefaultListCellRenderer {
        private XmlKeyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (component instanceof JLabel && value instanceof XmlKey) {
                JLabel label = (JLabel)component;
                XmlKey key = (XmlKey)value;
                label.setIcon(XmlKeyList.this._resolver.getSmallIcon(key));
                label.setText(XmlKeyList.this._resolver.getShortDisplayName(key));
            }
            return component;
        }
    }
}

