/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bali.xml.gui.swing.explorer.SwingExplorerGui;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.javatools.util.AccessibleUtils;
import org.w3c.dom.Node;

public class XmlTreeCellRenderer
implements TreeCellRenderer {
    private static final int MINDISPLAYLENGTH = 20;
    private static final Color _HIGHLIGHT_COLOR = new Color(220, 220, 220);
    private final TreeCellRenderer _delegate;
    private final SwingExplorerGui _gui;

    public XmlTreeCellRenderer(SwingExplorerGui gui, TreeCellRenderer delegate) {
        if (gui == null || delegate == null) {
            throw new IllegalArgumentException("No explorer gui or delegate");
        }
        this._gui = gui;
        this._delegate = delegate;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean isAssistiveTechnologySet = AccessibleUtils.isAssistiveTechnologySet();
        XmlModelUtils.throwIfAccessibilityThreadAccessDisallowed();
        Icon smallIcon = null;
        String tooltip = null;
        String text = "";
        boolean highlight = false;
        if (value != null && !this._gui.isNodeToEvade(value)) {
            smallIcon = this._gui.getIcon(value);
            tooltip = this._gui.getTooltip(value);
            text = this._gui.getTitle(value);
            if (this._gui.getShowHighlightedNodes() && value instanceof Node) {
                highlight = this._gui.__isNodeHighlighted((Node)value);
            }
        }
        if (System.getProperty("oracle.bali.xml.treeCellRenderer.disableTruncate") == null && tree != null && row > -1 && text != null && text.length() > 20) {
            text = this.truncateLongText(tree, row, text);
        }
        Component treeCellRenderer = this._delegate.getTreeCellRendererComponent(tree, text, sel, expanded, leaf, row, hasFocus);
        if (isAssistiveTechnologySet) {
            return treeCellRenderer;
        }
        if (tooltip != null && treeCellRenderer instanceof JComponent) {
            ((JComponent)treeCellRenderer).setToolTipText(tooltip);
        }
        if (smallIcon != null && treeCellRenderer instanceof JLabel) {
            ((JLabel)treeCellRenderer).setIcon(smallIcon);
        }
        if (this._gui.getShowHighlightedNodes()) {
            if (highlight && !sel) {
                if (treeCellRenderer instanceof JComponent) {
                    ((JComponent)treeCellRenderer).setOpaque(true);
                }
                treeCellRenderer.setBackground(this.getHighlightedNodeColor());
            } else if (treeCellRenderer instanceof JComponent) {
                ((JComponent)treeCellRenderer).setOpaque(false);
            }
        }
        return treeCellRenderer;
    }

    protected Color getHighlightedNodeColor() {
        return _HIGHLIGHT_COLOR;
    }

    private String truncateLongText(JTree tree, int row, String text) {
        FontMetrics treeFontMetrics;
        Font treeFont;
        String truncatedText = null;
        int viewPortWidth = 0;
        Container parent = tree.getParent();
        if (parent != null && !(parent instanceof JViewport)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            viewPortWidth = parent.getWidth();
        }
        if (viewPortWidth > 0 && (treeFont = tree.getFont()) != null && (treeFontMetrics = tree.getFontMetrics(treeFont)) != null) {
            int textWidth = treeFontMetrics.stringWidth(text);
            int suffixWidth = treeFontMetrics.stringWidth("...");
            TreePath treePath = tree.getPathForRow(row);
            if (treePath != null) {
                int maxWidth;
                int childIndent = 20;
                int depth = treePath.getPathCount() - 1;
                int depthOffset = 0;
                int nodeXOffset = 0;
                if (depth > 0) {
                    nodeXOffset = childIndent * (depth + depthOffset);
                }
                if (textWidth > (maxWidth = 2 * viewPortWidth - nodeXOffset)) {
                    int textLen;
                    int charIdx = 0;
                    int n = textLen = charIdx < text.length() ? treeFontMetrics.charWidth(text.charAt(charIdx)) : 0;
                    while (charIdx < text.length() && textLen < maxWidth - suffixWidth) {
                        textLen += treeFontMetrics.charWidth(text.charAt(++charIdx));
                    }
                    if (charIdx < 20) {
                        charIdx = text.length() > 20 ? 20 : text.length();
                    }
                    if (charIdx < text.length()) {
                        truncatedText = new String(text.substring(0, charIdx) + "...");
                    }
                }
            }
        }
        if (truncatedText == null) {
            return text;
        }
        return truncatedText;
    }
}

