/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Readers;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.json.JSONEncoder;
import oracle.dbtools.json.JSONIOExceptionImpl;
import oracle.dbtools.plugin.api.json.JSONIOException;
import oracle.dbtools.plugin.api.json.JSONToken;
import oracle.dbtools.plugin.api.json.JSONWriter;

class JSONWriterImpl
implements JSONWriter {
    private final Deque<NodeState> state = new ArrayDeque<NodeState>();
    private final Appendable stream;
    private static final String QUOTE = "\"";

    public JSONWriterImpl(Appendable stream) {
        this.stream = stream;
    }

    public JSONWriter append(JSONToken token) throws JSONIOException {
        switch (token.type()) {
            case END_ARRAY: {
                return this.endArray();
            }
            case END_OBJECT: {
                return this.endObject();
            }
            case PROPERTY_NAME: {
                return this.propertyName(token.propertyName());
            }
            case NULL_VALUE: {
                return this.nullValue();
            }
            case BOOLEAN_VALUE: {
                return this.value(token.booleanValue());
            }
            case NUMERIC_VALUE: {
                return this.value(token.numberValue());
            }
            case STRING_VALUE: {
                return this.value(token.stringValue());
            }
            case START_ARRAY: {
                return this.startArray();
            }
            case START_OBJECT: {
                return this.startObject();
            }
        }
        throw new IllegalStateException();
    }

    public void close() throws IOException {
        if (this.stream instanceof Closeable) {
            ((Closeable)((Object)this.stream)).close();
        }
    }

    public JSONWriter endArray() {
        if (!this.state.isEmpty()) {
            this.state.pop();
            this._closeArray();
            this.hasPrevious(true);
        }
        return this;
    }

    public JSONWriter endObject() throws JSONIOException {
        if (!this.state.isEmpty()) {
            this.state.pop();
            this._closeBrace();
            this.hasPrevious(true);
        }
        return this;
    }

    public void flush() {
        if (this.stream instanceof Flushable) {
            try {
                ((Flushable)((Object)this.stream)).flush();
            }
            catch (IOException e) {
                throw JSONIOExceptionImpl.wrap(e);
            }
        }
    }

    public JSONWriter property(String name, CharSequence value) throws JSONIOException {
        this.propertyName(name);
        this.value(value);
        return this;
    }

    public JSONWriter propertyName(String name) throws JSONIOException {
        this.checkForPrevious(false);
        this._quote();
        this._escape(name);
        this._colon();
        return this;
    }

    public JSONWriter nullValue() throws JSONIOException {
        this._value(null);
        return this;
    }

    public JSONWriter value(Boolean value) throws JSONIOException {
        if (value == null) {
            this._value(null);
        } else {
            this._value(this.toReader(value));
        }
        return this;
    }

    public JSONWriter value(CharSequence value) throws JSONIOException {
        return this.value(Readers.reader((CharSequence)value));
    }

    public JSONWriter value(Number value) throws JSONIOException {
        if (value == null) {
            this._value(null);
        } else {
            String text = JSONWriterImpl.string(value);
            this._value(Readers.reader((CharSequence)text));
        }
        return this;
    }

    public JSONWriter value(Reader value) throws JSONIOException {
        if (value == null) {
            this._value(null);
        } else {
            CharSequence encoded = JSONEncoder.encode(value);
            StringBuilder quoted = new StringBuilder(encoded.length() + 2);
            quoted.append(QUOTE);
            quoted.append(encoded);
            quoted.append(QUOTE);
            this._value(Readers.reader((CharSequence)quoted));
        }
        return this;
    }

    public JSONWriter startArray() {
        if (!this.state.isEmpty() && this.state.peek().hasPrevious) {
            this._comma();
        }
        this._openArray();
        this.state.push(new NodeState(NodeState.Type.ARRAY));
        return this;
    }

    public JSONWriter startObject() throws JSONIOException {
        if (!this.state.isEmpty() && this.state.peek().hasPrevious) {
            this._comma();
        }
        this._openBrace();
        this.state.push(new NodeState(NodeState.Type.OBJECT));
        return this;
    }

    private void _closeArray() {
        this.print("]");
    }

    private void _closeBrace() {
        this.print("}");
    }

    private void _colon() {
        this.print("\":");
    }

    private void _comma() {
        this.print(",");
    }

    private void _escape(CharSequence value) {
        this.print(JSONEncoder.encode(Readers.reader((CharSequence)value)));
    }

    private void _null() {
        this.print("null");
    }

    private void _openArray() {
        this.print("[");
    }

    private void _openBrace() {
        this.print("{");
    }

    private void _quote() {
        this.print(QUOTE);
    }

    private void _value(Readable value) {
        this.checkForPrevious(true);
        if (value == null) {
            this._null();
        } else {
            try {
                StreamCopy.drain((Readable)value, (Appendable)this.stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.hasPrevious(true);
    }

    private void checkForPrevious(boolean withinArray) {
        boolean doComma = false;
        if (!this.state.isEmpty()) {
            NodeState state = this.state.peek();
            if (state.hasPrevious) {
                doComma = true;
            }
        }
        if (doComma) {
            this._comma();
            this.hasPrevious(false);
        }
    }

    private void hasPrevious(boolean value) {
        if (!this.state.isEmpty()) {
            this.state.peek().hasPrevious = value;
        }
    }

    private void print(CharSequence s) {
        try {
            this.stream.append(s);
        }
        catch (IOException e) {
            throw JSONIOExceptionImpl.wrap(e);
        }
    }

    private Reader toReader(boolean value) {
        return value ? Readers.reader((CharSequence)"true") : Readers.reader((CharSequence)"false");
    }

    private static String string(Number value) {
        double d;
        boolean quote = false;
        String text = PrimitiveTypes.string((Object)value);
        if (value != null && (Double.isNaN(d = value.doubleValue()) || Double.isInfinite(d))) {
            quote = true;
        }
        if (quote) {
            text = QUOTE + text + QUOTE;
        }
        return text;
    }

    private static final class NodeState {
        boolean hasPrevious = false;
        final Type type;

        NodeState(Type type) {
            this.type = type;
        }

        static enum Type {
            ARRAY,
            OBJECT;

        }
    }
}

