/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import javax.xml.namespace.QName;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Readers;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.json.JSONEncoder;
import oracle.dbtools.json.JSONIOExceptionImpl;

public class JSONFormatter
implements Closeable {
    private final Stack<NodeState> state = new Stack();
    private final Appendable w;
    private static final String QUOTE = "\"";
    private static final QName TEXT = new QName("$t");

    public JSONFormatter(Appendable stream) {
        this.w = stream;
    }

    @Override
    public void close() throws IOException {
        Closeables.close((Object)this.w);
    }

    public void end() {
        if (!this.state.isEmpty()) {
            this.state.pop();
            this._closeBrace();
            this.hasPrevious(true);
        }
    }

    public void endArray() {
        if (!this.state.isEmpty()) {
            this.state.pop();
            this._closeArray();
            this.hasPrevious(true);
        }
    }

    public void flush() {
        if (this.w instanceof Flushable) {
            try {
                ((Flushable)((Object)this.w)).flush();
            }
            catch (IOException e) {
                throw JSONIOExceptionImpl.wrap(e);
            }
        }
    }

    public void name(QName name) {
        this.checkForPrevious(false);
        StringBuilder n = new StringBuilder();
        String prefix = name.getPrefix();
        String localPart = name.getLocalPart();
        if (!NullOrEmpty.nullOrEmpty((CharSequence)prefix)) {
            n.append(prefix);
            n.append("$");
        }
        n.append(localPart);
        this._quote();
        this._escape(n);
        this._colon();
    }

    public void property(QName name, CharSequence value) {
        this.name(name);
        this.value(value);
    }

    public void start() {
        if (!this.state.isEmpty() && this.state.peek().hasPrevious) {
            this._comma();
        }
        this._openBrace();
        this.state.push(new NodeState(NodeState.Type.OBJECT));
    }

    public void startArray() {
        this._openArray();
        this.state.push(new NodeState(NodeState.Type.ARRAY));
    }

    public void text(CharSequence text) {
        this.property(TEXT, text);
    }

    public void value(Boolean value) {
        if (value == null) {
            this._value(null);
        } else {
            this._value(this.toReader(value));
        }
    }

    public void value(CharSequence value) {
        this.value(Readers.reader((CharSequence)value));
    }

    public void value(Number value) {
        if (value == null) {
            this._value(null);
        } else {
            String text = JSONFormatter.string(value);
            this._value(Readers.reader((CharSequence)text));
        }
    }

    private static String string(Number value) {
        double d;
        boolean quote = false;
        String text = PrimitiveTypes.string((Object)value);
        if (value != null && (Double.isNaN(d = value.doubleValue()) || Double.isInfinite(d))) {
            quote = true;
        }
        if (quote) {
            text = QUOTE + text + QUOTE;
        }
        return text;
    }

    public void value(Reader value) {
        if (value == null) {
            this._value(null);
        } else {
            CharSequence encoded = JSONEncoder.encode(value);
            StringBuilder quoted = new StringBuilder(encoded.length() + 2);
            quoted.append(QUOTE);
            quoted.append(encoded);
            quoted.append(QUOTE);
            this._value(Readers.reader((CharSequence)quoted));
        }
    }

    private void _closeArray() {
        this.print("]");
    }

    private void _closeBrace() {
        this.print("}");
    }

    private void _colon() {
        this.print("\":");
    }

    private void _comma() {
        this.print(",");
    }

    private void _escape(CharSequence value) {
        this.print(JSONEncoder.encode(Readers.reader((CharSequence)value)));
    }

    private void _null() {
        this.print("null");
    }

    private void _openArray() {
        this.print("[");
    }

    private void _openBrace() {
        this.print("{");
    }

    private void _quote() {
        this.print(QUOTE);
    }

    private void print(CharSequence s) {
        try {
            this.w.append(s);
        }
        catch (IOException e) {
            throw JSONIOExceptionImpl.wrap(e);
        }
    }

    private void _value(Readable value) {
        this.checkForPrevious(true);
        if (value == null) {
            this._null();
        } else {
            try {
                StreamCopy.drain((Readable)value, (Appendable)this.w);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.hasPrevious(true);
    }

    private void checkForPrevious(boolean withinArray) {
        boolean doComma = false;
        if (!this.state.isEmpty()) {
            NodeState state = this.state.peek();
            if (state.hasPrevious) {
                doComma = true;
            }
        }
        if (doComma) {
            this._comma();
            this.hasPrevious(false);
        }
    }

    private void hasPrevious(boolean value) {
        if (!this.state.isEmpty()) {
            this.state.peek().hasPrevious = value;
        }
    }

    private Reader toReader(boolean value) {
        return value ? Readers.reader((CharSequence)"true") : Readers.reader((CharSequence)"false");
    }

    private static final class NodeState {
        boolean hasPrevious = false;
        Type type;

        NodeState(Type type) {
            this.type = type;
        }

        static enum Type {
            ARRAY,
            OBJECT;

        }
    }
}

