/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.profile;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ide.Identifiable;
import javax.ide.extension.ExtensionRegistry;
import javax.swing.Icon;
import oracle.ide.explorer.IconOverlay;
import oracle.javatools.util.ResourcePicker;
import oracle.javatools.util.TranslationControl;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.generic.profile.InitializableProfileObject;
import oracle.jdevimpl.vcs.generic.profile.StatusesInfo;
import oracle.jdevimpl.vcs.generic.util.AbstractIdentifiable;

public class StatusInfo
extends AbstractIdentifiable
implements InitializableProfileObject,
VCSStatus,
ChangeListStatus,
Comparable<StatusInfo> {
    private static final Logger sLogger = Logger.getLogger(StatusInfo.class.getName());
    private static final Map<String, String> sIconReferences = new HashMap<String, String>(7);
    private StatusesInfo _statusesInfo;
    private boolean _isVersioned;
    private boolean _highlightChangelist;
    private String _shortLabelKey;
    private String _overlayIconKey;
    private String _overlayIconRef;
    private IconOverlay _overlay;
    private boolean _isConflicts;

    @Override
    public final int compareTo(StatusInfo other) {
        return this.getChangeListLabel().compareTo(other.getChangeListLabel());
    }

    public void setConflicts(String isConflicts) {
        this._isConflicts = Boolean.valueOf(isConflicts);
    }

    public boolean isConflicts() {
        return this._isConflicts;
    }

    public void setVersioned(String isVersioned) {
        this._isVersioned = Boolean.valueOf(isVersioned);
    }

    public void setShortLabelKey(String labelKey) {
        this._shortLabelKey = labelKey;
    }

    public void setOverlayIconKey(String iconKey) {
        this._overlayIconKey = iconKey;
    }

    public void setOverlayIconRef(Object o) {
        if (!(o instanceof OverlayIconRefInfo)) {
            throw new IllegalArgumentException("required type: " + OverlayIconRefInfo.class.getName());
        }
        this._overlayIconRef = ((Identifiable)o).getID();
    }

    public void setHighlightChangelist(String trueOrFalse) {
        this._highlightChangelist = Boolean.valueOf(trueOrFalse);
    }

    @Override
    public void preInitialize(Object parent) {
        if (!(parent instanceof StatusesInfo)) {
            throw new IllegalArgumentException();
        }
        this._statusesInfo = (StatusesInfo)parent;
    }

    @Override
    public void postInitialize() {
    }

    @Override
    public boolean isVersioned() {
        return this._isVersioned;
    }

    @Override
    public boolean isCandidate() {
        return !this._isVersioned;
    }

    @Override
    public IconOverlay getOverlay() {
        if (this._overlay == null) {
            ResourcePicker picker = this.getResourcePicker();
            String shortLabel = null;
            Icon iconOverlay = null;
            if (picker != null) {
                shortLabel = this._shortLabelKey != null ? picker.getString(this._shortLabelKey) : null;
                Icon icon = iconOverlay = this._overlayIconKey != null ? picker.getImage(this._overlayIconKey) : null;
            }
            if (iconOverlay == null) {
                iconOverlay = this.resolveIconReference(this._overlayIconRef);
            }
            this._overlay = new IconOverlay(iconOverlay, null, shortLabel);
        }
        return this._overlay;
    }

    @Override
    public String getChangeListLabel() {
        IconOverlay overlay = this.getOverlay();
        if (overlay != null) {
            return overlay.getToolTipText();
        }
        return null;
    }

    @Override
    public boolean isChangeListCellHighlighted() {
        return this._highlightChangelist;
    }

    private ResourcePicker getResourcePicker() {
        try {
            String baseName = this._statusesInfo.getFileSystemInfo().getProfileInfo().getRsbundleClass().getName();
            ClassLoader cl = ExtensionRegistry.getExtensionRegistry().getClassLoader(this.getExtensionID());
            ResourceBundle rb = ResourceBundle.getBundle(baseName, Locale.getDefault(), cl, (ResourceBundle.Control)TranslationControl.getClassFormatTranslationControl());
            return new ResourcePicker(rb);
        }
        catch (ClassNotFoundException cnfe) {
            sLogger.severe("unable to load resource bundle class. " + cnfe.getMessage());
            return null;
        }
    }

    private Icon resolveIconReference(String iconRef) {
        String id = sIconReferences.get(iconRef);
        if (id != null) {
            return VCSIconArb.getIcon(id);
        }
        return null;
    }

    static {
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_ADDED", "extras/overlay_added.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CHECKED_IN", "extras/overlay_checkedin.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CHECKED_OUT", "extras/overlay_checkedout.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CHECKED_OUT_UNRESERVED", "extras/overlay_checkedoutunreserved.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CONFLICTS", "extras/overlay_conflicts.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_MODIFIED", "extras/overlay_modified.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_REMOVED", "extras/overlay_removed.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNADDED", "extras/overlay_unversioned.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNVERSIONED", "extras/overlay_unversioned.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_NOT_AUTHENTICATED", "extras/overlay_locked.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_IGNORED", "extras/overlay_ignored.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNMODIFIED", "extras/overlay_unmodified.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_BRANCHED", "extras/overlay_branched.png");
    }

    public static final class OverlayIconRefInfo
    extends AbstractIdentifiable {
        public void setIconId(String id) {
            this.setID(id);
        }

        public String getIconId() {
            return this.getID();
        }
    }
}

