/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.esax;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.DynamicHook;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.spi.Stack;
import oracle.jdeveloper.vcs.generic.ActionRequirement;
import oracle.jdevimpl.vcs.generic.ProfileInfoRegistry;
import oracle.jdevimpl.vcs.generic.profile.ActionAffectsInfo;
import oracle.jdevimpl.vcs.generic.profile.ActionInfo;
import oracle.jdevimpl.vcs.generic.profile.ActionRequiresInfo;
import oracle.jdevimpl.vcs.generic.profile.ActionsInfo;
import oracle.jdevimpl.vcs.generic.profile.AutomaticActionInfo;
import oracle.jdevimpl.vcs.generic.profile.BaseInfo;
import oracle.jdevimpl.vcs.generic.profile.ChangeListInfo;
import oracle.jdevimpl.vcs.generic.profile.ClientInfoInfo;
import oracle.jdevimpl.vcs.generic.profile.EventBusInfo;
import oracle.jdevimpl.vcs.generic.profile.FileSystemHelperInfo;
import oracle.jdevimpl.vcs.generic.profile.FileSystemInfo;
import oracle.jdevimpl.vcs.generic.profile.HistoryPropertyInfo;
import oracle.jdevimpl.vcs.generic.profile.HistoryProviderInfo;
import oracle.jdevimpl.vcs.generic.profile.InitializableProfileObject;
import oracle.jdevimpl.vcs.generic.profile.MenusInfo;
import oracle.jdevimpl.vcs.generic.profile.PendingChangesInfo;
import oracle.jdevimpl.vcs.generic.profile.ProfileInfo;
import oracle.jdevimpl.vcs.generic.profile.PropertyInfo;
import oracle.jdevimpl.vcs.generic.profile.PropertyProviderInfo;
import oracle.jdevimpl.vcs.generic.profile.RefreshActionInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionsInfo;
import oracle.jdevimpl.vcs.generic.profile.SimpleIdentifiableInfo;
import oracle.jdevimpl.vcs.generic.profile.StatusInfo;
import oracle.jdevimpl.vcs.generic.profile.StatusesInfo;
import oracle.jdevimpl.vcs.generic.profile.VCSHookInfo;
import oracle.jdevimpl.vcs.generic.util.DelegatingURLFilter;
import oracle.jdevimpl.vcs.generic.util.SimpleStatusFilter;

public class VCSHookHandler
extends DynamicHook {
    private static final String VCS_HOOK_NAMESPACE = "http://xmlns.oracle.com/jdeveloper/vcshook";
    private static final Map sTypeMap = new HashMap(10);
    private static final Map sIgnorableAttributes = new HashMap(10);
    private static final String sI18NStringKey = VCSHookHandler.class.getName() + ".i18nStringKey";
    private final Stack _rskeyElementIndicators = new Stack();
    private final I18NStringVisitor _i18nHandler = new I18NStringVisitor(){

        protected void string(ElementContext context, String translatedString) {
            context.getScopeData().put(sI18NStringKey, translatedString);
        }
    };

    public VCSHookHandler() {
        this(ProfileInfoRegistry.getInstance());
    }

    public VCSHookHandler(Object rootObject) {
        super(rootObject);
        this.registerElementTypeResolver(new DynamicHook.ElementTypeResolver(){

            public Class resolveType(ElementName elementName) {
                return (Class)sTypeMap.get(elementName.getLocalName());
            }
        });
    }

    protected String getHookNamespaceURI() {
        return VCS_HOOK_NAMESPACE;
    }

    protected void handleComplexElementStart(Object applicationObject, ElementStartContext context) {
        if (applicationObject instanceof BaseInfo) {
            ((BaseInfo)applicationObject).initExtensionID(context.getExtension().getID());
        }
        if (applicationObject instanceof ProfileInfo) {
            ProfileInfo p = (ProfileInfo)applicationObject;
            p.setRsbundleClass((String)context.getScopeData().get("rsbundleclass"));
            p.setID(context.getExtension().getID());
        }
        Collection c = context.getAttributeNames();
        for (String attrName : c) {
            if (this.isIgnorableAttribute(attrName)) continue;
            String attrValue = context.getAttributeValue(attrName);
            Method m = this.findMethod((ElementContext)context, applicationObject, attrName, new Class[]{String.class});
            try {
                m.invoke(applicationObject, attrValue);
            }
            catch (InvocationTargetException ite) {
                this.log((ElementContext)context, Level.SEVERE, "Unable to attach data '" + attrValue + "' to " + applicationObject.toString() + " for attribute '" + attrName + "' using method '" + m.getName());
                ite.getTargetException().printStackTrace();
            }
            catch (Exception e) {
                this.log((ElementContext)context, Level.SEVERE, "Unable to attach data '" + attrValue + "' to " + applicationObject.toString() + " for attribute '" + attrName + "' using method '" + m.getName());
                e.printStackTrace();
            }
        }
    }

    protected void handleSimpleElementStart(ElementStartContext context) {
        String key = context.getAttributeValue("rskey");
        if (key != null && key.length() > 0) {
            this._rskeyElementIndicators.push((Object)Boolean.TRUE);
            this._i18nHandler.start(context);
        } else {
            this._rskeyElementIndicators.push((Object)Boolean.FALSE);
        }
    }

    protected void attachData(Object parent, String data, ElementEndContext context) {
        if (((Boolean)this._rskeyElementIndicators.pop()).booleanValue()) {
            this._i18nHandler.end(context);
            data = (String)context.getScopeData().get(sI18NStringKey);
            context.getScopeData().remove(sI18NStringKey);
        }
        super.attachData(parent, data, context);
    }

    protected void invokePreInitialize(Object parent, Object target) {
        if (target instanceof InitializableProfileObject) {
            try {
                ((InitializableProfileObject)target).preInitialize(parent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void invokePostInitialize(Object target) {
        if (target instanceof InitializableProfileObject) {
            try {
                ((InitializableProfileObject)target).postInitialize();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isIgnorableAttribute(String attrName) {
        return sIgnorableAttributes.containsKey(attrName);
    }

    static {
        sTypeMap.put("vcs-hook", VCSHookInfo.class);
        sTypeMap.put("vcs-profile", ProfileInfo.class);
        sTypeMap.put("client-info", ClientInfoInfo.class);
        sTypeMap.put("property", PropertyInfo.class);
        sTypeMap.put("file-system", FileSystemInfo.class);
        sTypeMap.put("url-filter", DelegatingURLFilter.class);
        sTypeMap.put("helper", FileSystemHelperInfo.class);
        sTypeMap.put("statuses", StatusesInfo.class);
        sTypeMap.put("cache-policy", StatusesInfo.CachePolicyInfo.class);
        sTypeMap.put("status", StatusInfo.class);
        sTypeMap.put("overlay-icon-ref", StatusInfo.OverlayIconRefInfo.class);
        sTypeMap.put("status-filter", SimpleStatusFilter.class);
        sTypeMap.put("accept-status", SimpleStatusFilter.StatusRef.class);
        sTypeMap.put("reject-status", SimpleStatusFilter.StatusRef.class);
        sTypeMap.put("event-bus", EventBusInfo.class);
        sTypeMap.put("actions", ActionsInfo.class);
        sTypeMap.put("refresh-action", RefreshActionInfo.class);
        sTypeMap.put("action", ActionInfo.class);
        sTypeMap.put("icon-ref", ActionInfo.IconRefInfo.class);
        sTypeMap.put("requires", ActionRequiresInfo.class);
        sTypeMap.put("requirement", ActionRequirement.class);
        sTypeMap.put("affects", ActionAffectsInfo.class);
        sTypeMap.put("url-filter-ref", ActionAffectsInfo.UrlFilterRef.class);
        sTypeMap.put("status-filter-ref", ActionAffectsInfo.StatusFilterRef.class);
        sTypeMap.put("automatic-action", AutomaticActionInfo.class);
        sTypeMap.put("menus", MenusInfo.class);
        sTypeMap.put("vcs-menu", SectionsInfo.class);
        sTypeMap.put("section", SectionInfo.class);
        sTypeMap.put("item", SectionInfo.ItemInfo.class);
        sTypeMap.put("history-provider", HistoryProviderInfo.class);
        sTypeMap.put("history-property", HistoryPropertyInfo.class);
        sTypeMap.put("property-provider", PropertyProviderInfo.class);
        sTypeMap.put("pending-changes", PendingChangesInfo.class);
        sTypeMap.put("change-list", ChangeListInfo.class);
        sTypeMap.put("display-property", ChangeListInfo.CLDisplayPropertyInfo.class);
        sTypeMap.put("visible-statuses", ChangeListInfo.VisibleStatusesInfo.class);
        sTypeMap.put("conflict-statuses", ChangeListInfo.ConflictStatusesInfo.class);
        sTypeMap.put("status-ref", SimpleIdentifiableInfo.class);
        sTypeMap.put("toolbar", SectionsInfo.class);
        sTypeMap.put("context-menu", SectionsInfo.class);
        sIgnorableAttributes.put("xmlns", null);
        sIgnorableAttributes.put("class", null);
    }
}

