/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSURLBasedCacheEvent;
import oracle.jdeveloper.vcs.spi.VCSURLBasedCacheListener;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;

@Deprecated
public abstract class VCSURLBasedCache
extends Observable {
    private final Map<VCSHashURL, Object> _cache = Collections.synchronizedMap(new HashMap());
    private final Collection<VCSURLBasedCacheListener> _listeners = new CopyOnWriteArrayList<VCSURLBasedCacheListener>();
    private final Object _writeLock = new Object();

    public final void addCacheListener(VCSURLBasedCacheListener l) {
        this._listeners.add(l);
    }

    public final void removeCacheListener(VCSURLBasedCacheListener l) {
        this._listeners.remove(l);
    }

    public Object getValue(URL url) throws Exception {
        return this.getValues(new URL[]{url})[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getValues(URL[] urls) throws Exception {
        Object[] values = this.getCachedValues(urls);
        BitSet bits = new BitSet(urls.length);
        for (int i = 0; i < urls.length; ++i) {
            bits.set(i, values[i] == null);
        }
        if (bits.isEmpty()) {
            return values;
        }
        int n = bits.cardinality();
        URL[] urls2 = new URL[n];
        Object[] values2 = this.createValueArray(n);
        int j = 0;
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            urls2[j++] = urls[i];
        }
        Object i = this._writeLock;
        synchronized (i) {
            this.getValuesImpl(urls2, values2);
            this.populateCachedValues(urls2, values2);
        }
        j = 0;
        for (int i2 = 0; i2 < bits.length(); ++i2) {
            if (!bits.get(i2)) continue;
            values[i2] = values2[j++];
        }
        return values;
    }

    public void clearValues() {
        this.clearValues(VCSURLFilters.createNullFilter(), true);
    }

    public void clearValue(URL url) {
        this.clearValues(VCSURLFilters.createSpecificURLFilter(new URL[]{url}));
    }

    public void clearValues(URL[] urls) {
        this.clearValues(VCSURLFilters.createSpecificURLFilter(urls));
    }

    public void clearValues(URLFilter filter) {
        this.clearValues(filter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearValues(URLFilter filter, boolean invalidate) {
        Object object = this._writeLock;
        synchronized (object) {
            ArrayList<URL> urls = new ArrayList<URL>();
            Map<VCSHashURL, Object> map = this._cache;
            synchronized (map) {
                Iterator<VCSHashURL> itr = this._cache.keySet().iterator();
                while (itr.hasNext()) {
                    URL url = itr.next().getURL();
                    if (!filter.accept(url)) continue;
                    itr.remove();
                    urls.add(url);
                }
            }
            final URL[] urls0 = urls.toArray(new URL[urls.size()]);
            this.fireValuesCleared(urls0, filter, invalidate);
            if (urls.isEmpty()) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public final void run() {
                    VCSURLBasedCache.this.setChanged();
                    VCSURLBasedCache.this.notifyObservers(urls0);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] searchValues(URLFilter filter) {
        HashSet<VCSHashURL> urls = new HashSet<VCSHashURL>();
        Map<VCSHashURL, Object> map = this._cache;
        synchronized (map) {
            for (VCSHashURL url : this._cache.keySet()) {
                if (!filter.accept(url.getURL())) continue;
                urls.add(url);
            }
        }
        return VCSHashURL.convertToURLs(urls).toArray(new URL[0]);
    }

    public final Object[] getValuesImpl(URL[] urls) throws Exception {
        Object[] values = this.createValueArray(urls.length);
        this.getValuesImpl(urls, values);
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runUnderWriteLock(Runnable runnable) {
        Object object = this._writeLock;
        synchronized (object) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <V> V callUnderWriteLock(Callable<V> callable) throws Exception {
        Object object = this._writeLock;
        synchronized (object) {
            return callable.call();
        }
    }

    protected abstract void getValuesImpl(URL[] var1, Object[] var2) throws Exception;

    protected Object[] createValueArray(int length) {
        return new Object[length];
    }

    protected Object getValueInternal(URL url) {
        return this.getValueInternal(new VCSHashURL(url));
    }

    protected Object getValueInternal(VCSHashURL url) {
        return this._cache.get(url);
    }

    protected void putValueInternal(URL url, Object value) {
        this.putValueInternal(new VCSHashURL(url), value);
    }

    protected void putValueInternal(VCSHashURL url, Object value) {
        this._cache.put(url, value);
    }

    protected void clearValuesInternal() {
        this._cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void recache(URL oldUrl, URL newUrl) {
        Object object = this._writeLock;
        synchronized (object) {
            Object oldValue = this.getValueInternal(oldUrl);
            this.clearValue(oldUrl);
            if (oldValue != null) {
                this.putValueInternal(newUrl, oldValue);
            }
            this.fireValueRecached(oldUrl, newUrl, oldValue);
        }
    }

    private final Object[] getCachedValues(URL[] urls) {
        urls = VCSFileSystemUtils.removeRefAndQueryParts(urls);
        Object[] values = this.createValueArray(urls.length);
        for (int i = 0; i < urls.length; ++i) {
            values[i] = this.getValueInternal(urls[i]);
        }
        return values;
    }

    private final void populateCachedValues(URL[] urls, Object[] values) {
        urls = VCSFileSystemUtils.removeRefAndQueryParts(urls);
        for (int i = 0; i < urls.length; ++i) {
            this.putValueInternal(urls[i], values[i]);
        }
        this.fireValuesCached(urls, values);
    }

    private final void fireValuesCleared(URL[] urls, URLFilter filter, boolean invalidate) {
        VCSURLBasedCacheEvent e = new VCSURLBasedCacheEvent((Object)this, urls, filter, invalidate);
        for (VCSURLBasedCacheListener l : this._listeners) {
            l.valuesCleared(e);
        }
    }

    private final void fireValuesCached(URL[] urls, Object[] values) {
        VCSURLBasedCacheEvent e = new VCSURLBasedCacheEvent(this, urls, values);
        for (VCSURLBasedCacheListener l : this._listeners) {
            l.valuesCached(e);
        }
    }

    private final void fireValueRecached(URL oldUrl, URL newUrl, Object value) {
        VCSURLBasedCacheEvent e = new VCSURLBasedCacheEvent((Object)this, oldUrl, newUrl, value);
        for (VCSURLBasedCacheListener l : this._listeners) {
            l.valueRecached(e);
        }
    }

    public void dispose() {
    }

    public VCSURLBasedCache newLocalCache() {
        return new Local(this);
    }

    public boolean isLocalCache() {
        return this.getClass() == Local.class;
    }

    private static final class Local
    extends VCSURLBasedCache {
        private final LocalCacheSupport _support;

        Local(VCSURLBasedCache globalCache) {
            this._support = new LocalCacheSupport(this, globalCache);
        }

        @Override
        protected void getValuesImpl(URL[] urls, Object[] values) throws Exception {
            this._support.getValuesImpl(urls, values);
        }

        @Override
        public void dispose() {
            this._support.dispose();
        }

        @Override
        public VCSURLBasedCache newLocalCache() {
            return new Local(this._support.getGlobalCache());
        }
    }

    static final class LocalCacheSupport {
        private final VCSURLBasedCache _localCache;
        private final VCSURLBasedCache _globalCache;
        private final VCSURLBasedCacheListener _l = new VCSURLBasedCacheListener(){

            @Override
            public void valuesCleared(final VCSURLBasedCacheEvent ce) {
                _localCache.runUnderWriteLock(new Runnable(){

                    @Override
                    public final void run() {
                        _localCache.clearValues(ce.getFilter(), ce.isInvalidate());
                    }
                });
            }

            @Override
            public void valueRecached(final VCSURLBasedCacheEvent ce) {
                _localCache.runUnderWriteLock(new Runnable(){

                    @Override
                    public final void run() {
                        _localCache.recache(ce.getOldURL(), ce.getNewURL());
                    }
                });
            }
        };

        LocalCacheSupport(VCSURLBasedCache localCache, VCSURLBasedCache globalCache) {
            this._localCache = localCache;
            this._globalCache = globalCache;
            this._globalCache.addCacheListener(this._l);
        }

        final void getValuesImpl(URL[] urls, Object[] values) throws Exception {
            this._globalCache.getValuesImpl(urls, values);
        }

        final void dispose() {
            this._globalCache.removeCacheListener(this._l);
        }

        final VCSURLBasedCache getGlobalCache() {
            return this._globalCache;
        }
    }
}

