/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Transform;

public class TransformIterator<X, Y>
implements Iterator<Y>,
Closeable {
    private final Iterator<X> items;
    private final Transform<X, Y> transform;

    public TransformIterator(Iterator<X> items, Transform<X, Y> transform) {
        this.items = items;
        this.transform = transform;
    }

    @Override
    public void close() throws IOException {
        Closeables.close(this.items);
    }

    @Override
    public boolean hasNext() {
        return this.items.hasNext();
    }

    @Override
    public Y next() {
        return this.transform.apply(this.items.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.items.toString();
    }
}

