/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import oracle.dbtools.common.CommonMessages;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Log;

public abstract class Projects {
    private static final int CLASSES_FOLDER_DEPTH = 2;
    private static final String EXPECTED_FILE = "build.xml";
    private static final Log LOG = Log.get(Projects.class);

    private Projects() {
    }

    public static File project(Class<?> type) {
        File expected;
        File classesFolder;
        CodeSource codeSource = type.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw UnrecoverableException.unrecoverable(new TranslatableMessage(CommonMessages.class, "Projects.0", "Cannot determine code source for: ", type.getName()));
        }
        URL location = codeSource.getLocation();
        File parent = classesFolder = Projects.file(location);
        for (int i = 0; i < 2; ++i) {
            if ((parent = parent.getParentFile()) != null) continue;
            throw UnrecoverableException.unrecoverable(new TranslatableMessage(CommonMessages.class, "Projects.1", "Cannot locate project relative to: ", classesFolder.getAbsolutePath()));
        }
        if (LOG.isLoggable(Log.WARNING) && !(expected = Files.file(parent, EXPECTED_FILE)).exists()) {
            LOG.warning("Could not verify code source URL: " + location.toExternalForm() + " for type: " + type);
            LOG.warning("Cannot verify : " + expected.getAbsolutePath() + " is a project root, file: " + EXPECTED_FILE + " was not found");
        }
        return parent;
    }

    private static File file(URL url) {
        File f;
        try {
            f = Files.file(url.toURI());
        }
        catch (URISyntaxException e) {
            f = Files.file(url.getPath());
        }
        return f;
    }
}

