/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.IdentityHashMap;

public class Invocations {
    private final Appendable out;
    private int var = 0;
    private final IdentityHashMap<Object, String> variables = new IdentityHashMap();
    private static final Class<?>[] PRIMITIVES = new Class[]{String.class, Integer.class, Boolean.class, Double.class, Long.class, Short.class, Byte.class, Character.class, Float.class, BigDecimal.class, BigInteger.class};

    public Invocations(Appendable out) {
        this.out = out;
    }

    public String toString() {
        return this.out.toString();
    }

    public <T> T trace(Object target, Class<T> type) {
        return this.trace(target, type, false);
    }

    private void declare(Object object, Class<?> type, boolean force) {
        if (!Void.TYPE.equals(type) && (force || object != null && !this.variables.containsKey(object) && !this.isPrimitive(type))) {
            try {
                this.out.append(this.typeName(type));
                this.out.append(" ");
                this.out.append(this.register(object));
                this.out.append(";\n");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private boolean isPrimitive(Class<?> type) {
        boolean isPrimitive = type.isPrimitive();
        if (!isPrimitive) {
            for (Class<?> c : PRIMITIVES) {
                if (!c.equals(type)) continue;
                isPrimitive = true;
                break;
            }
        }
        return isPrimitive;
    }

    private String name(Object object) {
        String name = "null";
        if (object != null && (name = this.variables.get(object)) == null) {
            if (this.isPrimitive(object.getClass())) {
                return this.render(object);
            }
            throw new RuntimeException("Could not find name for: " + object);
        }
        return name;
    }

    private String register(Object object) {
        String name = this.variables.get(object);
        if (name == null) {
            name = "v" + ++this.var;
            this.variables.put(object, name);
        }
        return name;
    }

    private String render(Object object) {
        Class<?> type = object.getClass();
        if (String.class.equals(type)) {
            return "\"" + object.toString() + "\"";
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return "(short)" + object.toString();
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return object.toString() + "L";
        }
        if (Character.TYPE.equals(type) || Character.class.equals(type)) {
            return "'" + object.toString() + "'";
        }
        return object.toString();
    }

    private <T> T trace(Object target, Class<T> type, boolean force) {
        Object result = null;
        if (target != null) {
            result = target.getClass().getInterfaces().length > 0 && !this.isPrimitive(target.getClass()) ? type.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), target.getClass().getInterfaces(), (InvocationHandler)new Recorder(target))) : target;
        }
        this.declare(result, type, force);
        return (T)result;
    }

    private String typeName(Class<?> type) {
        if (type.isArray()) {
            return this.typeName(type.getComponentType()) + "[]";
        }
        return type.getName();
    }

    private class Recorder
    implements InvocationHandler {
        private final Object target;

        Recorder(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            Class<?> type = method.getReturnType();
            try {
                result = method.invoke(this.target, args);
            }
            catch (InvocationTargetException e) {
                this.record(null, proxy, method, args);
                Throwable t = e.getCause();
                for (Class<?> ex : method.getExceptionTypes()) {
                    if (!ex.isAssignableFrom(t.getClass())) continue;
                    throw t;
                }
                throw e;
            }
            result = Invocations.this.trace(result, type, true);
            this.record(result, proxy, method, args);
            return result;
        }

        private void record(Object result, Object proxy, Method method, Object[] args) {
            try {
                if (args != null) {
                    Class<?>[] types = method.getParameterTypes();
                    for (int i = 0; i < args.length; ++i) {
                        Invocations.this.declare(args[i], types[i], false);
                    }
                }
                if (result != null) {
                    Invocations.this.out.append(Invocations.this.name(result));
                    Invocations.this.out.append(" = ");
                }
                Invocations.this.out.append(Invocations.this.name(proxy));
                Invocations.this.out.append('.');
                Invocations.this.out.append(method.getName());
                Invocations.this.out.append('(');
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        Invocations.this.out.append(Invocations.this.name(args[i]));
                        if (i >= args.length - 1) continue;
                        Invocations.this.out.append(',');
                    }
                }
                Invocations.this.out.append(");\n");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

