/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.IOException;
import oracle.dbtools.common.util.FilePathSyntaxException;

public abstract class FilePathSyntax {
    private static char CONTROL_CHAR_MAX = (char)31;
    private static char CONTROL_CHAR_MIN = '\u0000';
    private static char[] ILLEGAL_CHARACTERS = new char[]{'<', '>', ':', '\"', '|', '?', '*', '#', ';', '%'};
    private static int MAX_PATH_LENGTH = 1024;
    private static String[] RESERVED_NAMES = new String[]{"CON", "PRN", "AUX", "CLOCK$", "NUL", "COM0", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT0", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};

    private FilePathSyntax() {
    }

    public static void check(CharSequence path) throws IOException {
        SyntaxError error = FilePathSyntax.validate(path);
        if (FilePathSyntax.isError(error)) {
            throw new FilePathSyntaxException(path, error);
        }
    }

    public static boolean isValid(CharSequence path, boolean allowEmpty) {
        if (allowEmpty && (path == null || path.length() == 0)) {
            return true;
        }
        return !FilePathSyntax.isError(FilePathSyntax.validate(path));
    }

    public static SyntaxError validate(CharSequence path) {
        int lastSlash;
        char driveLetter;
        if (path == null) {
            return SyntaxError.NULL;
        }
        if (path.length() > MAX_PATH_LENGTH) {
            return SyntaxError.TOO_LONG;
        }
        String text = path.toString().replace('\\', '/');
        if (text.trim().isEmpty()) {
            return SyntaxError.EMPTY;
        }
        char[] chars = text.toCharArray();
        int length = chars.length;
        if (Character.isWhitespace(chars[0])) {
            return SyntaxError.LEADING_WHITESPACE;
        }
        if (Character.isWhitespace(chars[length - 1])) {
            return SyntaxError.TRAILING_WHITESPACE;
        }
        if ('.' == chars[length - 1]) {
            return SyntaxError.TRAILING_PERIOD;
        }
        int start = 0;
        if (length > 3 && chars[1] == ':' && chars[2] == '/') {
            driveLetter = Character.toLowerCase(chars[0]);
            if (driveLetter >= 'a' && driveLetter <= 'z') {
                start = 2;
            } else {
                return SyntaxError.ILLEGAL_CHARACTER;
            }
        }
        if (length > 4 && chars[0] == '/' && chars[2] == ':' && chars[3] == '/') {
            driveLetter = Character.toLowerCase(chars[1]);
            if (driveLetter >= 'a' && driveLetter <= 'z') {
                start = 3;
            } else {
                return SyntaxError.ILLEGAL_CHARACTER;
            }
        }
        for (int i = start; i < length; ++i) {
            char c = chars[i];
            if (c >= CONTROL_CHAR_MIN && c <= CONTROL_CHAR_MAX) {
                return SyntaxError.ILLEGAL_CHARACTER;
            }
            for (char illegal : ILLEGAL_CHARACTERS) {
                if (illegal != c) continue;
                return SyntaxError.ILLEGAL_CHARACTER;
            }
            if (c == '/' && i < length - 1 && '/' == chars[i + 1]) {
                return SyntaxError.DOUBLE_SLASH;
            }
            if (c != '.' || i >= length - 1 || '.' != chars[i + 1]) continue;
            return SyntaxError.DOUBLE_PERIOD;
        }
        String name = text;
        int lastPeriod = text.lastIndexOf(46);
        if (lastPeriod != -1) {
            name = text.substring(0, lastPeriod);
        }
        if ((lastSlash = name.lastIndexOf(47)) == name.length() - 1) {
            lastSlash = name.lastIndexOf(47, name.length() - 1);
        }
        if (lastSlash != -1) {
            name = name.substring(lastSlash + 1);
        }
        name = name.toUpperCase();
        for (String reserved : RESERVED_NAMES) {
            if (!name.equals(reserved)) continue;
            return SyntaxError.RESERVED_NAME;
        }
        return SyntaxError.NONE;
    }

    private static boolean isError(SyntaxError error) {
        return SyntaxError.NONE != error;
    }

    public static enum SyntaxError {
        DOUBLE_PERIOD,
        DOUBLE_SLASH,
        EMPTY,
        ILLEGAL_CHARACTER,
        LEADING_WHITESPACE,
        NONE,
        NULL,
        RESERVED_NAME,
        TOO_LONG,
        TRAILING_PERIOD,
        TRAILING_WHITESPACE;

    }
}

